/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.HasStatistics;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;
import jas.util.xml.HasXMLRepresentation;
import jas.util.xml.XMLWriter;
import java.util.Observable;

public class Gauss
extends Observable
implements Rebinnable1DHistogramData,
HasStyle,
HasStatistics,
HasXMLRepresentation {
    double[] m_tuple;
    int m_entries;
    double m_max;
    double m_min;
    double m_offset;
    String m_name;
    protected static final int MAXSIZE = 10000;
    private JASHist1DHistogramStyle style;
    private Statistics stats = new GaussStatistics();
    private Statistics paulstats = new PaulStatistics();
    private static final String[] statNames = new String[]{"Entries", "Mean", "RMS"};
    private static final String[] statNames2 = new String[]{"Entries", "Mean", "RMS", "10Entries"};

    public Gauss() {
        this("Gaussian", 1000, 1.0, 0.0, 0.0);
    }

    @Override
    public void writeAsXML(XMLWriter pw) {
        pw.println("<datasource name=\"" + this.getClass().getName() + "\">");
        pw.println("<param type=\"String\" value=\"" + this.m_name + "\"/>");
        pw.println("<param type=\"int\" value=\"" + this.m_entries + "\"/>");
        pw.println("<param type=\"double\" value=\"" + (this.m_max - this.m_min) + "\"/>");
        pw.println("<param type=\"double\" value=\"" + this.m_min + "\"/>");
        pw.println("<param type=\"double\" value=\"" + this.m_offset + "\"/>");
        pw.println("</datasource>");
    }

    public Gauss(String name, int entries, double max, double offX, double offY) {
        if (entries > 10000) {
            throw new IllegalArgumentException("Gauss: Size too big");
        }
        this.m_tuple = new double[10000];
        this.m_entries = entries;
        this.m_min = offX;
        this.m_max = offX + max;
        this.m_offset = offY;
        this.m_name = name;
        for (int j = 0; j < 10000; ++j) {
            double k = Math.random() + Math.random() + Math.random() + Math.random() + Math.random() + Math.random();
            this.m_tuple[j] = k = offX + max * k / 6.0;
        }
    }

    public void setStyle(JASHist1DHistogramStyle style) {
        this.style = style;
    }

    @Override
    public JASHistStyle getStyle() {
        return this.style;
    }

    @Override
    public String getTitle() {
        return this.m_name;
    }

    @Override
    public double getMin() {
        return this.m_min;
    }

    @Override
    public double getMax() {
        return this.m_max;
    }

    @Override
    public boolean isRebinnable() {
        return true;
    }

    @Override
    public String[] getAxisLabels() {
        return null;
    }

    @Override
    public int getBins() {
        return 40;
    }

    @Override
    public int getAxisType() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        Gauss gauss = this;
        synchronized (gauss) {
            this.setChanged();
        }
        double[] hist = new double[bins];
        double binWidth = (max - min) / (double)bins;
        for (int j = 0; j < bins; ++j) {
            hist[j] = this.m_offset;
        }
        for (int k = 0; k < this.m_entries; ++k) {
            int bin;
            double v = this.m_tuple[k];
            if (v < min || (bin = (int)((v - min) / binWidth)) >= bins) continue;
            int n = bin;
            hist[n] = hist[n] + 1.0;
        }
        double[][] result = new double[][]{hist};
        return result;
    }

    public int getSize() {
        return this.m_entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int newSize) {
        if (newSize > 10000) {
            throw new IllegalArgumentException("Gauss: Size too big");
        }
        this.m_entries = newSize;
        Gauss gauss = this;
        synchronized (gauss) {
            this.notifyObservers(new HistogramUpdate(2, true));
        }
    }

    public double getData(int i) {
        return this.m_tuple[i];
    }

    @Override
    public Statistics getStatistics() {
        return this.stats;
    }

    public void setStats() {
        this.stats = this.paulstats;
    }

    public class PaulStatistics
    implements Statistics {
        @Override
        public String[] getStatisticNames() {
            return statNames2;
        }

        @Override
        public double getStatistic(String name) {
            if (name == statNames2[0]) {
                return Gauss.this.m_entries;
            }
            if (name == statNames2[1]) {
                return (Gauss.this.m_max + Gauss.this.m_min) / 2.0;
            }
            if (name == statNames2[2]) {
                return Gauss.this.m_max - Gauss.this.m_min;
            }
            if (name == statNames2[3]) {
                return Gauss.this.m_entries * 10;
            }
            return 0.0;
        }
    }

    private class GaussStatistics
    implements Statistics {
        private GaussStatistics() {
        }

        @Override
        public String[] getStatisticNames() {
            return statNames;
        }

        @Override
        public double getStatistic(String name) {
            if (name == statNames[0]) {
                return Gauss.this.m_entries;
            }
            if (name == statNames[1]) {
                return (Gauss.this.m_max + Gauss.this.m_min) / 2.0;
            }
            if (name == statNames[2]) {
                return Gauss.this.m_max - Gauss.this.m_min;
            }
            return 0.0;
        }
    }
}

