/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.SaveAsPlugin;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.RepaintManager;

public class VectorGraphicsTransferable
implements ClipboardOwner,
Transferable {
    private Component component;
    private static DataFlavor imageFlavor = new DataFlavor("image/x-java-image; class=java.awt.Image", "Image");
    private static Map types = new HashMap();

    public VectorGraphicsTransferable(Component c) {
        this.component = c;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.match(imageFlavor)) {
            Image img = this.component.createImage(this.component.getWidth(), this.component.getHeight());
            Graphics g = img.getGraphics();
            RepaintManager pm = RepaintManager.currentManager(this.component);
            boolean save = pm.isDoubleBufferingEnabled();
            pm.setDoubleBufferingEnabled(false);
            this.component.print(g);
            g.dispose();
            pm.setDoubleBufferingEnabled(save);
            return img;
        }
        SaveAsPlugin type = (SaveAsPlugin)types.get(dataFlavor);
        if (type != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            type.saveAs(this.component, out, null, this.component);
            out.close();
            return new ByteArrayInputStream(out.toByteArray());
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] result = new DataFlavor[types.size() + 1];
        types.keySet().toArray(result);
        result[VectorGraphicsTransferable.types.size()] = imageFlavor;
        return result;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (dataFlavor.match(imageFlavor)) {
            return true;
        }
        return types.containsKey(dataFlavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public static void register(DataFlavor flavor, SaveAsPlugin type) {
        types.put(flavor, type);
    }
}

