/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataSource;
import jas.hist.Handle;
import jas.hist.HasHandles;
import jas.hist.SliceParameters;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.PlotGraphics;
import java.awt.Color;

class SliceData
implements HasHandles,
DataSource {
    private static final int[] signA = new int[]{1, 1, -1, -1};
    private static final int[] signB = new int[]{-1, 1, 1, -1};
    protected SliceParameters parm;

    SliceData(SliceParameters p) {
        this.parm = p;
    }

    void paint(PlotGraphics g, DoubleCoordinateTransformation xt, DoubleCoordinateTransformation yt) {
        g.setColor(Color.lightGray);
        g.drawLine(this.getCornerX(1), this.getCornerY(1), this.getCornerX(2), this.getCornerY(2));
        g.drawLine(this.getCornerX(2), this.getCornerY(2), this.getCornerX(3), this.getCornerY(3));
        g.drawLine(this.getCornerX(3), this.getCornerY(3), this.getCornerX(0), this.getCornerY(0));
        g.setColor(Color.black);
        g.drawLine(this.getCornerX(0), this.getCornerY(0), this.getCornerX(1), this.getCornerY(1));
    }

    private double getCornerX(int index) {
        return this.parm.getX() + (double)signB[index] * this.parm.getWidth() * Math.cos(this.parm.getPhi()) + (double)signA[index] * this.parm.getHeight() * Math.sin(this.parm.getPhi());
    }

    private double getCornerY(int index) {
        return this.parm.getY() - (double)signB[index] * this.parm.getWidth() * Math.sin(this.parm.getPhi()) + (double)signA[index] * this.parm.getHeight() * Math.cos(this.parm.getPhi());
    }

    private double getPhiOffset(int index) {
        return Math.atan2((double)signA[index] * this.parm.getHeight(), (double)signB[index] * this.parm.getWidth());
    }

    @Override
    public Handle[] getHandles(double xlow, double xhigh, double ylow, double yhigh) {
        int i;
        Handle[] result = new Handle[9];
        for (i = 0; i < 4; ++i) {
            result[i] = new CornerHandle(i);
        }
        for (i = 0; i < 4; ++i) {
            result[i + 4] = new MiddleHandle(i);
        }
        result[8] = new MoveHandle();
        return result;
    }

    @Override
    public String getTitle() {
        return null;
    }

    private class MoveHandle
    extends Handle {
        private MoveHandle() {
        }

        @Override
        public double getX() {
            return SliceData.this.parm.getX();
        }

        @Override
        public double getY() {
            return SliceData.this.parm.getY();
        }

        @Override
        public void moveTo(double xNew, double yNew) {
            SliceData.this.parm.setX(xNew);
            SliceData.this.parm.setY(yNew);
        }
    }

    private class MiddleHandle
    extends Handle {
        private int index;

        MiddleHandle(int i) {
            this.index = i;
        }

        @Override
        public double getX() {
            return (SliceData.this.getCornerX(this.index) + SliceData.this.getCornerX((this.index + 1) % 4)) / 2.0;
        }

        @Override
        public double getY() {
            return (SliceData.this.getCornerY(this.index) + SliceData.this.getCornerY((this.index + 1) % 4)) / 2.0;
        }

        @Override
        public void moveTo(double xNew, double yNew) {
            double x = SliceData.this.parm.getX();
            double y = SliceData.this.parm.getY();
            double phiNew = Math.atan2(yNew - y, xNew - x);
            double newDist = Math.sqrt((xNew - x) * (xNew - x) + (yNew - y) * (yNew - y));
            if (this.index % 2 == 0) {
                SliceData.this.parm.setHeight(Math.abs(newDist *= Math.sin(phiNew - SliceData.this.parm.getPhi())));
            } else {
                SliceData.this.parm.setWidth(Math.abs(newDist *= Math.cos(phiNew - SliceData.this.parm.getPhi())));
            }
        }
    }

    private class CornerHandle
    extends Handle {
        private int index;

        CornerHandle(int i) {
            this.index = i;
        }

        @Override
        public double getX() {
            return SliceData.this.getCornerX(this.index);
        }

        @Override
        public double getY() {
            return SliceData.this.getCornerY(this.index);
        }

        @Override
        public void moveTo(double xNew, double yNew) {
            double x = SliceData.this.parm.getX();
            double y = SliceData.this.parm.getY();
            double phiNew = Math.atan2(yNew - y, xNew - x);
            SliceData.this.parm.setPhi(-phiNew + SliceData.this.getPhiOffset(this.index));
        }
    }
}

