/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.util.xml.XMLNodeTraverser;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class Points2DNodeTraverser
extends XMLNodeTraverser {
    private String title;
    private double[][] data;
    private int dimensions;

    Points2DNodeTraverser(Node node) throws XMLNodeTraverser.BadXMLException {
        this.traverse(node);
    }

    @Override
    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("title")) {
            this.title = value;
        } else if (name.equals("dimensions")) {
            this.dimensions = this.toInt(value);
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }

    @Override
    protected void handleTextNode(Text node, String name) throws XMLNodeTraverser.BadXMLException {
        StringTokenizer lineTokens = new StringTokenizer(node.getData());
        int lines = lineTokens.countTokens();
        int x = 0;
        int l = 0;
        while (lineTokens.hasMoreTokens()) {
            StringTokenizer valueTokens = new StringTokenizer(lineTokens.nextToken().trim(), ",");
            int n = valueTokens.countTokens();
            if (this.data == null) {
                this.data = new double[n][lines];
            } else if (n != this.data.length) {
                throw new XMLNodeTraverser.BadXMLException("Inconsistent number of entries in bins2d data at line " + l);
            }
            for (int i = 0; i < n; ++i) {
                this.data[i][x] = this.toDouble(valueTokens.nextToken());
            }
            ++x;
            ++l;
        }
    }

    String getTitle() {
        return this.title;
    }

    double[][] getData() {
        return this.data;
    }

    int getDimensions() {
        return this.dimensions;
    }
}

