/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Basic1DFunction;
import jas.hist.ExtendedStatistics;
import jas.hist.Fitter;
import jas.hist.FunctionValueUndefined;
import jas.hist.InvalidFunctionParameter;
import jas.util.DoubleWithError;
import java.text.NumberFormat;

public abstract class Fittable1DFunction
extends Basic1DFunction
implements ExtendedStatistics {
    private static final String chi2 = "\u03c7\u00b2";
    private Fitter m_fit;
    private boolean[] m_fitParms;
    private NumberFormat format = NumberFormat.getInstance();

    public abstract double valueAt(double var1, double[] var3) throws FunctionValueUndefined;

    public abstract void setFit(Fitter var1, double[] var2) throws InvalidFunctionParameter;

    public boolean[] getIncludeParametersInFit() {
        this.initIncludeParametersInFit(this.getParameterNames().length);
        return this.m_fitParms;
    }

    public void clearFitParams() {
        this.m_fitParms = null;
    }

    public void setIncludeParameterInFit(int index, boolean value) {
        this.initIncludeParametersInFit(this.getParameterNames().length);
        this.m_fitParms[index] = value;
        this.clearFit();
        this.setChanged();
    }

    protected void initIncludeParametersInFit(int nParameters) {
        if (this.m_fitParms == null || this.m_fitParms.length != nParameters) {
            this.m_fitParms = new boolean[nParameters];
            for (int i = 0; i < this.m_fitParms.length; ++i) {
                this.m_fitParms[i] = true;
            }
        }
    }

    public double[] getDerivatives(double x, double[] a) throws FunctionValueUndefined {
        int nterms = a.length;
        double[] result = new double[nterms];
        double[] deltaA = this.getParameterDeltas();
        for (int j = 0; j < nterms; ++j) {
            double old = a[j];
            double delta = deltaA[j];
            a[j] = old + delta;
            double y = this.valueAt(x, a);
            a[j] = old - delta;
            result[j] = (y - this.valueAt(x, a)) / (2.0 * delta);
            a[j] = old;
        }
        return result;
    }

    private double[] getParameterDeltas() {
        double[] a = (double[])this.getParameterValues().clone();
        for (int i = 0; i < a.length; ++i) {
            a[i] = 1.0E-7;
        }
        return a;
    }

    public Fitter getFit() {
        return this.m_fit;
    }

    protected void setFit(Fitter fit) {
        this.m_fit = fit;
    }

    public void clearFit() {
        Fitter old = this.m_fit;
        if (old != null) {
            this.m_fit = null;
            old.dispose();
        }
    }

    @Override
    protected void destroy() {
        this.clearFit();
        super.destroy();
    }

    @Override
    public String[] getStatisticNames() {
        String[] statnames = null;
        if (this.m_fit != null) {
            if (this.getParameterNames() != null) {
                statnames = new String[this.getParameterNames().length + 1];
                for (int i = 0; i < this.getParameterNames().length; ++i) {
                    statnames[i] = this.getParameterNames()[i];
                }
            } else {
                statnames = new String[1];
            }
            statnames[statnames.length - 1] = chi2;
            return statnames;
        }
        statnames = super.getStatisticNames();
        return statnames;
    }

    @Override
    public double getStatistic(String name) {
        if (name.equals(chi2)) {
            return this.m_fit.getChiSquared();
        }
        return super.getStatistic(name);
    }

    @Override
    public Object getExtendedStatistic(String name) {
        if (this.m_fit != null) {
            boolean[] inFit = this.getIncludeParametersInFit();
            int count = 0;
            for (int i = 0; i < inFit.length; ++i) {
                if (name.equals(this.getParameterNames()[i])) {
                    if (inFit[i]) {
                        return new DoubleWithError(this.getParameterValues()[i], this.m_fit.getParameterSigmas()[count]);
                    }
                    return this.format.format(this.getParameterValues()[i]) + " Fixed";
                }
                if (!inFit[i]) continue;
                ++count;
            }
        }
        return null;
    }
}

