/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.BinnedDataManager;
import jas.hist.DataManagerException;
import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.StatisticsBlock;
import jas.hist.XYDataSource;
import jas.plot.DataArea;
import jas.plot.DoubleAxis;
import jas.plot.Legend;
import java.io.IOException;
import java.io.ObjectInputStream;

class DoubleDataManager
extends BinnedDataManager {
    private DoubleAxis xAxis = new DoubleAxis();

    DoubleDataManager(JASHist plot, DataArea da, Legend l, StatisticsBlock stats, int bins) {
        super(plot, da, l, stats, bins);
        DoubleAxis yAxis = new DoubleAxis();
        yAxis.setUseSuggestedRange(true);
        this.xm.setDataManager(this, true, this.xAxis);
        this.ym[0].setDataManager(this, false, yAxis);
        new BinnedDataManager.DoubleAxisListener(this.xm);
        this.xm.setBins(bins);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        new BinnedDataManager.DoubleAxisListener(this.xm);
    }

    @Override
    final JASHistData add(DataSource data) {
        if (data instanceof Rebinnable1DHistogramData) {
            Rebinnable1DHistogramData d = (Rebinnable1DHistogramData)data;
            if (d.getAxisType() != 1) {
                throw new DataManagerException("Incompatible data type for axis");
            }
        } else {
            XYDataSource d = (XYDataSource)data;
            if (d.getAxisType() != 1) {
                throw new DataManagerException("Incompatible data type for axis");
            }
        }
        return super.add(data);
    }

    @Override
    protected final void calcMinMaxBins(double x1, double x2) {
        double oldXMin = this.xAxis.getPlotMin();
        double oldXMax = this.xAxis.getPlotMax();
        if (x1 != oldXMin || x2 != oldXMax) {
            this.xAxis.setMin(x1);
            this.xAxis.setMax(x2);
            this.xm.invalidate();
        }
    }
}

