/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d.models;

import jhpro.engine3d.FacetedObject;

public class Torus {
    public static FacetedObject create(int s_tor, int s_cyl) {
        int max_f = s_cyl * s_tor;
        int rot = 360 / s_cyl;
        int[][] v = new int[max_f][3];
        double[] dir = new double[2];
        for (int i = 0; i < s_tor; ++i) {
            double tor_dir = (double)i / (double)s_tor * 2.0 * Math.PI;
            dir[0] = Math.cos(tor_dir);
            dir[1] = Math.sin(tor_dir);
            for (int j = 0; j < s_cyl; ++j) {
                int k = s_cyl * i + j;
                int theta_deg = j * rot;
                double theta = (double)theta_deg * (Math.PI / 180);
                v[k][0] = (int)Math.round(40.0 * Math.cos(theta) * dir[0] + dir[0] * 80.0);
                v[k][1] = (int)Math.round(40.0 * Math.cos(theta) * dir[1] + dir[1] * 80.0);
                v[k][2] = (int)Math.round(40.0 * Math.sin(theta));
            }
        }
        int[][] vi = new int[max_f][4];
        for (int i = 0; i < s_tor; ++i) {
            for (int j = 0; j < s_cyl; ++j) {
                int k = s_cyl * i + j;
                int b = s_cyl * i;
                vi[k][0] = k;
                vi[k][1] = b + (j + 1) % s_cyl;
                vi[k][2] = (b + (j + 1) % s_cyl + s_cyl) % max_f;
                vi[k][3] = (k + s_cyl) % max_f;
            }
        }
        FacetedObject fo = new FacetedObject(v, vi);
        return fo;
    }
}

