/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d.models;

import jhpro.engine3d.FacetedObject;

public class MoebiusStrip {
    public static FacetedObject create(int numSegs) {
        int numFacets = numSegs;
        int numPoints = numSegs * 2;
        int radius = 50;
        double xr = (int)((double)radius * 1.2);
        double yr = (int)((double)radius * 0.8);
        double width = 16.0;
        double halfWidth = width / 2.0;
        double radiansPerSeg = Math.PI * 2 / (double)numSegs;
        FacetedObject fo = new FacetedObject(numPoints, numFacets, 4);
        for (int i = 0; i < numSegs; ++i) {
            double z;
            double x;
            double theta = (double)i * radiansPerSeg;
            if (i < numSegs / 2) {
                x = halfWidth * Math.sin(theta);
                z = halfWidth * Math.cos(theta);
            } else {
                x = 0.0;
                z = -halfWidth;
            }
            double xm = (xr - x) * Math.cos(theta);
            double xp = (xr + x) * Math.cos(theta);
            double ym = (yr - x) * Math.sin(theta);
            double yp = (yr + x) * Math.sin(theta);
            fo.setPointData(xm, ym, z);
            fo.setPointData(xp, yp, -z);
        }
        int[] indexPattern = new int[]{0, 2, 3, 1};
        int[] indexPatternEnd = new int[]{numPoints - 2, 1, 0, numPoints - 1};
        for (int i = 0; i < numPoints; i += 2) {
            for (int j = 0; j < 4; ++j) {
                fo.setVectorIndex(i >= numPoints - 2 ? indexPatternEnd[j] : i + indexPattern[j]);
            }
        }
        return fo;
    }
}

