/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import jhpro.engine3d.TextOut;
import jhpro.engine3d.Window3d;

public class View3d
extends Applet {
    private static final long serialVersionUID = 1L;
    public static Window3d drawPad = null;
    public static TextOut textWindow;
    Panel p;
    Panel buttons;
    static final int ROWS = 11;
    static final int COLS = 30;
    static int DrawSize;
    private static Applet ap;
    private static Label labelOfProgram;
    private static final String TitleLineMain = "   Java 3d Viewer ";
    private static final String TitleLineMainAlt = " Java - 3d - Engine :";
    private static final String Title2 = "A Multi-Format Viewer";
    private static final String Title3 = "by Paul Flavin  Version 0.2.1";
    public static boolean wantSolidRendering;
    public static boolean wantShading;
    String[] namesOfModels = new String[]{"tetrahedron.nff", "octahedron.nff", "hexahedron.nff", "dodecahedron.nff", "icosahedron.nff", "soccerball.nff", "bucky_c180.obj", "sphere_n3.off", "rod.off", "moebius_strip.off", "band_octagon.nff", "band_12-gon.nff", "torus__6x_6.nff", "torus__8x_8.nff", "torus_12x12.nff", "torus_30x12.nff", "torus_40x18.nff", "sun_logo.nff", "java.wrl", "blobby_man.obj", "teapot.off", "arrow.nff"};
    Scrollbar angularSpeedControl;
    Scrollbar angularStepControl;
    TextField pathToModelField;
    Checkbox spinSelected;
    List listOfModels;
    List renderMode;
    static boolean take_new_value;
    static int nv;
    String modelName = "moebius_strip.off";
    String modelScaling = "1.0";

    @Override
    public void start() {
        drawPad.Start();
    }

    @Override
    public void stop() {
        drawPad.Stop();
    }

    public static Applet getAppletReferance() {
        return ap;
    }

    public View3d() {
        ap = this;
    }

    @Override
    public void init() {
        this.modelName = this.getParameter("model");
        this.modelScaling = this.getParameter("scaling");
        super.setLayout(new BorderLayout());
        super.setBackground(Color.lightGray);
        Panel t = new Panel();
        t.setLayout(new GridLayout(1, 3));
        Color col = Color.yellow;
        t.setBackground(col);
        labelOfProgram = new Label(TitleLineMain);
        labelOfProgram.setFont(new Font("Helvetica", 1, 24));
        t.add(labelOfProgram);
        Label authorLine = new Label(Title2);
        authorLine.setFont(new Font("Helvetica", 1, 18));
        t.add(authorLine);
        authorLine = new Label(Title3);
        authorLine.setFont(new Font("Helvetica", 1, 14));
        t.add(authorLine);
        super.add("North", t);
        textWindow = new TextOut(10, 10);
        drawPad = new Window3d(DrawSize, this.modelName);
        Panel drawPadPanel = new Panel();
        drawPadPanel.setLayout(null);
        drawPadPanel.add(drawPad);
        drawPadPanel.resize(DrawSize, DrawSize);
        super.add("West", drawPadPanel);
        super.add("East", this.p);
        Panel control = new Panel();
        control.setLayout(new BorderLayout());
        this.listOfModels = new List(10, false);
        for (int i = 0; i < this.namesOfModels.length; ++i) {
            this.listOfModels.addItem(this.namesOfModels[i]);
        }
        this.listOfModels.select(9);
        this.listOfModels.setBackground(new Color(180, 180, 180));
        Font f = new Font("sansserif", 1, 12);
        Font f2 = new Font(f.getName(), 1, f.getSize());
        this.listOfModels.setFont(f2);
        control.add("North", this.listOfModels);
        this.renderMode = new List(2, false);
        this.renderMode.addItem("wireframe");
        this.renderMode.addItem("solid ( facets filled )");
        this.renderMode.addItem("wireframe  hidden lines removed");
        this.renderMode.addItem("phong shaded");
        this.renderMode.select(1);
        control.add("Center", this.renderMode);
        this.buttons = new Panel();
        this.buttons.setLayout(new GridLayout(3, 2));
        this.angularSpeedControl = new Scrollbar(0, 80, 1, 0, 300);
        this.angularStepControl = new Scrollbar(0, 1, 1, 1, 10);
        this.angularSpeedControl.setLineIncrement(20);
        this.angularSpeedControl.setPageIncrement(20);
        this.angularStepControl.setLineIncrement(1);
        this.angularStepControl.setPageIncrement(1);
        this.angularStepControl.enable(false);
        this.buttons.add(new Label("fast / slow"));
        this.buttons.add(this.angularSpeedControl);
        this.buttons.add(new Label("step size  "));
        this.buttons.add(this.angularStepControl);
        this.spinSelected = new Checkbox("Spin it ");
        this.spinSelected.setState(true);
        this.buttons.add(this.spinSelected);
        control.add("South", this.buttons);
        control.resize(300, 300);
        super.add("Center", control);
        textWindow.setFont(new Font("TimesRoman", 1, 14));
        textWindow.setEditable(false);
        Panel temp = new Panel();
        temp.setLayout(new FlowLayout());
        col = Color.green;
        temp.setBackground(col.darker());
        temp.add(new Label("Path to model ( URL ): "));
        this.pathToModelField = new TextField(50);
        this.pathToModelField.setEditable(true);
        this.pathToModelField.setBackground(Color.gray);
        temp.add(this.pathToModelField);
        super.add("South", temp);
        textWindow.greeting();
        textWindow.sout("Applet: \"   Java 3d Viewer \" ");
        super.resize(super.preferredSize());
        this.verifyNoTampering();
        this.customizeApplet();
        Window3d.spinDelay = this.angularSpeedControl.getValue();
        this.start();
    }

    private void call_sout(String s) {
        textWindow.sout(s);
    }

    public static void sout(String s) {
        textWindow.sout(s);
    }

    public void loadFileModel(String model) {
        System.out.println("Loading a new modrl=" + model);
        drawPad.rotatePause();
        drawPad.loadModel(model);
        if (model.endsWith(".off") || model.endsWith(".nff")) {
            this.setRenderingMode(1);
        } else {
            this.setRenderingMode(0);
        }
        drawPad.repaint();
        drawPad.rotateResume();
    }

    @Override
    public synchronized boolean handleEvent(Event e) {
        switch (e.id) {
            case 1001: {
                if (e.target instanceof TextField) {
                    textWindow.sout("attempting to fetch ... ");
                    textWindow.sout("URL Entered : \"" + (String)e.arg + "\" ");
                    drawPad.loadModel((String)e.arg);
                    drawPad.repaint();
                    return false;
                }
            }
            case 701: {
                if (e.target == this.listOfModels) {
                    String model = this.listOfModels.getSelectedItem();
                    textWindow.sout("  ");
                    textWindow.sout("Selected:   \"" + model + "\" ");
                    drawPad.rotatePause();
                    drawPad.loadModel(model);
                    if (model.endsWith(".off") || model.endsWith(".nff")) {
                        this.setRenderingMode(1);
                    } else {
                        this.setRenderingMode(0);
                    }
                    drawPad.repaint();
                    drawPad.rotateResume();
                    return super.handleEvent(e);
                }
                if (e.target != this.renderMode) break;
                int i = this.renderMode.getSelectedIndex();
                if (i > 1) {
                    i = 0;
                    this.renderMode.select(0);
                    textWindow.sout("  ");
                    textWindow.sout("Sorry, I can't render in that mode.");
                    textWindow.sout(" .off & .nff can be solid rendered.");
                    textWindow.sout("Hidden line removal and phong shading");
                    textWindow.sout("are 'soon to be implemented' features.");
                }
                wantSolidRendering = i == 1;
                drawPad.repaint();
                break;
            }
            case 601: 
            case 602: {
                int RoundTo = 10;
                nv = this.angularSpeedControl.getValue() + (e.id == 602 ? 10 : -10);
                nv = (nv + RoundTo / 2 - 1) / RoundTo * RoundTo;
                if (nv >= 0 && nv <= 300) {
                    this.angularSpeedControl.setValue(nv);
                    Window3d.spinDelay = nv;
                    take_new_value = true;
                }
                return true;
            }
            case 603: 
            case 604: {
                return super.handleEvent(e);
            }
            case 605: {
                if (e.target == this.angularSpeedControl) {
                    if (drawPad == null) {
                        return true;
                    }
                    int v = this.angularSpeedControl.getValue();
                    if (e.id == 605) {
                        int RoundTo = 10;
                        v = (v + RoundTo / 2 - 1) / RoundTo * RoundTo;
                        if (take_new_value) {
                            take_new_value = false;
                            v = nv;
                        }
                        this.angularSpeedControl.setValue(v);
                    }
                    Window3d.spinDelay = v;
                    textWindow.sout("speed delay: " + v + " ( scroll bar )");
                }
                return true;
            }
        }
        if (e.target instanceof Button) {
            if (e.id == 1001) {
                textWindow.sout("button pushed ( A.E. ): " + e.arg);
                drawPad.commandAction(e);
            }
            return true;
        }
        if (e.target instanceof Checkbox) {
            if (e.id == 1001) {
                this.angularSpeedControl.enable(((Checkbox)e.target).getState());
                drawPad.commandAction(e);
            }
            return super.handleEvent(e);
        }
        return !(e.target instanceof TextField);
    }

    private boolean customizeApplet() {
        String customVersion;
        String webPageFilename = "";
        int p = Math.max(-1, webPageFilename.lastIndexOf("/")) + 1;
        String webPage = webPageFilename.substring(p);
        if (webPageFilename.endsWith("java3dviewer.html")) {
            customVersion = "k-12 Mathematics";
        } else {
            customVersion = "Java / Graphics ";
            labelOfProgram.setText(TitleLineMainAlt);
            this.listOfModels.addItem("venus.off", this.listOfModels.countItems() - 2);
        }
        textWindow.sout("\"" + webPage + "\" gets " + customVersion + " customized features ");
        return true;
    }

    private void verifyNoTampering() {
        String param_my_home_name = "HomePageOfAppletAuthor";
        String param_my_home_value = "http://www.frontiernet.net/~imaging/index.html";
        String s = "Quiting : I don't want to play (tampered).";
        try {
            boolean ok = super.getParameter(param_my_home_name).equals(param_my_home_value);
            if (!ok) {
                System.err.println(s);
                super.showStatus(s);
                throw new SecurityException("Security Exception : " + s);
            }
        }
        catch (NullPointerException e) {
            System.err.println("error paramter check: " + e);
        }
    }

    @Override
    public String getAppletInfo() {
        return "Java 3d Viewer of Wireframes and Faceted Objects Written by Paul Flavin, derived in part from  Sun's demo,  et al., including an earlier program of my own.";
    }

    public void setRenderingMode(int m) {
        wantSolidRendering = m == 1;
        this.renderMode.select(m);
    }

    static {
        DrawSize = 360;
        wantSolidRendering = true;
        wantShading = true;
        take_new_value = false;
        nv = 0;
    }
}

