/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d;

import java.awt.Dimension;
import java.awt.Graphics;
import jhpro.engine3d.Drawable;
import jhpro.engine3d.FacetedObject;
import jhpro.engine3d.Matrix3d;
import jhpro.engine3d.MeshObject;
import jhpro.engine3d.OF_off;
import jhpro.engine3d.Volume;

public class Object3d {
    Drawable md;
    Matrix3d amat = new Matrix3d();
    Matrix3d tmat = new Matrix3d();
    Matrix3d omat = new Matrix3d();
    Matrix3d wmat = new Matrix3d();
    public boolean painted = true;
    double xfac;
    float scaleFactor = 1.0f;
    String modelName = null;
    String message = null;
    Dimension winSize;
    static Matrix3d spinMatrix = new Matrix3d();
    static boolean isFirstTime = true;
    static int timesSinceRecalibration = 0;

    Object3d() {
    }

    Object3d(Dimension p_winSize) {
        this.winSize = p_winSize;
        this.scaleFactor = 0.8f;
    }

    public void doInitialRotation() {
        this.amat.unit();
        this.tmat.unit();
        this.tmat.xrot(70.0);
        this.amat.mult(this.tmat);
        this.omat.mult(this.amat);
    }

    public void setMatrixRotation(float xtheta, float ytheta) {
        this.tmat.unit();
        this.tmat.xrot(xtheta);
        this.tmat.yrot(ytheta);
        this.amat.mult(this.tmat);
    }

    private float calc_xfac(Volume v) {
        float f2;
        float f1;
        float xw = v.getXLen();
        float yw = v.getYLen();
        float zw = v.getZLen();
        if (yw > xw) {
            xw = yw;
        }
        if (zw > xw) {
            xw = zw;
        }
        float x_fac = 0.7f * ((f1 = (float)this.winSize.width / xw) >= (f2 = (float)this.winSize.height / xw) ? f2 : f1) * this.scaleFactor;
        return x_fac;
    }

    public Drawable loadModel(String modelName) {
        float f = this.scaleFactor = modelName.indexOf("cube.obj") < 0 ? 1.0f : 0.8f;
        if (modelName.indexOf("teapot.off") >= 0) {
            this.scaleFactor = 1.2f;
        }
        try {
            this.md = MeshObject.getModel(modelName);
            Volume v = this.md.determineBoundingBox();
            this.xfac = this.calc_xfac(v);
            this.doInitialRotation();
            if (modelName.indexOf("teapot.off") >= 0) {
                this.amat.unit();
                this.tmat.unit();
                this.tmat.xrot(-244.0);
                this.tmat.yrot(-6.0);
                this.amat.mult(this.tmat);
                this.omat.mult(this.amat);
            }
        }
        catch (Exception e) {
            this.md = null;
            this.message = e.toString();
            System.out.println("Error ( loadModel ) " + e);
            System.out.println("  " + this.message);
        }
        return this.md;
    }

    public Drawable loadModel(FacetedObject ob) {
        this.scaleFactor = 1.0f;
        try {
            this.md = MeshObject.getModel(ob);
            Volume v = this.md.determineBoundingBox();
            this.xfac = this.calc_xfac(v);
            this.doInitialRotation();
        }
        catch (Exception e) {
            this.md = null;
            this.message = e.toString();
            System.out.println("Error ( loadModel ) " + e);
            System.out.println("  " + this.message);
        }
        return this.md;
    }

    public synchronized void spin() {
        double spinRateY = 2.5;
        if (isFirstTime) {
            isFirstTime = false;
            spinMatrix.unit();
            spinMatrix.yrot(spinRateY);
        }
        this.amat.mult(spinMatrix);
    }

    public synchronized void setPainted() {
        this.painted = true;
    }

    public synchronized void paintOffscreen(Graphics g, int w, int h) {
        if (this.md != null) {
            this.omat.unit();
            Volume v = this.md.getVolume();
            this.omat.translate(-(v.x_min + v.x_max) / 2.0f, -(v.y_min + v.y_max) / 2.0f, -(v.z_min + v.z_max) / 2.0f);
            this.omat.mult(this.amat);
            this.omat.scale(this.xfac, -this.xfac, 16.0 * this.xfac / (double)this.winSize.width);
            this.omat.translate(this.winSize.width / 2, this.winSize.height / 2, 8.0);
            this.md.transform(this.omat);
            OF_off.tranformNormal(this.amat);
            this.md.Paint(g);
            this.setPainted();
        } else if (this.message != null) {
            g.drawString("Error in model:", 4, 20);
            g.drawString(this.message, 10, 40);
            System.out.println("Error in model : " + this.message);
        }
    }
}

