/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d;

import jhpro.engine3d.Vec;

class Matrix3d {
    double xx = 1.0;
    double xy;
    double xz;
    double xo;
    double yx;
    double yy = 1.0;
    double yz;
    double yo;
    double zx;
    double zy;
    double zz = 1.0;
    double zo;
    static final double pi = Math.PI;

    Matrix3d() {
    }

    void scale(double f) {
        this.xx *= f;
        this.xy *= f;
        this.xz *= f;
        this.xo *= f;
        this.yx *= f;
        this.yy *= f;
        this.yz *= f;
        this.yo *= f;
        this.zx *= f;
        this.zy *= f;
        this.zz *= f;
        this.zo *= f;
    }

    void scale(double xf, double yf, double zf) {
        this.xx *= xf;
        this.xy *= xf;
        this.xz *= xf;
        this.xo *= xf;
        this.yx *= yf;
        this.yy *= yf;
        this.yz *= yf;
        this.yo *= yf;
        this.zx *= zf;
        this.zy *= zf;
        this.zz *= zf;
        this.zo *= zf;
    }

    void translate(double x, double y, double z) {
        this.xo += x;
        this.yo += y;
        this.zo += z;
    }

    void xrot(double theta) {
        double ct = Math.cos(theta *= Math.PI / 180);
        double st = Math.sin(theta);
        double Nyx = this.yx * ct + this.zx * st;
        double Nyy = this.yy * ct + this.zy * st;
        double Nyz = this.yz * ct + this.zz * st;
        double Nyo = this.yo * ct + this.zo * st;
        double Nzx = this.zx * ct - this.yx * st;
        double Nzy = this.zy * ct - this.yy * st;
        double Nzz = this.zz * ct - this.yz * st;
        double Nzo = this.zo * ct - this.yo * st;
        this.yo = Nyo;
        this.yx = Nyx;
        this.yy = Nyy;
        this.yz = Nyz;
        this.zo = Nzo;
        this.zx = Nzx;
        this.zy = Nzy;
        this.zz = Nzz;
    }

    void yrot(double theta) {
        double ct = Math.cos(theta *= Math.PI / 180);
        double st = Math.sin(theta);
        double Nxx = this.xx * ct + this.zx * st;
        double Nxy = this.xy * ct + this.zy * st;
        double Nxz = this.xz * ct + this.zz * st;
        double Nxo = this.xo * ct + this.zo * st;
        double Nzx = this.zx * ct - this.xx * st;
        double Nzy = this.zy * ct - this.xy * st;
        double Nzz = this.zz * ct - this.xz * st;
        double Nzo = this.zo * ct - this.xo * st;
        this.xo = Nxo;
        this.xx = Nxx;
        this.xy = Nxy;
        this.xz = Nxz;
        this.zo = Nzo;
        this.zx = Nzx;
        this.zy = Nzy;
        this.zz = Nzz;
    }

    void zrot(double theta) {
        double ct = Math.cos(theta *= Math.PI / 180);
        double st = Math.sin(theta);
        double Nyx = this.yx * ct + this.xx * st;
        double Nyy = this.yy * ct + this.xy * st;
        double Nyz = this.yz * ct + this.xz * st;
        double Nyo = this.yo * ct + this.xo * st;
        double Nxx = this.xx * ct - this.yx * st;
        double Nxy = this.xy * ct - this.yy * st;
        double Nxz = this.xz * ct - this.yz * st;
        double Nxo = this.xo * ct - this.yo * st;
        this.yo = Nyo;
        this.yx = Nyx;
        this.yy = Nyy;
        this.yz = Nyz;
        this.xo = Nxo;
        this.xx = Nxx;
        this.xy = Nxy;
        this.xz = Nxz;
    }

    void mult(Matrix3d rhs) {
        double lxx = this.xx * rhs.xx + this.yx * rhs.xy + this.zx * rhs.xz;
        double lxy = this.xy * rhs.xx + this.yy * rhs.xy + this.zy * rhs.xz;
        double lxz = this.xz * rhs.xx + this.yz * rhs.xy + this.zz * rhs.xz;
        double lxo = this.xo * rhs.xx + this.yo * rhs.xy + this.zo * rhs.xz + rhs.xo;
        double lyx = this.xx * rhs.yx + this.yx * rhs.yy + this.zx * rhs.yz;
        double lyy = this.xy * rhs.yx + this.yy * rhs.yy + this.zy * rhs.yz;
        double lyz = this.xz * rhs.yx + this.yz * rhs.yy + this.zz * rhs.yz;
        double lyo = this.xo * rhs.yx + this.yo * rhs.yy + this.zo * rhs.yz + rhs.yo;
        double lzx = this.xx * rhs.zx + this.yx * rhs.zy + this.zx * rhs.zz;
        double lzy = this.xy * rhs.zx + this.yy * rhs.zy + this.zy * rhs.zz;
        double lzz = this.xz * rhs.zx + this.yz * rhs.zy + this.zz * rhs.zz;
        double lzo = this.xo * rhs.zx + this.yo * rhs.zy + this.zo * rhs.zz + rhs.zo;
        this.xx = lxx;
        this.xy = lxy;
        this.xz = lxz;
        this.xo = lxo;
        this.yx = lyx;
        this.yy = lyy;
        this.yz = lyz;
        this.yo = lyo;
        this.zx = lzx;
        this.zy = lzy;
        this.zz = lzz;
        this.zo = lzo;
    }

    void mult_y(Matrix3d rhs) {
        double lxx = this.zx * rhs.xz + this.xx;
        double lxy = this.zy * rhs.xz + this.xy;
        double lxz = this.zz * rhs.xz + this.xz;
        double lxo = this.zo * rhs.xz + this.xo;
        this.zx += this.xx * rhs.zx;
        this.zy += this.xy * rhs.zx;
        this.zz += this.xz * rhs.zx;
        this.zo += this.xo * rhs.zx;
        this.xx = lxx;
        this.xy = lxy;
        this.xz = lxz;
        this.xo = lxo;
    }

    void unit() {
        this.xo = 0.0;
        this.xx = 1.0;
        this.xy = 0.0;
        this.xz = 0.0;
        this.yo = 0.0;
        this.yx = 0.0;
        this.yy = 1.0;
        this.yz = 0.0;
        this.zo = 0.0;
        this.zx = 0.0;
        this.zy = 0.0;
        this.zz = 1.0;
    }

    private double adjustToOne(double x) {
        double fuzz = 5.0E-4;
        if (x < 1.0 + fuzz && x > 1.0 - fuzz) {
            return 1.0;
        }
        return x;
    }

    void adjustMatrix() {
        this.xo = this.adjustToOne(this.xo);
        this.yo = this.adjustToOne(this.yo);
        this.zo = this.adjustToOne(this.zo);
        this.xx = this.adjustToOne(this.xx);
        this.yx = this.adjustToOne(this.yx);
        this.zx = this.adjustToOne(this.zx);
        this.xy = this.adjustToOne(this.xy);
        this.yy = this.adjustToOne(this.yy);
        this.zy = this.adjustToOne(this.zy);
        this.xz = this.adjustToOne(this.xz);
        this.yz = this.adjustToOne(this.yz);
        this.zz = this.adjustToOne(this.zz);
    }

    Vec transform(Vec a) {
        Vec r = new Vec(a.x * this.xx + a.y * this.xy + a.z * this.xz + this.xo, a.x * this.yx + a.y * this.yy + a.z * this.yz + this.yo, a.x * this.zx + a.y * this.zy + a.z * this.zz + this.zo);
        return r;
    }

    Vec transformPoint(Vec p) {
        Vec r = new Vec();
        r.x = p.x * this.xx + p.y * this.xy + p.z * this.xz + this.xo;
        r.y = p.x * this.yx + p.y * this.yy + p.z * this.yz + this.yo;
        r.z = p.x * this.zx + p.y * this.zy + p.z * this.zz + this.zo;
        return r;
    }

    void transform(float[] v, int[] tv, int nvert) {
        float lxx = (float)this.xx;
        float lxy = (float)this.xy;
        float lxz = (float)this.xz;
        float lxo = (float)this.xo;
        float lyx = (float)this.yx;
        float lyy = (float)this.yy;
        float lyz = (float)this.yz;
        float lyo = (float)this.yo;
        float lzx = (float)this.zx;
        float lzy = (float)this.zy;
        float lzz = (float)this.zz;
        float lzo = (float)this.zo;
        int i = nvert * 3;
        while ((i -= 3) >= 0) {
            float x = v[i];
            float y = v[i + 1];
            float z = v[i + 2];
            tv[i] = (int)(x * lxx + y * lxy + z * lxz + lxo);
            tv[i + 1] = (int)(x * lyx + y * lyy + z * lyz + lyo);
            tv[i + 2] = (int)(x * lzx + y * lzy + z * lzz + lzo);
        }
    }

    void transform_for_off(float[] v, int[] tv, int nvert) {
        float lxx = (float)this.xx;
        float lxy = (float)this.xy;
        float lxz = (float)this.xz;
        float lxo = (float)this.xo;
        float lyx = (float)this.yx;
        float lyy = (float)this.yy;
        float lyz = (float)this.yz;
        float lyo = (float)this.yo;
        float lzx = (float)this.zx;
        float lzy = (float)this.zy;
        float lzz = (float)this.zz;
        float lzo = (float)this.zo;
        int i = nvert * 3;
        while ((i -= 3) >= 0) {
            float x = v[i];
            float y = v[i + 1];
            float z = v[i + 2];
            tv[i] = (int)(x * lxx + y * lxy + z * lxz + lxo);
            tv[i + 1] = (int)(x * lyx + y * lyy + z * lyz + lyo);
            tv[i + 2] = (int)(10000.0f * (x * lzx + y * lzy + z * lzz + lzo));
        }
    }

    public String toString() {
        return "   (  o  x  y  z  ) \n x [ " + this.xo + ", " + this.xx + ", " + this.xy + ", " + this.xz + ";\n y   " + this.yo + ", " + this.yx + ", " + this.yy + ", " + this.yz + ";\n z   " + this.zo + ", " + this.zx + ", " + this.zy + ", " + this.zz + " ]";
    }
}

