/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import jhpro.engine3d.FacetedObject;
import jhpro.engine3d.FileFetch;

public class FileParse {
    private static double[] point_data = new double[3];

    public static FacetedObject readOffObject(String modelFilename) throws IOException {
        BufferedReader is;
        FacetedObject fo = null;
        int nVerticies = 0;
        int nFacets = 0;
        int nEdges = 0;
        int nEdgesPerFacet = 0;
        try {
            is = FileFetch.openFile(modelFilename);
        }
        catch (Exception e) {
            System.out.println("Error ( loadModel ) " + e);
            throw new IOException("load model error: " + e);
        }
        StreamTokenizer stream = new StreamTokenizer(is);
        stream.eolIsSignificant(true);
        stream.commentChar(35);
        boolean gothead = false;
        block14: while (!gothead) {
            switch (stream.nextToken()) {
                default: {
                    break block14;
                }
                case -2: 
                case 10: {
                    continue block14;
                }
                case -3: {
                    if (!"OFF".equals(stream.sval)) continue block14;
                    while (stream.nextToken() == 10) {
                    }
                    if (stream.ttype == -2) {
                        nVerticies = (int)stream.nval;
                        if (stream.nextToken() == -2) {
                            nFacets = (int)stream.nval;
                            if (stream.nextToken() == -2) {
                                nEdges = (int)stream.nval;
                                gothead = true;
                                continue block14;
                            }
                            throw new IOException("Error in OFF file ");
                        }
                        throw new IOException("Error in OFF file ");
                    }
                    throw new IOException("Error in OFF file ");
                }
            }
        }
        fo = new FacetedObject(nVerticies);
        int num = 0;
        int coordnum = 0;
        block16: while (num < nVerticies) {
            switch (stream.nextToken()) {
                default: {
                    continue block16;
                }
                case 10: {
                    if (coordnum <= 2) continue block16;
                    coordnum = 0;
                    ++num;
                    continue block16;
                }
                case -2: 
            }
            FileParse.point_data[coordnum % 3] = (float)stream.nval;
            if (++coordnum % 3 != 0) continue;
            fo.setPointData(point_data);
        }
        num = 0;
        coordnum = 0;
        boolean gotnum = false;
        block17: while (num < nFacets) {
            switch (stream.nextToken()) {
                default: {
                    continue block17;
                }
                case 10: {
                    if (gotnum) {
                        ++num;
                    }
                    gotnum = false;
                    continue block17;
                }
                case -2: 
            }
            if (!gotnum) {
                nEdgesPerFacet = (int)stream.nval;
                if (num == 0) {
                    fo.createVectorIndex(nFacets, nEdgesPerFacet);
                }
                gotnum = true;
                coordnum = 0;
                continue;
            }
            if (coordnum >= nEdgesPerFacet) continue;
            fo.setVectorIndex((int)stream.nval);
            ++coordnum;
        }
        return fo;
    }

    public static FacetedObject readNffObject(String modelName) throws IOException {
        BufferedReader is;
        FacetedObject fo = null;
        int numVerticies = 0;
        int numFaces = 0;
        try {
            is = FileFetch.openFile(modelName);
        }
        catch (Exception e) {
            System.out.println("Error ( loadModel ) " + e);
            throw new IOException("load model error: " + e);
        }
        StreamTokenizer st = new StreamTokenizer(is);
        st.eolIsSignificant(true);
        st.commentChar(35);
        st.slashSlashComments(true);
        boolean seekingVerticiesCount = true;
        block10: while (seekingVerticiesCount) {
            st.nextToken();
            switch (st.ttype) {
                default: {
                    break block10;
                }
                case 10: {
                    continue block10;
                }
                case -2: {
                    numVerticies = (int)st.nval;
                    seekingVerticiesCount = false;
                    continue block10;
                }
            }
        }
        fo = new FacetedObject(numVerticies);
        int valsRead = 0;
        int verticiesRead = 0;
        double[] vals = new double[]{0.0, 0.0, 0.0};
        seekingVerticiesCount = true;
        st.nextToken();
        block11: while (seekingVerticiesCount) {
            st.nextToken();
            switch (st.ttype) {
                default: {
                    break block11;
                }
                case -2: {
                    vals[valsRead++] = st.nval;
                    continue block11;
                }
                case 10: {
                    fo.setPointData(vals);
                    valsRead = 0;
                    if (numVerticies != ++verticiesRead) continue block11;
                    seekingVerticiesCount = false;
                    continue block11;
                }
            }
        }
        st.nextToken();
        if (st.ttype == -2) {
            numFaces = (int)st.nval;
            st.nextToken();
            int first = -1;
            int curr = -1;
            int prev = -1;
            for (int i = 0; i < numFaces; ++i) {
                st.nextToken();
                int n = (int)st.nval;
                if (i == 0) {
                    fo.createVectorIndex(numFaces, n);
                }
                for (int j = 0; j < n; ++j) {
                    st.nextToken();
                    curr = (int)st.nval - 1;
                    fo.setVectorIndex((int)st.nval - 1);
                }
                st.nextToken();
                if (st.ttype == -1) break;
            }
        }
        is.close();
        return fo;
    }
}

