/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d;

import java.awt.Color;
import java.io.Serializable;

public class FacetedObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean wantSolidRendering = true;
    private Color fillColor = Color.blue;
    private boolean wantShading = true;
    private Color penColor = Color.black;
    private int transperancy = 200;
    final int SamplesDesired = 5;
    int vSamplesModal;
    int fSamplesModal;
    int v;
    int f;
    int e;
    int n;
    private int currentPoint;
    private int currentEntry;
    public double[][] verticies = null;
    public int[][] vindex = null;

    public FacetedObject() {
        this.n = 0;
        this.e = 0;
        this.f = 0;
        this.v = 0;
        this.currentPoint = 0;
        this.currentEntry = 0;
        this.penColor = Color.black;
        this.wantShading = true;
        this.fillColor = Color.blue;
        this.wantSolidRendering = true;
    }

    FacetedObject(int v_p) {
        this(v_p, 0, 0);
    }

    public FacetedObject(int[][] verts, int[][] vi) {
        int j;
        int i;
        this.v = verts.length;
        this.f = vi.length;
        this.e = vi[0].length;
        this.n = vi[0].length;
        this.verticies = new double[verts.length][3];
        for (i = 0; i < verts.length; ++i) {
            for (j = 0; j < 3; ++j) {
                this.verticies[i][j] = verts[i][j];
            }
        }
        this.vindex = new int[vi.length][vi[0].length];
        for (i = 0; i < vi.length; ++i) {
            for (j = 0; j < 4; ++j) {
                this.vindex[i][j] = vi[i][j];
            }
        }
    }

    public FacetedObject(int v_p, int f_p, int n_p) {
        this();
        this.v = v_p;
        this.verticies = new double[this.v][3];
        this.vSamplesModal = Math.max(1, this.v / 5);
        if (f_p > 0) {
            this.createVectorIndex(f_p, n_p);
        }
    }

    public void createVectorIndex(int f_p, int n_p) {
        this.f = f_p;
        this.n = n_p;
        this.vindex = new int[this.f][this.n];
        this.fSamplesModal = Math.max(1, this.f / 5);
    }

    public void setPointData(double[] p) {
        this.verticies[this.currentPoint][0] = p[0];
        this.verticies[this.currentPoint][1] = p[1];
        this.verticies[this.currentPoint++][2] = p[2];
    }

    public void setPointData(double x, double y, double z) {
        double[] v = new double[]{x, y, z};
        this.setPointData(v);
    }

    public void setVectorIndex(int val) {
        int row = this.currentEntry / this.n;
        int col = this.currentEntry++ % this.n;
        this.vindex[row][col] = val;
        if (row % this.fSamplesModal != 0 || col == 3) {
            // empty if block
        }
    }

    public void setSolidRendering(boolean solid) {
        this.wantSolidRendering = solid;
    }

    public void setTransperancy(int transperancy) {
        if (transperancy > 255) {
            transperancy = 255;
        }
        this.transperancy = transperancy;
    }

    public int getTransperancy() {
        return this.transperancy;
    }

    public void setShading(boolean shading) {
        this.wantShading = shading;
    }

    public boolean getShading() {
        return this.wantShading;
    }

    public void setFillColor(Color fillC) {
        this.fillColor = fillC;
    }

    public void setPenColor(Color fillC) {
        this.penColor = fillC;
    }

    public boolean getSolidRendering() {
        return this.wantSolidRendering;
    }

    public Color getPenColor() {
        return this.penColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void describe() {
    }
}

