/*
 * Decompiled with CFR 0.152.
 */
package org.hecl.net;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.Operator;
import org.hecl.Thing;
import org.hecl.net.Base64;

public class Base64Cmd
extends Operator {
    public static final int ENCODE = 1;
    public static final int DECODE = 2;
    private static Hashtable cmdtable = new Hashtable();

    @Override
    public Thing operate(int cmd, Interp interp, Thing[] argv) throws HeclException {
        switch (cmd) {
            case 1: {
                try {
                    return new Thing(new String(Base64.encode(argv[1].toString().getBytes("ISO-8859-1"))));
                }
                catch (UnsupportedEncodingException e) {
                    return new Thing(new String(Base64.encode(argv[1].toString().getBytes())));
                }
            }
            case 2: {
                try {
                    return new Thing(new String(Base64.decode(argv[1].toString(), "ISO-8859-1")));
                }
                catch (UnsupportedEncodingException e) {
                    return new Thing(new String(Base64.decode(argv[1].toString())));
                }
            }
        }
        throw new HeclException("Unknown base64 command '" + argv[0].toString() + "' with code '" + cmd + "'.");
    }

    public static void load(Interp ip) throws HeclException {
        Operator.load(ip, cmdtable);
    }

    public static void unload(Interp ip) throws HeclException {
        Operator.unload(ip, cmdtable);
    }

    protected Base64Cmd(int cmdcode, int minargs, int maxargs) {
        super(cmdcode, minargs, maxargs);
    }

    static {
        cmdtable.put("base64::encode", new Base64Cmd(1, 1, 1));
        cmdtable.put("base64::decode", new Base64Cmd(2, 1, 1));
    }
}

