/*
 * Decompiled with CFR 0.152.
 */
package org.hecl.java;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.IntThing;
import org.hecl.ListThing;
import org.hecl.LongThing;
import org.hecl.ObjectThing;
import org.hecl.Thing;

public class Reflector {
    private Class forclass;
    private Method[] methods;
    private Hashtable methodnames = null;
    private Hashtable constnames;
    private Hashtable fieldnames;
    private static Object[] return_value = new Object[1];

    public Reflector(String classname) throws HeclException {
        try {
            this.forclass = Class.forName(classname);
            this.methods = this.forclass.getMethods();
            this.constnames = new Hashtable();
            this.fieldnames = new Hashtable();
            for (Field f : this.forclass.getFields()) {
                int mod = f.getModifiers();
                StringBuffer msg = new StringBuffer("");
                String name = f.getName();
                this.fieldnames.put(name.toLowerCase(), f);
                if (!Modifier.isPublic(mod) || !Modifier.isFinal(mod) || !Modifier.isStatic(mod)) continue;
                Class<?> type = f.getType();
                if (type == Boolean.TYPE) {
                    this.constnames.put(name, IntThing.create(f.getBoolean(this.forclass)));
                    continue;
                }
                if (type == Double.TYPE) {
                    this.constnames.put(name, DoubleThing.create(f.getDouble(this.forclass)));
                    continue;
                }
                if (type == Float.TYPE) {
                    this.constnames.put(name, DoubleThing.create(f.getFloat(this.forclass)));
                    continue;
                }
                if (type == Integer.TYPE) {
                    this.constnames.put(name, IntThing.create(f.getInt(this.forclass)));
                    continue;
                }
                if (type == Long.TYPE) {
                    this.constnames.put(name, LongThing.create(f.getLong(this.forclass)));
                    continue;
                }
                if (type == String.class) {
                    this.constnames.put(name, new Thing((String)f.get(this.forclass)));
                    continue;
                }
                this.constnames.put(name, ObjectThing.create(f.get(this.forclass)));
            }
        }
        catch (Exception e) {
            throw new HeclException(e.toString());
        }
    }

    private void fillMethods() {
        this.methodnames = new Hashtable();
        for (Method m : this.methods) {
            Vector v = null;
            String name = m.getName().toLowerCase();
            v = this.methodnames.containsKey(name) ? (Vector)this.methodnames.get(name) : new Vector();
            v.add(m);
            this.methodnames.put(name, v);
        }
    }

    public Thing instantiate(Thing[] argv) throws HeclException {
        Object[] args = new Object[]{};
        Constructor<?> selected = null;
        Constructor<?>[] constructors = this.forclass.getConstructors();
        try {
            if (constructors == null) {
                throw new HeclException(this.forclass.toString() + " has no constructors!");
            }
            for (Constructor<?> c : constructors) {
                Class[] javaparams = c.getParameterTypes();
                if (javaparams.length != argv.length || !this.mapParams(return_value, javaparams, argv, 0)) continue;
                args = (Object[])return_value[0];
                selected = c;
                break;
            }
            if (selected == null) {
                throw new HeclException("Couldn't find a constructor for class:" + this.forclass.getName());
            }
            return ObjectThing.create(selected.newInstance(args));
        }
        catch (InvocationTargetException e) {
            String msg = "Problem invoking " + this.forclass.getName() + " constructor " + selected.getName() + " with arguments: ";
            for (Thing t : argv) {
                msg = msg + t.toString() + " ";
            }
            msg = msg + " (Translated to:) ";
            for (Object eo : args) {
                msg = msg + eo.toString() + " ";
            }
            msg = msg + " " + e.getTargetException().toString();
            throw new HeclException(msg);
        }
        catch (Exception e) {
            StringBuffer jtypes = new StringBuffer("");
            StringBuffer hvals = new StringBuffer("");
            for (Constructor<?> c : constructors) {
                jtypes.append(" (");
                for (Class<?> cls : c.getParameterTypes()) {
                    jtypes.append(cls.toString());
                    jtypes.append(" ");
                }
                jtypes.append(")");
            }
            hvals.append(" (");
            for (Thing t : argv) {
                hvals.append(t.toString() + " ");
            }
            hvals.append(")");
            throw new HeclException("Reflector instantiate error :" + e.toString() + " constructors: " + jtypes + " arguments:" + hvals);
        }
    }

    public Thing getField(Object target, String name) throws HeclException {
        Thing retval = null;
        Field f = (Field)this.fieldnames.get(name.toLowerCase());
        if (f == null) {
            throw new HeclException("No field matches " + name + " for class " + this.forclass.getName() + " " + this.fieldnames.toString());
        }
        try {
            Class<?> type = f.getType();
            retval = this.javaTypeToHeclType(type, f.get(target));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HeclException("Problem fetching field " + name + " : " + e.toString());
        }
        return retval;
    }

    public void setField(Object target, String name, Thing newvalue) throws HeclException {
        Field f = (Field)this.fieldnames.get(name.toLowerCase());
        if (f == null) {
            throw new HeclException("No field matches " + name + " for class " + this.forclass.getName() + " " + this.fieldnames.toString());
        }
        try {
            Class<?> type = f.getType();
            if (!this.heclTypeToJavaType(return_value, type, newvalue)) {
                throw new HeclException("no match found for " + type);
            }
            f.set(target, return_value[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HeclException("Problem setting field " + name + " to " + newvalue.toString() + " : " + e.toString());
        }
    }

    public Thing getConstField(String name) throws HeclException {
        Thing result = (Thing)this.constnames.get(name);
        if (result == null) {
            throw new HeclException("No field '" + name + "'");
        }
        return result;
    }

    public Thing evaluate(Object o, String cmd, Thing[] argv) throws HeclException {
        Object[] args = new Object[]{};
        Method selected = null;
        if (this.methodnames == null) {
            this.fillMethods();
        }
        try {
            Vector v = (Vector)this.methodnames.get(cmd.toLowerCase());
            if (v == null) {
                throw new HeclException("Method " + cmd + " not found for class" + this.forclass.toString());
            }
            Method[] methods = v.toArray(new Method[v.size()]);
            Class[] javaparams = null;
            for (Method m : methods) {
                javaparams = m.getParameterTypes();
                if (javaparams.length != argv.length - 2 || !this.mapParams(return_value, javaparams, argv, 2)) continue;
                args = (Object[])return_value[0];
                selected = m;
                break;
            }
            if (selected == null) {
                String msg = "No method matched " + cmd + " for class " + this.forclass.getName() + " last javaparams tried: ";
                if (javaparams != null) {
                    for (Class c : javaparams) {
                        msg = msg + c.getSimpleName() + " ";
                    }
                }
                throw new HeclException(msg);
            }
            Object retval = selected.invoke(o, args);
            return this.mapRetval(selected, retval);
        }
        catch (InvocationTargetException e) {
            String msg = "Problem invoking " + this.forclass.getName() + " " + cmd + "/" + selected.getName() + " with arguments: ";
            for (Thing t : argv) {
                msg = msg + t.toString() + " ";
            }
            msg = msg + " (Translated to:) ";
            for (Object eo : args) {
                msg = msg + eo.toString() + " ";
            }
            msg = msg + " " + e.getTargetException().toString();
            throw new HeclException(msg);
        }
        catch (Exception e) {
            throw new HeclException("Reflector evaluate error :" + e.toString());
        }
    }

    protected boolean mapParams(Object[] retval, Class[] outparams, Thing[] argv, int offset) throws HeclException {
        if (outparams.length != argv.length - offset) {
            return false;
        }
        boolean matched = true;
        Object[] outobjs = new Object[outparams.length];
        Object c = null;
        for (int i = 0; i < outparams.length; ++i) {
            Thing inparam = argv[i + offset];
            Class outparam = outparams[i];
            String javaclassname = outparam.getSimpleName();
            String val = inparam.toString();
            if (this.constnames.containsKey(val)) {
                inparam = (Thing)this.constnames.get(val);
            }
            String heclparmt = inparam.getVal().thingclass();
            if (this.heclTypeToJavaType(return_value, outparam, inparam)) {
                outobjs[i] = return_value[0];
                matched = true;
                continue;
            }
            matched = false;
        }
        retval[0] = outobjs;
        return matched;
    }

    private Thing mapRetval(Method m, Object o) {
        Class<?> rtype = m.getReturnType();
        return this.javaTypeToHeclType(rtype, o);
    }

    public boolean heclTypeToJavaType(Object[] retval, Class rtype, Thing heclparm) throws HeclException {
        boolean foundmatch = false;
        String heclparmt = heclparm.getVal().thingclass();
        String javaclassname = rtype.getSimpleName();
        if (heclparmt.equals("object") && ObjectThing.get(heclparm) == null) {
            foundmatch = true;
            retval[0] = null;
        } else if (rtype == Boolean.TYPE || rtype == Boolean.class) {
            if (heclparmt.equals("int")) {
                retval[0] = IntThing.get(heclparm) != 0;
                foundmatch = true;
            }
        } else if (rtype == Integer.TYPE || rtype == Integer.class) {
            if (heclparmt.equals("int")) {
                retval[0] = IntThing.get(heclparm);
                foundmatch = true;
            }
        } else if (rtype == Long.TYPE) {
            if (heclparmt.equals("long")) {
                retval[0] = LongThing.get(heclparm);
                foundmatch = true;
            }
        } else if (rtype == Float.TYPE || rtype == Float.class) {
            if (heclparmt.equals("double")) {
                retval[0] = Float.valueOf((float)DoubleThing.get(heclparm));
                foundmatch = true;
            }
        } else if (rtype == Double.TYPE || rtype == Double.class) {
            if (heclparmt.equals("double")) {
                retval[0] = DoubleThing.get(heclparm);
                foundmatch = true;
            }
        } else if (rtype == CharSequence.class || rtype == String.class) {
            if (heclparmt.equals("string")) {
                retval[0] = heclparm.toString();
                foundmatch = true;
            }
        } else if (javaclassname.equals("byte[]")) {
            if (heclparmt.equals("string")) {
                try {
                    retval[0] = heclparm.toString().getBytes("ISO8859_1");
                    foundmatch = true;
                }
                catch (UnsupportedEncodingException e) {
                    throw new HeclException(e.toString());
                }
            }
        } else if (javaclassname.equals("int[]")) {
            Vector v = ListThing.get(heclparm);
            int[] ints = new int[v.size()];
            for (int j = 0; j < v.size(); ++j) {
                ints[j] = IntThing.get((Thing)v.elementAt(j));
            }
            retval[0] = ints;
            foundmatch = true;
        } else if (javaclassname.equals("Object[]")) {
            Thing[] things = ListThing.getArray(heclparm);
            Object[] objects = new Object[things.length];
            int j = 0;
            for (Thing t : things) {
                objects[j] = t.getVal().thingclass().equals("object") ? ObjectThing.get(t) : t.toString();
                ++j;
            }
            retval[0] = objects;
            foundmatch = true;
        } else if (rtype == Thing.class) {
            retval[0] = heclparm;
            foundmatch = true;
        } else if (heclparmt.equals("object")) {
            retval[0] = ObjectThing.get(heclparm);
            foundmatch = true;
        } else if (rtype == Object.class) {
            retval[0] = heclparm;
            foundmatch = true;
        }
        return foundmatch;
    }

    public Thing javaTypeToHeclType(Class rtype, Object o) {
        String rtypename = rtype.getSimpleName();
        if (o == null) {
            return null;
        }
        if (rtype == Void.TYPE) {
            return null;
        }
        if (rtype == Integer.TYPE) {
            return IntThing.create((Integer)o);
        }
        if (rtype == Boolean.TYPE) {
            boolean val = ((Boolean)o).equals(Boolean.TRUE);
            return IntThing.create(val ? 1 : 0);
        }
        if (rtype == Long.TYPE) {
            return LongThing.create((Long)o);
        }
        if (rtype == String.class || rtype == CharSequence.class) {
            return new Thing((String)o);
        }
        if (rtype == List.class) {
            List lo = (List)o;
            Vector<Thing> v = new Vector<Thing>();
            for (int j = 0; j < lo.size(); ++j) {
                Object elem = lo.get(j);
                v.add(this.javaTypeToHeclType(elem.getClass(), elem));
            }
            return ListThing.create(v);
        }
        if (rtypename.equals("String[]")) {
            String[] retval;
            Vector<Thing> v = new Vector<Thing>();
            for (String s : retval = (String[])o) {
                v.add(new Thing(s));
            }
            return ListThing.create(v);
        }
        if (rtypename.equals("int[]")) {
            int[] retval;
            Vector<Thing> v = new Vector<Thing>();
            for (int i : retval = (int[])o) {
                v.add(IntThing.create(i));
            }
            return ListThing.create(v);
        }
        if (rtypename.equals("byte[]")) {
            String s = null;
            try {
                s = new String((byte[])o, "ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return new Thing(s);
        }
        if (rtype == Object.class && o.getClass() == Thing.class) {
            return (Thing)o;
        }
        return ObjectThing.create(o);
    }

    public Thing methods() throws HeclException {
        Vector<Thing> retval = new Vector<Thing>();
        if (this.methodnames == null) {
            this.fillMethods();
        }
        Enumeration e = this.methodnames.keys();
        while (e.hasMoreElements()) {
            Vector<Thing> signature = new Vector<Thing>();
            String key = (String)e.nextElement();
            signature.add(new Thing(key));
            Vector v = (Vector)this.methodnames.get(key);
            Method[] methods = v.toArray(new Method[v.size()]);
            Class<?>[] javaparams = null;
            for (Method m : methods) {
                for (Class<?> c : javaparams = m.getParameterTypes()) {
                    signature.add(new Thing(c.getSimpleName()));
                }
            }
            retval.add(ListThing.create(signature));
        }
        return ListThing.create(retval);
    }

    public Thing constructors() {
        Constructor<?>[] constructors;
        Vector<Thing> retval = new Vector<Thing>();
        for (Constructor<?> c : constructors = this.forclass.getConstructors()) {
            Class<?>[] params;
            Vector<Thing> paramnames = new Vector<Thing>();
            for (Class<?> p : params = c.getParameterTypes()) {
                paramnames.add(new Thing(p.getSimpleName()));
            }
            retval.add(ListThing.create(paramnames));
        }
        return ListThing.create(retval);
    }
}

