/*
 * Decompiled with CFR 0.152.
 */
package org.hecl.files;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Vector;
import org.hecl.HashThing;
import org.hecl.HeclException;
import org.hecl.IntThing;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.LongThing;
import org.hecl.ObjectThing;
import org.hecl.Operator;
import org.hecl.StringThing;
import org.hecl.Thing;
import org.hecl.files.HeclChannel;
import org.hecl.files.HeclFileUtils;

public class FileCmds
extends Operator {
    public static final int OPEN = 1;
    public static final int SOCKET = 5;
    public static final int READABLE = 10;
    public static final int WRITABLE = 20;
    public static final int HIDDEN = 30;
    public static final int EXISTS = 40;
    public static final int DELETE = 50;
    public static final int SIZE = 60;
    public static final int NAME = 70;
    public static final int PATH = 71;
    public static final int ABSPATH = 72;
    public static final int CANONPATH = 73;
    public static final int ISABSOLUTE = 74;
    public static final int MTIME = 80;
    public static final int ISDIRECTORY = 90;
    public static final int ISOPEN = 100;
    public static final int LIST = 110;
    public static final int MKDIR = 120;
    public static final int RENAME = 130;
    public static final int TRUNCATE = 140;
    public static final int LISTROOTS = 150;
    public static final int DU = 160;
    public static final int FILESPLIT = 170;
    public static final int FILEJOIN = 180;
    public static final int SOURCE = 190;
    public static final int CURRENTFILE = 200;
    public static final int CD = 210;
    public static final int GETCWD = 220;
    private static Hashtable cmdtable = new Hashtable();
    private static Hashtable cmdtableRestricted;

    @Override
    public Thing operate(int cmd, Interp interp, Thing[] argv) throws HeclException {
        String fname = null;
        switch (cmd) {
            case 180: {
                Vector filenamelist = ListThing.get(argv[1]);
                StringBuffer res = new StringBuffer("");
                boolean first = true;
                for (int i = 0; i < filenamelist.size(); ++i) {
                    if (!first) {
                        res.append(Interp.fileseparator);
                    } else if (!filenamelist.elementAt(i).toString().equals("/")) {
                        first = false;
                    }
                    res.append(filenamelist.elementAt(i).toString());
                }
                return new Thing(res.toString());
            }
            case 190: {
                HeclFileUtils.sourceFile(interp, argv[1].toString());
                return null;
            }
            case 200: {
                return interp.currentFile;
            }
            case 220: {
                return new Thing(System.getProperty("user.dir"));
            }
            case 210: {
                return new Thing(System.setProperty("user.dir", argv[1].toString()));
            }
        }
        File tfile = null;
        if (cmd != 150 && cmd != 5) {
            fname = StringThing.get(argv[1]);
            tfile = new File(fname);
        }
        switch (cmd) {
            case 1: {
                HeclChannel retval;
                String perms;
                boolean write = false;
                if (argv.length == 3 && (perms = argv[2].toString()).indexOf(119) > -1) {
                    write = true;
                }
                try {
                    retval = write ? new HeclChannel(new DataOutputStream(new FileOutputStream(new File(fname)))) : new HeclChannel(new DataInputStream(new FileInputStream(new File(fname))));
                }
                catch (IOException ioe) {
                    throw new HeclException("Error opening '" + fname + "' :" + ioe.toString());
                }
                return ObjectThing.create(retval);
            }
            case 5: {
                InetSocketAddress isa = null;
                try {
                    isa = new InetSocketAddress(argv[1].toString(), IntThing.get(argv[2]));
                    Socket sock = new Socket();
                    sock.connect(isa);
                    HeclChannel retval = new HeclChannel(new DataInputStream(sock.getInputStream()), new DataOutputStream(sock.getOutputStream()));
                    return ObjectThing.create(retval);
                }
                catch (IOException ioe) {
                    throw new HeclException("Error opening: " + isa + " " + ioe.toString());
                }
            }
            case 10: {
                return IntThing.create(tfile.canRead());
            }
            case 20: {
                return IntThing.create(tfile.canWrite());
            }
            case 30: {
                return IntThing.create(tfile.isHidden());
            }
            case 40: {
                return IntThing.create(tfile.exists());
            }
            case 50: {
                return IntThing.create(tfile.delete());
            }
            case 60: {
                return LongThing.create(tfile.length());
            }
            case 70: {
                return new Thing(tfile.getName());
            }
            case 71: {
                return new Thing(tfile.getPath());
            }
            case 72: {
                return new Thing(tfile.getAbsolutePath());
            }
            case 73: {
                try {
                    return new Thing(tfile.getCanonicalPath());
                }
                catch (Exception e) {
                    throw new HeclException("I/O error for file '" + tfile.toString() + ",: " + e.toString());
                }
            }
            case 74: {
                return IntThing.create(tfile.isAbsolute());
            }
            case 80: {
                return LongThing.create(tfile.lastModified());
            }
            case 90: {
                return IntThing.create(tfile.isDirectory());
            }
            case 100: {
                throw new HeclException("not implemented");
            }
            case 110: {
                Vector<Thing> v = new Vector<Thing>();
                String[] filenames = tfile.list();
                for (int i = 0; i < filenames.length; ++i) {
                    v.addElement(new Thing(filenames[i]));
                }
                return ListThing.create(v);
            }
            case 150: {
                Vector<Thing> v = new Vector<Thing>();
                File[] roots = File.listRoots();
                for (int i = 0; i < roots.length; ++i) {
                    v.addElement(new Thing(roots[i].getName()));
                }
                return ListThing.create(v);
            }
            case 120: {
                tfile.mkdir();
                return new Thing(fname);
            }
            case 130: {
                tfile.renameTo(new File(argv[2].toString()));
                return argv[2];
            }
            case 140: {
                throw new HeclException("not implemented");
            }
            case 160: {
                Hashtable<String, Thing> du = new Hashtable<String, Thing>();
                du.put("total", LongThing.create(tfile.getTotalSpace()));
                du.put("used", LongThing.create(tfile.getUsableSpace()));
                return HashThing.create(du);
            }
            case 170: {
                Vector<Thing> resultv = new Vector<Thing>();
                Vector<Thing> reversed = new Vector<Thing>();
                File fn = new File(fname);
                String ss = null;
                for (File pf = fn.getParentFile(); pf != null; pf = pf.getParentFile()) {
                    String pfs;
                    String fns = fn.toString();
                    ss = fns.substring((pfs = pf.toString()).length(), fns.length());
                    if (ss.charAt(0) == File.separatorChar) {
                        ss = ss.substring(1, ss.length());
                    }
                    reversed.addElement(new Thing(ss));
                    fn = pf;
                }
                reversed.addElement(new Thing(fn.toString()));
                int j = 0;
                for (int i = reversed.size() - 1; i >= 0; --i) {
                    Thing t = (Thing)reversed.elementAt(i);
                    resultv.addElement(t);
                    ++j;
                }
                return ListThing.create(resultv);
            }
        }
        throw new HeclException("Unknown file command '" + argv[0].toString() + "' with code '" + cmd + "'.");
    }

    public static void load(Interp ip) throws HeclException {
        Operator.load(ip, cmdtable);
    }

    public static void loadRestricted(Interp ip) throws HeclException {
        Operator.load(ip, cmdtableRestricted);
    }

    public static void unload(Interp ip) throws HeclException {
        Operator.unload(ip, cmdtable);
    }

    protected FileCmds(int cmdcode, int minargs, int maxargs) {
        super(cmdcode, minargs, maxargs);
    }

    static {
        try {
            cmdtable.put("open", new FileCmds(1, 1, 2));
            cmdtable.put("socket", new FileCmds(5, 2, 2));
            cmdtable.put("file.readable", new FileCmds(10, 1, 2));
            cmdtable.put("file.writable", new FileCmds(20, 1, 2));
            cmdtable.put("file.hidden", new FileCmds(30, 1, 2));
            cmdtable.put("file.exists", new FileCmds(40, 1, 1));
            cmdtable.put("file.size", new FileCmds(60, 1, 1));
            cmdtable.put("file.name", new FileCmds(70, 1, 1));
            cmdtable.put("file.path", new FileCmds(71, 1, 1));
            cmdtable.put("file.absolutepath", new FileCmds(72, 1, 1));
            cmdtable.put("file.canonicalpath", new FileCmds(73, 1, 1));
            cmdtable.put("file.isabsolute", new FileCmds(74, 1, 1));
            cmdtable.put("file.mtime", new FileCmds(80, 1, 1));
            cmdtable.put("file.isdirectory", new FileCmds(90, 1, 1));
            cmdtable.put("file.isopen", new FileCmds(100, 1, 1));
            cmdtable.put("file.delete", new FileCmds(50, 1, 1));
            cmdtable.put("file.mkdir", new FileCmds(120, 1, 1));
            cmdtable.put("file.truncate", new FileCmds(140, 1, 1));
            cmdtable.put("file.rename", new FileCmds(130, 2, 2));
            cmdtable.put("file.list", new FileCmds(110, 1, 1));
            cmdtable.put("file.devs", new FileCmds(150, 0, 0));
            cmdtable.put("file.du", new FileCmds(160, 1, 1));
            cmdtable.put("file.split", new FileCmds(170, 1, 1));
            cmdtable.put("file.join", new FileCmds(180, 1, 1));
            cmdtable.put("source", new FileCmds(190, 1, 1));
            cmdtable.put("file.current", new FileCmds(200, 0, 0));
            cmdtable.put("file.getcwd", new FileCmds(220, 0, 0));
            cmdtable.put("file.cd", new FileCmds(210, 1, 1));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Can't create file commands.");
        }
        cmdtableRestricted = new Hashtable();
        try {
            cmdtableRestricted.put("source", new FileCmds(190, 1, 1));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Can't create file commands.");
        }
    }
}

