/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import org.hecl.ClassCommandInfo;
import org.hecl.CodeThing;
import org.hecl.Command;
import org.hecl.GroupThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.ObjectThing;
import org.hecl.RealThing;
import org.hecl.SubstThing;
import org.hecl.Thing;

class Stanza {
    private int lineno = 0;
    private Command command = null;
    private Thing[] argv = null;

    Stanza(Command newcmd, Thing[] newargv, int ln) {
        this.command = newcmd;
        this.argv = newargv;
        this.lineno = ln;
    }

    public Stanza deepcopy() throws HeclException {
        Thing[] destargv = new Thing[this.argv.length];
        for (int i = 0; i < this.argv.length; ++i) {
            destargv[i] = this.argv[i].deepcopy();
        }
        return new Stanza(this.command, destargv, this.lineno);
    }

    private static Thing cloneThing(Interp interp, Thing t) throws HeclException {
        RealThing rt = t.getVal();
        Thing res = null;
        if (rt instanceof GroupThing) {
            res = CodeThing.doGroupSubst(interp, t);
            res.copy = true;
        } else if (rt instanceof SubstThing) {
            res = CodeThing.doSubstSubst(interp, t);
        } else if (rt instanceof CodeThing) {
            res = CodeThing.doCodeSubst(interp, t);
        } else {
            res = t;
            res.copy = true;
        }
        return res;
    }

    public Thing run(Interp interp) throws HeclException {
        RealThing realthing = null;
        Command tmpcommand = null;
        ClassCommandInfo info = null;
        Thing[] newargv = new Thing[this.argv.length];
        boolean saveit = false;
        String cmdName = null;
        newargv[0] = Stanza.cloneThing(interp, this.argv[0]);
        if (this.command == null) {
            realthing = newargv[0].getVal();
            if (realthing instanceof ObjectThing && (info = interp.findClassCmd(((ObjectThing)realthing).get().getClass())) != null && this.argv.length < 1) {
                throw new HeclException("Class-command required methodname", this.lineno);
            }
            if (info == null) {
                cmdName = newargv[0].toString();
            }
            if (cmdName != null) {
                tmpcommand = (Command)interp.commands.get(cmdName);
            }
        } else {
            cmdName = newargv[0].toString();
            tmpcommand = this.command;
        }
        if (tmpcommand == null && info == null) {
            throw new HeclException("Command '" + cmdName + "' does not exist", this.lineno);
        }
        try {
            for (int i = 1; i < this.argv.length; ++i) {
                realthing = this.argv[i].getVal();
                if (realthing instanceof GroupThing) {
                    newargv[i] = CodeThing.doGroupSubst(interp, this.argv[i]);
                    newargv[i].copy = true;
                    continue;
                }
                newargv[i] = realthing instanceof SubstThing ? CodeThing.doSubstSubst(interp, this.argv[i]) : (realthing instanceof CodeThing ? CodeThing.doCodeSubst(interp, this.argv[i]) : this.argv[i]);
            }
        }
        catch (HeclException he) {
            he.setLine(this.lineno);
            throw he;
        }
        Thing res = null;
        try {
            res = info != null ? info.getCommand().method(interp, info, newargv) : tmpcommand.cmdCode(interp, newargv);
        }
        catch (HeclException e) {
            if (newargv[0] != null) {
                e.where(newargv[0].toString(), this.lineno);
            }
            throw e;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            msg = msg == null ? "(null exception of type " + e.getClass() + ")" : "Exception of type " + e.getClass() + ": " + msg;
            throw new HeclException(msg, this.lineno);
        }
        finally {
            newargv = null;
        }
        if (saveit) {
            this.command = tmpcommand;
        }
        return res != null ? res : Thing.emptyThing();
    }

    public String toString() {
        StringBuffer out = new StringBuffer("");
        for (int i = 0; i < this.argv.length; ++i) {
            RealThing rt;
            if (i != 0) {
                out.append(' ');
            }
            if ((rt = this.argv[i].getVal()) instanceof CodeThing && ((CodeThing)rt).marksubst) {
                String avs = this.argv[i].toString();
                out.append('[').append(avs).append(']');
                continue;
            }
            if (rt instanceof GroupThing) {
                out.append('\"').append(this.argv[i].toString()).append('\"');
                continue;
            }
            ListThing.appendListItem(out, this.argv[i]);
        }
        return out.toString();
    }

    public Thing[] getArgv() {
        return this.argv;
    }
}

