/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Enumeration;
import java.util.Hashtable;
import org.hecl.Command;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.Thing;

public abstract class Operator
implements Command {
    protected int cmdcode;
    protected int minargs;
    protected int maxargs;

    protected Operator(int cmdcode, int minargs, int maxargs) {
        this.cmdcode = cmdcode;
        this.minargs = minargs;
        this.maxargs = maxargs;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        Interp.checkArgCount(argv, this.minargs, this.maxargs);
        return this.operate(this.cmdcode, interp, argv);
    }

    public abstract Thing operate(int var1, Interp var2, Thing[] var3) throws HeclException;

    protected static void load(Interp ip, Hashtable cmdtable) throws HeclException {
        Enumeration e = cmdtable.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            ip.addCommand(k, (Command)cmdtable.get(k));
        }
    }

    protected static void unload(Interp ip, Hashtable cmdtable) throws HeclException {
        Enumeration e = cmdtable.keys();
        while (e.hasMoreElements()) {
            ip.removeCommand((String)e.nextElement());
        }
    }
}

