/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.IntThing;
import org.hecl.LongThing;
import org.hecl.RealThing;
import org.hecl.Thing;

public abstract class NumberThing
implements RealThing {
    @Override
    public abstract RealThing deepcopy() throws HeclException;

    @Override
    public abstract String getStringRep();

    public static boolean isNumber(Thing t) {
        return t.getVal() instanceof NumberThing;
    }

    public static boolean isNumber(RealThing rt) {
        return rt instanceof NumberThing;
    }

    public static boolean isIntegral(Thing t) {
        RealThing rt = t.getVal();
        return NumberThing.isNumber(rt) && ((NumberThing)rt).isIntegral();
    }

    public static boolean isFractional(Thing t) {
        RealThing rt = t.getVal();
        return NumberThing.isNumber(rt) && ((NumberThing)rt).isFractional();
    }

    public abstract boolean isIntegral();

    public abstract boolean isFractional();

    public abstract byte byteValue();

    public abstract short shortValue();

    public abstract int intValue();

    public abstract long longValue();

    public abstract float floatValue();

    public abstract double doubleValue();

    public static NumberThing asNumber(Thing t) throws NumberFormatException {
        if (NumberThing.isNumber(t)) {
            return (NumberThing)t.getVal();
        }
        String s = t.toString();
        try {
            return new IntThing(s);
        }
        catch (NumberFormatException ne) {
            try {
                return new LongThing(s);
            }
            catch (NumberFormatException ne2) {
                return new DoubleThing(s);
            }
        }
    }

    public static Thing create(NumberThing n) {
        return new Thing(n);
    }
}

