/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Stack;
import java.util.Vector;
import org.hecl.IntThing;
import org.hecl.ListThing;
import org.hecl.Thing;

public class HeclException
extends Exception {
    public String code = null;
    Stack stack;
    Thing value = null;
    Thing message = null;
    static final String BREAK = "BREAK";
    static final String CONTINUE = "CONT";
    static final String RETURN = "RETURN";
    static final String ERROR = "ERROR";

    public HeclException(String s) {
        this(s, ERROR, null);
    }

    public HeclException(String s, int lineno) {
        this(s, ERROR, null);
        try {
            this.setLine(lineno);
        }
        catch (HeclException heclException) {
            // empty catch block
        }
    }

    public HeclException(String s, String exception_code) {
        this(s, exception_code, null);
    }

    HeclException(String s, String exception_code, Thing value) {
        super(s);
        this.message = new Thing(s);
        this.value = value;
        this.code = exception_code;
        this.pushException(s);
    }

    private void pushException(String s) {
        this.stack = new Stack();
        Vector<Thing> lst = new Vector<Thing>();
        lst.addElement(new Thing(this.code));
        lst.addElement(this.message);
        this.stack.push(new Thing(new ListThing(lst)));
    }

    public void where(String cmd, int lineno) {
        Vector<Thing> lst = new Vector<Thing>();
        lst.addElement(new Thing(cmd));
        lst.addElement(IntThing.create(lineno));
        this.stack.push(new Thing(new ListThing(lst)));
    }

    @Override
    public String toString() {
        return this.getStack().toString();
    }

    public Thing getStack() {
        return ListThing.create(this.stack);
    }

    public static StringBuffer argvToString(Thing[] argv) {
        return HeclException.argvToString(argv, argv.length);
    }

    public static StringBuffer argvToString(Thing[] argv, int count) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < count && i < argv.length; ++i) {
            str.append(argv[i].toString());
            str.append(" ");
        }
        return str;
    }

    public static HeclException createWrongNumArgsException(Thing[] argv, int count, String message) throws HeclException {
        StringBuffer str = HeclException.argvToString(argv, count);
        return new HeclException("wrong # args: should be \"" + str + message + "\"");
    }

    public static HeclException createInvalidParameter(Thing param, String type, String options) throws HeclException {
        return new HeclException("invalid " + type + " specified \"" + param.toString() + "\"; should be: " + options + ".");
    }

    public void setLine(int lineno) throws HeclException {
        Stack ex = this.stack;
        Vector err = ListThing.get((Thing)ex.elementAt(0));
        Thing l = IntThing.create(lineno);
        if (err.size() == 2) {
            err.addElement(l);
        } else {
            err.setElementAt(l, 2);
        }
    }
}

