/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hecl.HashThing;
import org.hecl.HeclException;
import org.hecl.IntThing;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.Operator;
import org.hecl.Thing;

class HashCmds
extends Operator {
    public static final int HASH = 0;
    public static final int HGET = 1;
    public static final int HSET = 2;
    public static final int HKEYS = 3;
    public static final int HCLEAR = 4;
    public static final int HREMOVE = 5;
    public static final int HCONTAINS = 6;
    private static Hashtable cmdtable = new Hashtable();

    @Override
    public Thing operate(int cmd, Interp interp, Thing[] argv) throws HeclException {
        Hashtable hash = cmd != 0 ? HashThing.get(argv[1]) : null;
        Thing result = null;
        switch (cmd) {
            case 0: {
                result = HashThing.create(HashThing.get(argv[1]));
                break;
            }
            case 1: {
                result = (Thing)hash.get(argv[2].toString());
                break;
            }
            case 2: {
                result = argv[3];
                hash.put(argv[2].toString(), result);
                break;
            }
            case 3: {
                Vector<Thing> v = new Vector<Thing>(hash.size());
                Enumeration e = hash.keys();
                while (e.hasMoreElements()) {
                    v.addElement(new Thing((String)e.nextElement()));
                }
                return ListThing.create(v);
            }
            case 4: {
                hash.clear();
                result = argv[1];
                break;
            }
            case 5: {
                Object o = hash.remove(argv[2].toString());
                result = o != null ? (Thing)o : new Thing("");
                break;
            }
            case 6: {
                result = new Thing(hash.containsKey(argv[2].toString()) ? IntThing.ONE : IntThing.ZERO);
                break;
            }
            default: {
                throw new HeclException("Unknown hash command '" + argv[0].toString() + "' with code '" + cmd + "'.");
            }
        }
        return result;
    }

    public static void load(Interp ip) throws HeclException {
        Operator.load(ip, cmdtable);
    }

    public static void unload(Interp ip) throws HeclException {
        Operator.unload(ip, cmdtable);
    }

    protected HashCmds(int cmdcode, int minargs, int maxargs) {
        super(cmdcode, minargs, maxargs);
    }

    static {
        cmdtable.put("hash", new HashCmds(0, 1, 1));
        cmdtable.put("hget", new HashCmds(1, 2, 2));
        cmdtable.put("hset", new HashCmds(2, 3, 3));
        cmdtable.put("hkeys", new HashCmds(3, 1, 1));
        cmdtable.put("hclear", new HashCmds(4, 1, 1));
        cmdtable.put("hremove", new HashCmds(5, 2, 2));
        cmdtable.put("hcontains", new HashCmds(6, 2, 2));
    }
}

