/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.statics;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import no.geosoft.cc.geometry.Geometry;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class StatActionlineCmd
implements Command {
    API api;
    boolean debug = false;

    public StatActionlineCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        if (argd.length < 4) {
            throw new HeclException("Illegal nb of arguments.");
        }
        assert (argd.length >= 4);
        double x0 = argd[0];
        double y0 = argd[1];
        double Fx = argd[2];
        double Fy = argd[3];
        double x1 = x0 + this.api.fu(Fx);
        double y1 = y0 + this.api.fu(Fy);
        double[] A = new double[2];
        double[] B = new double[2];
        switch (argd.length) {
            case 6: {
                double fA = argd[4];
                double fB = argd[5];
                B = Geometry.computePointOnLine(x0, y0, x1, y1, fB);
                A = Geometry.computePointOnLine(x1, y1, x0, y0, fA);
                break;
            }
            case 5: {
                double f = argd[4];
                B = Geometry.computePointOnLine(x0, y0, x1, y1, f);
                A = Geometry.computePointOnLine(x1, y1, x0, y0, f);
                break;
            }
            case 4: {
                A[0] = x0;
                A[1] = y0;
                B[0] = x1;
                B[1] = y1;
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        String xAstr = StringThing.get(DoubleThing.create(A[0]));
        String yAstr = StringThing.get(DoubleThing.create(A[1]));
        String xBstr = StringThing.get(DoubleThing.create(B[0]));
        String yBstr = StringThing.get(DoubleThing.create(B[1]));
        String answer = xAstr + " " + yAstr + " " + xBstr + " " + yBstr;
        return new Thing(answer);
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

