/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.geom;

import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class GeomSubtractCmd
implements Command {
    boolean debug = false;

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        if (argv.length < 3) {
            throw new HeclException("Illegal nb of arguments.");
        }
        double[][] argp = new double[argv.length - 1][2];
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            if (currentargv.length != 2) {
                throw new HeclException("Illegal argument format. \"nb nb\" expected.");
            }
            double x = NumberThing.asNumber(currentargv[0]).doubleValue();
            double y = NumberThing.asNumber(currentargv[1]).doubleValue();
            argp[i - 1][0] = x;
            argp[i - 1][1] = y;
        }
        double[] result = argp[0];
        for (int i = 1; i < argp.length; ++i) {
            result[0] = result[0] - argp[i][0];
            result[1] = result[1] - argp[i][1];
        }
        String xstr = StringThing.get(DoubleThing.create(result[0]));
        String ystr = StringThing.get(DoubleThing.create(result[1]));
        String answer = xstr + " " + ystr;
        return new Thing(answer);
    }
}

