/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.geom;

import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class GeomMultiplyCmd
implements Command {
    boolean debug = false;

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        if (argv.length != 3) {
            throw new HeclException("Illegal nb of arguments.");
        }
        Thing[] factorargv = ListThing.getArray(argv[1]);
        if (factorargv.length != 1) {
            throw new HeclException("Illegal argument format. 'nb \"nb nb\"' expected.");
        }
        double factor = NumberThing.asNumber(factorargv[0]).doubleValue();
        double[] vector = new double[2];
        Thing[] currentargv = ListThing.getArray(argv[2]);
        if (currentargv.length != 2) {
            throw new HeclException("Illegal argument format. 'nb \"nb nb\"' expected.");
        }
        vector[0] = NumberThing.asNumber(currentargv[0]).doubleValue();
        vector[1] = NumberThing.asNumber(currentargv[1]).doubleValue();
        double[] result = vector;
        result[0] = result[0] * factor;
        result[1] = result[1] * factor;
        String xstr = StringThing.get(DoubleThing.create(result[0]));
        String ystr = StringThing.get(DoubleThing.create(result[1]));
        String answer = xstr + " " + ystr;
        return new Thing(answer);
    }
}

