/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.StringThing;
import org.hecl.Thing;

public class TextCmd
implements Command {
    API api;
    boolean debug = false;

    public TextCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        String text = argv.length > 1 ? StringThing.get(argv[1]) : "";
        switch (argv.length - 1) {
            case 0: {
                this.api.text("");
                break;
            }
            case 1: {
                this.api.text(text);
                break;
            }
            case 2: {
                boolean justified;
                double availablewidth;
                try {
                    availablewidth = DoubleThing.get(argv[2]);
                    justified = false;
                }
                catch (NumberFormatException e) {
                    availablewidth = -1.0;
                    justified = this.getTextStyle(StringThing.get(argv[2]));
                }
                this.api.text(text, availablewidth, justified);
                break;
            }
            case 3: {
                boolean ok;
                double availablewidth = 0.0;
                String str = "";
                try {
                    availablewidth = DoubleThing.get(argv[2]);
                    str = StringThing.get(argv[3]);
                    ok = true;
                }
                catch (NumberFormatException e) {
                    ok = false;
                }
                if (!ok) {
                    try {
                        str = StringThing.get(argv[2]);
                        availablewidth = DoubleThing.get(argv[3]);
                        ok = true;
                    }
                    catch (NumberFormatException e) {
                        ok = false;
                    }
                }
                if (ok) {
                    boolean justified = this.getTextStyle(str);
                    this.api.text(text, availablewidth, justified);
                    break;
                }
                throw new HeclException("Illegal arguments for text: " + StringThing.get(argv[2]) + " " + StringThing.get(argv[3]));
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        return null;
    }

    private boolean getTextStyle(String str) throws HeclException {
        String s = str.toLowerCase();
        if (s.equals("justify")) {
            return true;
        }
        if (s.equals("left")) {
            return false;
        }
        throw new HeclException("Illegal argument for text alignment : " + str);
    }
}

