/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.Thing;

public class QuadcurveCmd
implements Command {
    API api;
    boolean debug = false;

    public QuadcurveCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        switch (argd.length) {
            case 6: {
                this.api.quadcurve(argd[0], argd[1], argd[2], argd[3], argd[4], argd[5]);
                break;
            }
            case 4: {
                double[] xy0 = this.api.here();
                this.api.quadcurve(xy0[0], xy0[1], argd[0], argd[1], argd[2], argd[3]);
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        return null;
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

