/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import net.sf.drawj2d.cmd.API;
import net.sf.drawj2d.cmd.Fkt;
import org.hecl.Command;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.NumberThing;
import org.hecl.Thing;

public class NfCmd
implements Command {
    API api;
    boolean debug = false;

    public NfCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        int digits;
        double number;
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        switch (argv.length - 1) {
            case 2: {
                number = NumberThing.asNumber(argv[1]).doubleValue();
                digits = NumberThing.asNumber(argv[2]).intValue();
                break;
            }
            case 1: {
                number = NumberThing.asNumber(argv[1]).doubleValue();
                digits = this.api.getdecdigits();
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        String dimstr = Fkt.nf(number, digits);
        return new Thing(dimstr);
    }
}

