/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class HereCmd
implements Command {
    API api;
    boolean debug = false;

    public HereCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        double y1;
        double x1;
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        double[] currentpos = this.api.here();
        switch (argd.length) {
            case 0: {
                x1 = currentpos[0];
                y1 = currentpos[1];
                break;
            }
            case 2: {
                x1 = currentpos[0] + argd[0];
                y1 = currentpos[1] + argd[1];
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        String xstr = StringThing.get(DoubleThing.create(x1));
        String ystr = StringThing.get(DoubleThing.create(y1));
        String answer = xstr + " " + ystr;
        return new Thing(answer);
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

