/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class ForceCmd
implements Command {
    API api;
    boolean isTeX;
    boolean debug = false;

    public ForceCmd(API api, boolean isTeX) {
        this.api = api;
        this.isTeX = isTeX;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        String lb = "";
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            Thing currentThing = singleargv.get(i);
            try {
                argd[i] = NumberThing.asNumber(currentThing).doubleValue();
                continue;
            }
            catch (NumberFormatException ex) {
                if (lb.equals("")) {
                    lb = StringThing.get(currentThing);
                    continue;
                }
                throw new HeclException("Illegal arguments.");
            }
        }
        switch (nbsingleargs) {
            case 5: {
                if (lb.equals("")) {
                    lb = StringThing.get(singleargv.get(4));
                }
                this.api.moveto(argd[0], argd[1]);
                this.api.force(argd[2], argd[3], lb, this.isTeX);
                break;
            }
            case 4: {
                this.api.moveto(argd[0], argd[1]);
                this.api.force(argd[2], argd[3], this.isTeX);
                break;
            }
            case 3: {
                if (lb.equals("")) {
                    lb = StringThing.get(singleargv.get(2));
                }
                this.api.force(argd[0], argd[1], lb, this.isTeX);
                break;
            }
            case 2: {
                this.api.force(argd[0], argd[1], this.isTeX);
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        return null;
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

