/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.bgd;

public class clHintergrundBogen {
    private double[] zentrum = new double[2];
    private double radius;
    private final double[] sektor = new double[2];

    clHintergrundBogen(double X, double Z, double radius, double startwinkel, double endwinkel) {
        this.zentrum[0] = X;
        this.zentrum[1] = Z;
        this.radius = radius;
        this.sektor[0] = startwinkel;
        this.sektor[1] = endwinkel;
    }

    public boolean skaliere(double faktorx, double faktorz) {
        assert (Math.abs(faktorx) >= 1.0E-9);
        assert (Math.abs(faktorz) >= 1.0E-9);
        this.zentrum[0] = faktorx * this.zentrum[0];
        this.zentrum[1] = faktorz * this.zentrum[1];
        double faktor = Math.sqrt(Math.abs(faktorx * faktorz));
        this.radius = faktor * this.radius;
        if (faktorx != faktorz || faktorx < 0.0) {
            double startwinkel = -Math.toRadians(this.sektor[0]);
            startwinkel = Math.atan2(faktorz * Math.sin(startwinkel), faktorx * Math.cos(startwinkel));
            double endwinkel = -Math.toRadians(this.sektor[1]);
            endwinkel = Math.atan2(faktorz * Math.sin(endwinkel), faktorx * Math.cos(endwinkel));
            if (faktorx * faktorz >= 0.0) {
                this.sektor[0] = -Math.toDegrees(startwinkel);
                this.sektor[1] = -Math.toDegrees(endwinkel);
            } else {
                this.sektor[0] = -Math.toDegrees(endwinkel);
                this.sektor[1] = -Math.toDegrees(startwinkel);
            }
        }
        return true;
    }

    public void verschiebe(double dx, double dz) {
        this.zentrum[0] = this.zentrum[0] + dx;
        this.zentrum[1] = this.zentrum[1] + dz;
    }

    public void rotiere(double rot) {
        double X = this.zentrum[0];
        double Z = this.zentrum[1];
        this.zentrum[0] = X * Math.cos(rot) - Z * Math.sin(rot);
        this.zentrum[1] = X * Math.sin(rot) + Z * Math.cos(rot);
        this.sektor[0] = Math.toDegrees(Math.toRadians(this.sektor[0]) - rot);
        this.sektor[1] = Math.toDegrees(Math.toRadians(this.sektor[1]) - rot);
    }

    public double[] getZentrum() {
        return this.zentrum;
    }

    public double getRadius() {
        return this.radius;
    }

    public double[] getSektor() {
        return this.sektor;
    }
}

