/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sf.drawj2d.Drawj2d;
import net.sf.drawj2d.YourPanel;
import net.sf.drawj2d.inConst;
import org.freehep.graphicsbase.swing.Headless;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;

public class FreehepMode
implements inConst {
    protected double res;
    boolean success = true;
    private int type;
    private final boolean quiet;
    private final boolean verbose;
    private final String filename;
    private final String suffix;
    private final String quelldatei;
    protected final double width;
    protected final double height;
    private final double originX;
    private final double originY;
    private final int srcType;
    private JPanel yourPanel;
    private Dimension dim;
    private final boolean debug = false;

    public FreehepMode(Drawj2d c) {
        this.quiet = c.quiet;
        this.verbose = c.verbose;
        this.width = c.width;
        this.height = c.height;
        this.originX = c.originX;
        this.originY = c.originY;
        this.filename = c.zieldatei;
        this.suffix = c.outputtype.toLowerCase();
        this.quelldatei = c.quelldatei;
        this.srcType = c.srcType;
        if (!this.quiet) {
            System.out.println("Mode: Freehep");
        }
        this.res = 72.0;
        if (this.suffix.equals("svg")) {
            this.type = 1;
            this.res = 96.0;
        } else if (this.suffix.equals("eps") || this.suffix.equals("ps")) {
            this.type = 2;
        } else if (this.suffix.equals("pdf")) {
            this.type = 3;
        } else if (this.suffix.equals("emf")) {
            this.type = 4;
            this.res = 81.27;
        } else {
            String[] IOsuffixes;
            for (String t : IOsuffixes = ImageIO.getWriterFileSuffixes()) {
                if (!t.equals(this.suffix)) continue;
                this.type = 5;
                this.res = 200.0;
            }
        }
    }

    public void setResolution(double resolution) {
        switch (this.type) {
            case 2: 
            case 3: {
                if (this.quiet) break;
                System.out.println("Setting resolution without effect for " + this.suffix);
                break;
            }
            default: {
                this.res = resolution;
            }
        }
    }

    public boolean run() {
        int pxwidth = (int)Math.rint(this.width * this.res / 25.4);
        int pxheight = (int)Math.rint(this.height * this.res / 25.4);
        this.dim = new Dimension(pxwidth, pxheight);
        this.yourPanel = new YourPanel(this.dim, this, this.quelldatei, this.originX, this.originY, this.verbose, this.srcType);
        Headless headless = new Headless((JComponent)this.yourPanel);
        headless.pack();
        headless.setVisible(true);
        this.writeOutput();
        return this.success;
    }

    private void writeOutput() {
        File out = new File(this.filename);
        SVGGraphics2D graphics = null;
        try {
            switch (this.type) {
                case 1: {
                    graphics = new SVGGraphics2D(out, (Component)this.yourPanel);
                    graphics.setCreator("Drawj2d");
                    break;
                }
                case 2: {
                    graphics = new PSGraphics2D(out, (Component)this.yourPanel);
                    Properties peps = new Properties();
                    peps.setProperty(PSGraphics2D.PAGE_SIZE, PSGraphics2D.CUSTOM_PAGE_SIZE);
                    peps.setProperty(PSGraphics2D.CUSTOM_PAGE_SIZE, "" + this.dim.width + ", " + this.dim.height);
                    peps.setProperty(PSGraphics2D.PAGE_MARGINS, "0, 0, 0, 0");
                    peps.setProperty(PSGraphics2D.FIT_TO_PAGE, "false");
                    graphics.setProperties(peps);
                    break;
                }
                case 3: {
                    graphics = new PDFGraphics2D(out, (Component)this.yourPanel);
                    Properties p = new Properties();
                    p.setProperty(PDFGraphics2D.PAGE_SIZE, PDFGraphics2D.CUSTOM_PAGE_SIZE);
                    p.setProperty(PDFGraphics2D.CUSTOM_PAGE_SIZE, "" + this.dim.width + ", " + this.dim.height);
                    p.setProperty(PDFGraphics2D.PAGE_MARGINS, "0, 0, 0, 0");
                    p.setProperty(PDFGraphics2D.FIT_TO_PAGE, "false");
                    graphics.setProperties(p);
                    graphics.setCreator("Drawj2d");
                    break;
                }
                case 4: {
                    graphics = new EMFGraphics2D(out, (Component)this.yourPanel);
                    graphics.setDeviceIndependent(true);
                    break;
                }
                case 5: {
                    graphics = new ImageGraphics2D(out, (Component)this.yourPanel, this.suffix);
                    break;
                }
                default: {
                    System.err.println("Not supported: " + this.suffix);
                    this.success = false;
                    break;
                }
            }
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getLocalizedMessage());
            graphics = null;
            this.success = false;
        }
        catch (IOException ex) {
            System.err.println(ex.getLocalizedMessage());
            graphics = null;
            this.success = false;
        }
        if (this.success && graphics != null) {
            graphics.startExport();
            this.yourPanel.print((Graphics)graphics);
            graphics.endExport();
        }
        if (this.success) {
            System.out.println("Output written to: " + this.filename);
        } else {
            System.out.println("Error occurred. Check for error messages.");
        }
    }
}

