/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.browser.core.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.ByteBuffer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tmatesoft.sqljet.browser.core.BrowserComponentManager;
import org.tmatesoft.sqljet.browser.core.IBrowserComponent;
import org.tmatesoft.sqljet.browser.core.IBrowserRunnable;
import org.tmatesoft.sqljet.browser.core.IProgress;
import org.tmatesoft.sqljet.browser.core.data.DataTableModel;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public class DataComponent
implements IBrowserComponent,
ItemListener,
ActionListener {
    private JComponent myComponent;
    private JComboBox myTableNamesCombo;
    private JButton myNextButton;
    private JButton myPreviousButton;
    private JLabel myRangeLabel;
    private JTable myDataTable;
    private File myDBFile;
    private Object myLastSelectedItem;
    private BrowserComponentManager myManager;
    private int myPageSize;

    public DataComponent(BrowserComponentManager manager, int pageSize) {
        this.myManager = manager;
        this.myPageSize = pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File dbFile) throws SqlJetException {
        this.myDBFile = dbFile;
        if (dbFile == null) {
            this.myTableNamesCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{"<empty>"}));
            this.myTableNamesCombo.setEnabled(false);
        } else {
            SqlJetDb db = null;
            try {
                db = SqlJetDb.open((File)dbFile, (boolean)true);
                this.myTableNamesCombo.setModel(new DefaultComboBoxModel<Object>(db.getSchema().getTableNames().toArray()));
                this.myTableNamesCombo.setEnabled(this.myTableNamesCombo.getModel().getSize() > 0);
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        if (this.myTableNamesCombo.isEnabled()) {
            this.myTableNamesCombo.setSelectedIndex(0);
        }
        this.itemStateChanged(null);
    }

    public JComponent getComponent() {
        if (this.myComponent != null) {
            return this.myComponent;
        }
        this.myComponent = new JPanel(new BorderLayout());
        JPanel comboPanel = new JPanel(new FlowLayout(0));
        comboPanel.add(new JLabel("Table:"));
        this.myTableNamesCombo = new JComboBox();
        this.myTableNamesCombo.addItemListener(this);
        comboPanel.add(this.myTableNamesCombo);
        this.myPreviousButton = new JButton("<");
        this.myNextButton = new JButton(">");
        this.myRangeLabel = new JLabel();
        this.myRangeLabel.setMinimumSize(new Dimension(100, 0));
        this.myPreviousButton.addActionListener(this);
        this.myNextButton.addActionListener(this);
        JPanel rangePanel = new JPanel(new FlowLayout(2));
        rangePanel.add(this.myPreviousButton);
        rangePanel.add(this.myRangeLabel);
        rangePanel.add(this.myNextButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)comboPanel, "West");
        topPanel.add((Component)rangePanel, "East");
        this.myComponent.add((Component)topPanel, "North");
        this.myDataTable = new JTable();
        this.myDataTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof ByteBuffer) {
                    String strValue = null;
                    ByteBuffer buffer = (ByteBuffer)value;
                    int toGet = Math.min(16, buffer.limit());
                    byte[] dst = new byte[toGet];
                    buffer.get(dst);
                    buffer.rewind();
                    strValue = new String(dst, 0, dst.length);
                    if (dst.length < buffer.limit()) {
                        strValue = strValue + "... [" + (buffer.limit() - toGet) + " bytes more]";
                    }
                    value = strValue;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.myDataTable);
        scrollPane.getViewport().setBackground(this.myDataTable.getBackground());
        scrollPane.getViewport().setOpaque(true);
        this.myComponent.add((Component)scrollPane, "Center");
        return this.myComponent;
    }

    public String getTip() {
        return this.getTitle();
    }

    public String getTitle() {
        return "Browse Data";
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.myTableNamesCombo.getSelectedItem() == this.myLastSelectedItem) {
            return;
        }
        this.myLastSelectedItem = this.myTableNamesCombo.getSelectedItem();
        this.loadData(this.myDBFile, (String)this.myLastSelectedItem, 0L);
    }

    public void actionPerformed(ActionEvent e) {
        TableModel model = this.myDataTable.getModel();
        if (model instanceof DataTableModel) {
            long start = ((DataTableModel)model).getFirstIndex();
            start = e.getSource() == this.myPreviousButton ? (start -= (long)this.myPageSize) : (start += (long)this.myPageSize);
            this.loadData(this.myDBFile, (String)this.myTableNamesCombo.getSelectedItem(), start);
        }
    }

    private void loadData(final File dbFile, final String tableName, final long row) {
        this.myManager.schedule(new IBrowserRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgress progress) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DataComponent.this.myPreviousButton.setEnabled(false);
                        DataComponent.this.myNextButton.setEnabled(false);
                        DataComponent.this.myRangeLabel.setEnabled(false);
                    }
                });
                TableModel model = null;
                if (dbFile == null) {
                    model = new DefaultTableModel();
                } else {
                    progress.start("Loading Data...", DataComponent.this.myPageSize);
                    SqlJetDb db = null;
                    try {
                        db = SqlJetDb.open((File)dbFile, (boolean)true);
                        ISqlJetTable table = db.getTable(tableName);
                        model = DataTableModel.createInstance(table, row, DataComponent.this.myPageSize, progress);
                    }
                    catch (Throwable th) {
                        model = new DefaultTableModel();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DataComponent.this.myManager.showErrorDialog(th);
                            }
                        });
                    }
                    finally {
                        if (db != null) {
                            try {
                                db.close();
                            }
                            catch (SqlJetException e) {}
                        }
                        progress.finish();
                    }
                }
                DataComponent.this.installModel(model);
            }
        }, true);
    }

    private void installModel(final TableModel model) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DataComponent.this.myDataTable.setModel(model);
                DataComponent.this.myNextButton.setEnabled(model.getRowCount() == DataComponent.this.myPageSize);
                long start = 0L;
                if (model instanceof DataTableModel) {
                    start = ((DataTableModel)model).getFirstIndex();
                    if (start == 0L && model.getRowCount() == 0) {
                        DataComponent.this.myRangeLabel.setText("empty");
                        DataComponent.this.myRangeLabel.setEnabled(false);
                    } else {
                        DataComponent.this.myRangeLabel.setText(start + 1L + " - " + (start + (long)model.getRowCount()));
                        DataComponent.this.myRangeLabel.setEnabled(true);
                    }
                } else {
                    DataComponent.this.myRangeLabel.setText("empty");
                    DataComponent.this.myRangeLabel.setEnabled(false);
                }
                DataComponent.this.myPreviousButton.setEnabled(start > 0L);
            }
        });
    }
}

