/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.browser.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tmatesoft.sqljet.browser.DBBrowserUtil;
import org.tmatesoft.sqljet.browser.core.IBrowserComponent;
import org.tmatesoft.sqljet.browser.core.IBrowserRunnable;
import org.tmatesoft.sqljet.browser.core.IProgress;
import org.tmatesoft.sqljet.browser.core.data.DataComponent;
import org.tmatesoft.sqljet.browser.core.schema.SchemaComponent;
import org.tmatesoft.sqljet.core.SqlJetVersion;

public class BrowserComponentManager
implements ChangeListener,
IProgress {
    private JPanel myPanel;
    private JTabbedPane myComponent;
    private IBrowserComponent mySchemaPage;
    private IBrowserComponent myDataPage;
    private Set<IBrowserComponent> myInactivatedPages = new HashSet<IBrowserComponent>();
    private File myDBFile;
    private JFrame myOwner;
    private ExecutorService myExecutor = Executors.newSingleThreadExecutor();
    private Collection<Future<?>> myScheduledTasks = new LinkedList();
    private JProgressBar myProgress;
    private Set<ChangeListener> myListeners = new HashSet<ChangeListener>();

    public static BrowserComponentManager create(JFrame owner) {
        return new BrowserComponentManager(owner);
    }

    private BrowserComponentManager(JFrame owner) {
        this.myOwner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        Set<ChangeListener> set = this.myListeners;
        synchronized (set) {
            this.myListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        Set<ChangeListener> set = this.myListeners;
        synchronized (set) {
            this.myListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStateChanged() {
        ChangeListener[] listeners = null;
        Set<ChangeListener> set = this.myListeners;
        synchronized (set) {
            listeners = this.myListeners.toArray(new ChangeListener[this.myListeners.size()]);
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : listeners) {
            l.stateChanged(event);
        }
    }

    public File getDBFile() {
        return this.myDBFile;
    }

    public JComponent getComponent() {
        if (this.myPanel != null) {
            return this.myPanel;
        }
        this.myPanel = new JPanel(new BorderLayout());
        this.mySchemaPage = new SchemaComponent();
        this.myDataPage = new DataComponent(this, 1000);
        this.myComponent = new JTabbedPane();
        this.mySchemaPage.getComponent().putClientProperty(this, this.mySchemaPage);
        this.myDataPage.getComponent().putClientProperty(this, this.myDataPage);
        this.myComponent.insertTab(this.mySchemaPage.getTitle(), null, this.mySchemaPage.getComponent(), this.mySchemaPage.getTip(), 0);
        this.myComponent.insertTab(this.myDataPage.getTitle(), null, this.myDataPage.getComponent(), this.myDataPage.getTip(), 1);
        this.myInactivatedPages.add(this.mySchemaPage);
        this.myInactivatedPages.add(this.myDataPage);
        this.myComponent.addChangeListener(this);
        this.myPanel.add((Component)this.myComponent, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        final JLabel status = new JLabel("<html><body><p>Powered by SQLJet v" + SqlJetVersion.getVersionString() + "<br>&copy; 2009-2013, TMate Software, <a href=\"http://sqljet.com/\">http://sqljet.com/</a></p></body></html>");
        status.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        status.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DBBrowserUtil.browse("http://sqljet.com/");
            }

            public void mouseEntered(MouseEvent e) {
                Cursor hand = Cursor.getPredefinedCursor(12);
                status.setCursor(hand);
            }

            public void mouseExited(MouseEvent e) {
                Cursor normal = Cursor.getPredefinedCursor(0);
                status.setCursor(normal);
            }
        });
        bottomPanel.add((Component)status, "West");
        this.myProgress = new JProgressBar();
        this.myProgress.setBorder(BorderFactory.createEmptyBorder(4, 16, 4, 4));
        this.myProgress.setStringPainted(true);
        bottomPanel.add((Component)this.myProgress, "Center");
        this.myPanel.add((Component)bottomPanel, "South");
        this.myProgress.setVisible(false);
        return this.myPanel;
    }

    public void open(File dbFile) {
        this.myDBFile = dbFile;
        if (dbFile == null) {
            this.myOwner.setTitle("SQLJet Database Browser");
        } else {
            this.myOwner.setTitle("SQLJet Database Browser :: " + dbFile.getName());
        }
        this.myInactivatedPages.add(this.mySchemaPage);
        this.myInactivatedPages.add(this.myDataPage);
        this.fireStateChanged();
        this.stateChanged(null);
    }

    public void schedule(final IBrowserRunnable runnable, boolean cancelAll) {
        Iterator<Future<?>> tasks = this.myScheduledTasks.iterator();
        while (tasks.hasNext()) {
            Future<?> task = tasks.next();
            if (task.isDone()) {
                tasks.remove();
                continue;
            }
            if (!cancelAll) continue;
            task.cancel(true);
        }
        this.myScheduledTasks.add(this.myExecutor.submit(new Runnable(){

            public void run() {
                runnable.run(BrowserComponentManager.this);
            }
        }));
    }

    public void stateChanged(ChangeEvent e) {
        IBrowserComponent component = this.getActivePage();
        if (component != null && this.myInactivatedPages.remove(component)) {
            try {
                component.open(this.myDBFile);
            }
            catch (Throwable th) {
                this.open(null);
                this.showErrorDialog(th);
            }
        }
    }

    public void showErrorDialog(Throwable th) {
        th.printStackTrace();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        th.printStackTrace(new PrintStream(bos));
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel("Unexpected error occurred: '" + th.getMessage() + "' with stack trace:", UIManager.getIcon("OptionPane.errorIcon"), 2);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)label, "North");
        final JTextArea text = new JTextArea(new String(bos.toByteArray()));
        text.setEditable(false);
        text.setRows(10);
        text.setColumns(50);
        panel.add((Component)new JScrollPane(text), "Center");
        final JDialog dialog = new JDialog(this.getOwner(), "SQLJet Error", true);
        dialog.setDefaultCloseOperation(2);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton button = new JButton("Close");
        button.setMnemonic('C');
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        JButton copyButton = new JButton("Copy");
        copyButton.setMnemonic('o');
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StringSelection trace = new StringSelection(text.getText());
                Clipboard cp = Toolkit.getDefaultToolkit().getSystemClipboard();
                cp.setContents(trace, trace);
            }
        });
        buttonPanel.add(copyButton);
        buttonPanel.add(button);
        dialog.getRootPane().setDefaultButton(button);
        panel.add((Component)buttonPanel, "South");
        dialog.setContentPane(panel);
        dialog.pack();
        dialog.setLocationRelativeTo(this.getOwner());
        dialog.setVisible(true);
    }

    private IBrowserComponent getActivePage() {
        JComponent activeComponent = (JComponent)this.myComponent.getSelectedComponent();
        if (activeComponent == null) {
            return null;
        }
        return (IBrowserComponent)activeComponent.getClientProperty(this);
    }

    public JFrame getOwner() {
        return this.myOwner;
    }

    public void start(final String name, final int total) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BrowserComponentManager.this.myProgress.setToolTipText(name);
                BrowserComponentManager.this.myProgress.setMinimum(0);
                BrowserComponentManager.this.myProgress.setMaximum(total);
                BrowserComponentManager.this.myProgress.setValue(0);
                BrowserComponentManager.this.myProgress.setVisible(true);
            }
        });
    }

    public void current(final int current) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BrowserComponentManager.this.myProgress.setValue(current);
            }
        });
    }

    public void finish() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BrowserComponentManager.this.myProgress.setVisible(false);
            }
        });
    }
}

