/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.Util;

import com.mhuss.Util.CMac;

public class Str {
    private static final int HEX_DIFF = 7;

    public static int extractInt(String s) {
        int rv = -1;
        if (null != s) {
            int i;
            int j = 0;
            int len = s.length();
            for (i = 0; i < len && !CMac.isdigit(s.charAt(i)); ++i) {
            }
            if (i < len) {
                for (j = i; j < len && CMac.isdigit(s.charAt(j)); ++j) {
                }
                String num = j < len ? s.substring(i, j) : s.substring(i);
                try {
                    rv = Integer.parseInt(num);
                }
                catch (NumberFormatException nfe) {
                    rv = -1;
                }
            }
        }
        return rv;
    }

    public static String deSpace(String s) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (' ' == c || ',' == c || '.' == c || '\'' == c) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String hex(char c) {
        int lsi;
        char lsd = (char)(lsi + ((lsi = (c & 0xF) + 48) > 57 ? 7 : 0));
        int msi = (c >> 4) + 48;
        char msd = (char)(msi + (msi > 57 ? 7 : 0));
        return "%" + msd + lsd;
    }

    public static char unhex(String h) {
        int msi;
        if ('%' != h.charAt(0)) {
            return h.charAt(0);
        }
        int lsi = CMac.toupper(h.charAt(2)) - 48;
        if (lsi > 9) {
            lsi -= 7;
        }
        if ((msi = CMac.toupper(h.charAt(1)) - 48) > 9) {
            msi -= 7;
        }
        return (char)((msi <<= 4) + lsi);
    }

    public static String escape(String in) {
        StringBuffer buf = new StringBuffer();
        block3: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (CMac.isalnum(c)) {
                buf.append(c);
                continue;
            }
            switch (c) {
                case '*': 
                case '-': 
                case '.': 
                case '/': 
                case '@': 
                case '_': {
                    buf.append(c);
                    continue block3;
                }
                default: {
                    buf.append(Str.hex(c));
                }
            }
        }
        return buf.toString();
    }

    public static String unescape(String in) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if ('+' == c) {
                buf.append(' ');
                continue;
            }
            if ('%' == c) {
                buf.append(Str.unhex(in.substring(i, i + 3)));
                i += 2;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static boolean boolCheck(String tf) {
        boolean result = false;
        if (null != tf && tf.length() > 0) {
            char c = tf.charAt(0);
            result = 't' == c || 'T' == c || '1' == c;
        }
        return result;
    }

    public static String fmt(int i, int w) {
        StringBuffer sb = new StringBuffer();
        while (w-- > 0) {
            sb.append((char)(48 + i % 10));
            i /= 10;
        }
        sb.reverse();
        return sb.toString();
    }

    public static String fmt(int i, int w, char suffix) {
        return Str.fmt(i, w) + suffix;
    }

    public static String fmt(int i) {
        return Str.fmt(i, 2);
    }

    public static String fmt(int i, char suffix) {
        return Str.fmt(i, 2) + suffix;
    }

    static void main(String[] args) {
        String PROCNAME = "Str";
        String org = "<This is a #@^*~& test!>";
        String esc = Str.escape(org);
        System.out.println("escape:\n  " + org + " =\n  " + esc);
        System.out.println("\nunescape:\n  " + esc + " =\n  " + Str.unescape(esc));
    }
}

