/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.AstroOps;
import com.mhuss.AstroLib.DarkCalCalc;
import com.mhuss.AstroLib.DarkCalData;
import com.mhuss.AstroLib.DarkCalInput;
import com.mhuss.AstroLib.DarkCalProp;
import com.mhuss.AstroLib.Latitude;
import com.mhuss.AstroLib.Longitude;
import com.mhuss.AstroLib.ObsInfo;
import com.mhuss.AstroLib.PlanetData;
import com.mhuss.AstroLib.TimeOps;
import com.mhuss.AstroLib.TimePair;
import com.mhuss.Util.Str;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;

public class DarkCal {
    static final String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    static final String CFG_EXT = ".cfg";
    static final int DST_NONE = 0;
    static final int DST_START = 1;
    static final int DST_END = 2;
    boolean g_tabDelimited = false;
    boolean g_ignoreDst = false;
    boolean g_html = false;
    boolean g_printable = false;
    PrintWriter g_pw;
    String g_optLink = "&nbsp;";

    DarkCal() {
    }

    public DarkCal(boolean html) {
        this.g_html = html;
    }

    public DarkCal(PrintWriter pw, boolean html) {
        this.g_pw = pw;
        this.g_html = html;
    }

    public DarkCal(PrintWriter pw, boolean html, boolean printable) {
        this.g_pw = pw;
        this.g_html = html;
        this.g_printable = printable;
    }

    void setWriter(PrintWriter pw) {
        this.g_pw = pw;
    }

    public void setOptLink(String s) {
        this.g_optLink = s;
    }

    private void printHeading(DarkCalInput cd) {
        DecimalFormat llfmt = new DecimalFormat("##0.00");
        String pUtc = cd.tz < 0 ? "UTC" : "UTC+";
        String date = monthNames[cd.month - 1] + " " + cd.year;
        String location = "latitude " + llfmt.format(cd.lat) + ", longitude " + llfmt.format(cd.lon) + ", timezone " + pUtc + cd.tz;
        if (this.g_tabDelimited) {
            this.g_pw.println("\n" + date + " " + location + "\n\nDay\tDarkest Hours\tEvent\tMoon Rises\tMoon Sets\tSunset\tAstronomical Twilight Ends\tNext Day\tAstronomical Twilight Starts\tSunrise\n");
        } else if (this.g_html) {
            this.g_pw.println("<HTML>\n<HEAD>\n  <TITLE>Darkest Hours</TITLE>\n</HEAD>\n");
            if (this.g_printable) {
                this.g_pw.println("<BODY BGCOLOR=\"#FFFFE0\">\n<STYLE type=\"text/css\">\n<!--\n  BODY { background:#FFFFE0 }\n  TD.title { font-size:14px; background:#E0E099 }\n  TR.bar { background:#E0E099 }\n");
            } else {
                this.g_pw.println("<BODY TEXT=\"#DDDDDD\" BGCOLOR=\"#002048\">\n<STYLE type=\"text/css\">\n<!--\n  A:link { color:#6699FF; background:transparent }\n  A:visited { color:#CC66CC; background:transparent }\n  BODY { color:#DDDDDD; background:#002048 }\n  TD.title { font-size:14px; background:#003366 }\n  TR.bar { background:#003366 }\n");
            }
            this.g_pw.println("  TH { font-size:12px; text-align:left }\n  TD { font-size:12px }\n  .TinyPrint { font-family:Arial,sans-serif; font-size:8pt }\n  .Hd2 { font-family:Verdana,Arial,sans-serif; font-size:14pt }\n  .Hd3 { font-family:Verdana,Arial,sans-serif; font-size:12pt }\n-->\n</STYLE>\n<SPAN CLASS=\"Hd2\">Darkest Hours</SPAN><BR>\n<TABLE CELLSPACING=0 BORDER=0 WIDTH=\"100%%\">\n<TR><TD WIDTH=\"33%\" CLASS=\"TinyPrint\">" + this.g_optLink + "</TD>\n<TD WIDTH=\"33%\" ALIGN=\"CENTER\"><SPAN CLASS=\"Hd3\">" + date + "</SPAN></TD>\n<TD CLASS=\"TinyPrint\" ALIGN=\"RIGHT\">By <A HREF=\"http://mhuss.com/\">Mark Huss</A></TD></TR>\n</TABLE>\n<TABLE CELLSPACING=0 BORDER=0 WIDTH=\"100%%\">\n<TR><TD  CLASS=\"title\" ALIGN=\"CENTER\" COLSPAN=10>" + location + "</TD></TR>\n<TR>\n  <TH>Day</TH>\n  <TH>Darkest<BR>Hours</TH>\n  <TH>Event</TH>\n  <TH>Moon<BR>Rises</TH>\n  <TH>Moon<BR>Sets</TH>\n  <TH>Sunset</TH>\n  <TH>AstTwi<BR>Ends</TH>\n  <TH>Next<BR>Day</TH>\n  <TH>AstTwi<BR>Starts</TH>\n  <TH>Sunrise</TH>\n</TR>\n");
        } else {
            this.g_pw.println("\n" + date + " " + location + "\n\nDay Darkest                  Moon   Moon   Sunset AstTwi Next AstTwi Sunrise\n    Hours          Events    Rises  Sets          Ends   Day  Starts\n--  -------------  --------  -----  -----  -----  -----  --   -----  -----\n");
        }
    }

    private StringBuffer nextColumn(StringBuffer p, int sp, boolean empty) {
        if (this.g_tabDelimited) {
            p.append('\t');
        } else if (this.g_html) {
            if (empty) {
                p.append("&nbsp;</TD>\n  <TD>");
            } else {
                p.append("</TD>\n  <TD>");
            }
        } else {
            while (sp-- > 0) {
                p.append(' ');
            }
        }
        return p;
    }

    StringBuffer nextColumn(StringBuffer p, int sp) {
        return this.nextColumn(p, sp, false);
    }

    private StringBuffer printTime(StringBuffer p, double t, boolean ws) {
        p.append(TimeOps.formatTime(t));
        return ws ? this.nextColumn(p, 2) : p;
    }

    StringBuffer printTime(StringBuffer p, double t) {
        return this.printTime(p, t, true);
    }

    private StringBuffer printTimes(StringBuffer p, TimePair tp) {
        p = this.printTime(p, tp.a, false);
        p.append(" - ");
        return this.printTime(p, tp.b);
    }

    private StringBuffer printDay(StringBuffer p, long jd, int d, boolean eom) {
        if ((jd + (long)d) % 7L == 6L) {
            p.append("Su");
        } else {
            int nextDay = eom ? 1 : d + 1;
            p.append(Str.fmt(nextDay, 2));
        }
        return this.nextColumn(p, 2);
    }

    StringBuffer printDay(StringBuffer p, long jd, int d) {
        return this.printDay(p, jd, d, false);
    }

    private StringBuffer printDarkness(StringBuffer p, int i, DarkCalData dcd) {
        if (dcd.noDarkness[i]) {
            p.append(" -- none -- ");
            p = this.nextColumn(p, 3);
        } else {
            p = this.printTimes(p, dcd.dark[i]);
        }
        return p;
    }

    private StringBuffer printEvents(StringBuffer p, int i, DarkCalData dcd, int dstDay) {
        String[] strings;
        int quad0;
        int lenLeft = 10;
        PlanetData pd = new PlanetData();
        double[] lunarLon = new double[2];
        double[] solarLon = new double[2];
        ObsInfo loc = new ObsInfo(new Latitude(dcd.dci.lat), new Longitude(dcd.dci.lon), dcd.dci.tz);
        for (int j = 0; j < 2; ++j) {
            double jd = dcd.jd[i] + (double)j;
            solarLon[j] = pd.calcLon(3, jd, loc);
            lunarLon[j] = pd.calcLon(10, jd, loc);
        }
        int quad1 = AstroOps.quadrant(lunarLon[1] - solarLon[1]);
        if (quad1 != (quad0 = AstroOps.quadrant(lunarLon[0] - solarLon[0]))) {
            strings = new String[]{"1Q ", "FM ", "3Q ", "NM "};
            p.append(strings[quad0]);
            lenLeft -= 3;
        }
        if ((quad1 = AstroOps.quadrant(solarLon[1])) != (quad0 = AstroOps.quadrant(solarLon[0]))) {
            strings = new String[]{"SumSol ", "Aut Eq  ", "WinSol ", "Ver Eq "};
            p.append(strings[quad0]);
            lenLeft -= 7;
        }
        if (1 == dstDay) {
            p.append("DSTime");
            lenLeft -= 6;
        } else if (2 == dstDay) {
            p.append("STime");
            lenLeft -= 5;
        }
        if (lenLeft < 0) {
            lenLeft = 0;
        }
        return this.nextColumn(p, lenLeft, 10 == lenLeft);
    }

    public void printData(DarkCalData dcd) {
        DarkCalInput dci = dcd.dci;
        this.printHeading(dci);
        int end = (int)(dcd.jdEnd - dcd.jdStart);
        for (int i = 0; i < end; ++i) {
            if (this.g_html) {
                if (0 == (i & 1)) {
                    this.g_pw.println("<TR CLASS=\"bar\">\n  <TD>");
                } else {
                    this.g_pw.println("<TR>\n  <TD>");
                }
            }
            StringBuffer p = this.printDay(new StringBuffer(), dcd.jdStart, i);
            p = this.printDarkness(p, i, dcd);
            int dstDay = 0;
            if (dcd.dstStart == dcd.jdStart + (long)i) {
                dstDay = 1;
            } else if (dcd.dstEnd == dcd.jdStart + (long)i) {
                dstDay = 2;
            }
            p = this.printEvents(p, i, dcd, dstDay);
            p = this.printTime(p, dcd.moonRS[i].a);
            p = this.printTime(p, dcd.moonRS[i].b);
            p = this.printTime(p, dcd.sunRS[i].b);
            p = this.printTime(p, dcd.astTwi[i].b);
            p = this.printDay(p, dcd.jdStart, i + 1, i == end - 1);
            if (!this.g_tabDelimited && !this.g_html) {
                p.append(' ');
            }
            p = this.printTime(p, dcd.astTwi[i + 1].a);
            p = this.printTime(p, dcd.sunRS[i + 1].a, false);
            if (this.g_html) {
                p.append("</TD>\n</TR>");
            }
            this.g_pw.println(p.toString());
        }
        if (this.g_html) {
            this.printEpilogue();
            this.g_pw.println("</BODY>\n</HTML>\n");
        }
    }

    private void printEpilogue() {
        this.g_pw.println("</TABLE>\n<P>Notes:<BR>This chart is based on the simple concept that most observing occurs between sunset and sunup (solar observing excepted, of course!) The right-hand columns show this normal \"time slice,\" starting at sunset, continuing through twilight, and ending the next day with twilight and then sunrise. Astronomical Twilight is defined as the time when the sun is 18 degrees below the horizon, and is the time when the skies become as dark as local light pollution will allow.</P>\n");
        this.g_pw.println("<P>The important data is in the Darkest Hours column, which shows the times between end of twilight on the first day until start of twilight the next day, <EM>when the Moon is not above the horizon</EM>. These times may run from today to today, today to tomorrow, or tomorrow (starting after midnight) to tomorrow - the hours should make it obvious which is which.</P>\n");
        this.g_pw.println("<P>These simple calculations should be taken with a grain of salt; for example, a two-day-old moon is not much of a \"darkness spoiler,\" and some observing can be done before the end of astronomical twilight. All data were calculated by a java program I wrote (based on a C++ class library I wrote), which was in turn based on open source astronomical software from <A HREF=\"http://www.projectpluto.com/\">Project Pluto</A>. Additional calculations came from Jean Meeus' book <A HREF=\"http://www.willbell.com/math/mc1.htm\">Astronomical Algorithms</A>.</P>\n");
    }

    public void calcAndPrint(DarkCalInput dci) {
        DarkCalCalc dcc = new DarkCalCalc(dci, this.g_ignoreDst);
        this.printData(dcc.dcd);
    }

    public void print(DarkCalInput dci) {
        try {
            DarkCalCalc dcc = new DarkCalCalc(dci, this.g_ignoreDst);
            try {
                this.printData(dcc.dcd);
            }
            catch (Exception e) {
                System.err.println("Error printing data object: " + e);
            }
        }
        catch (Exception e) {
            System.err.println("Error creating data object: " + e);
        }
    }

    private static void usage(String pn) {
        System.err.println("usage: " + pn + " <month> <year> [-d] [-h] [-t] [-u]\n       -d = ignore daylight savings time\n       -h = HTML table output\n       -t = tab-delimited output\n       -u = output time in UTC\n\nNotes:\n - Command-line options override config file settings.\n - To produce a sample config file with all options listed, run the\n   program without a " + pn + ".cfg file in the current directory.\n - This program currently only supports the Gregorian calendar.");
        System.exit(-1);
    }

    public static void main(String[] args) {
        String PROCNAME = "DarkCal";
        if (args.length < 2) {
            DarkCal.usage("DarkCal");
        } else if ('-' == args[0].charAt(0)) {
            DarkCal.usage("DarkCal");
        }
        DarkCalInput dci = new DarkCalInput();
        DarkCal dc = new DarkCal();
        if (!DarkCalProp.load(dci, dc)) {
            System.err.println("Error: Unable to load DarkCal config file.");
            System.exit(1);
        }
        dci.month = Integer.parseInt(args[0]);
        dci.year = Integer.parseInt(args[1]);
        if (dci.month < 1 || dci.month > 12 || dci.year <= 0) {
            DarkCal.usage("DarkCal");
        }
        if (args.length > 2) {
            for (int i = 2; i < args.length; ++i) {
                if ('-' != args[i].charAt(0)) {
                    DarkCal.usage("DarkCal");
                    continue;
                }
                char c = args[i].charAt(1);
                if ('d' == c) {
                    dc.g_ignoreDst = true;
                    continue;
                }
                if ('h' == c) {
                    dc.g_html = true;
                    continue;
                }
                if ('t' == c) {
                    dc.g_tabDelimited = true;
                    continue;
                }
                if ('u' == c) {
                    dci.tz = 0;
                    dc.g_ignoreDst = true;
                    continue;
                }
                DarkCal.usage("DarkCal");
            }
        }
        if (dc.g_tabDelimited && dc.g_html) {
            System.err.println("Error: html and tabDelimited cannot both be specified.\n");
            System.exit(-1);
        }
        if (0.0 == dci.lon && 0.0 == dci.lat) {
            System.out.println("Latitude & Longitude are both set to 0. Is this what you intended?\n");
        }
        String pExt = null;
        if (dc.g_html) {
            pExt = ".html";
        } else if (dc.g_tabDelimited) {
            pExt = ".txt";
        }
        if (null != pExt) {
            String filename = monthNames[dci.month - 1] + dci.year + pExt;
            File f = new File(filename);
            try {
                f.createNewFile();
                dc.setWriter(new PrintWriter(new FileOutputStream(f)));
            }
            catch (IOException ioe) {
                System.err.println("Error: Unable to create output file '" + filename + "': " + ioe);
                System.exit(1);
            }
            System.err.println("Writing output to " + filename + "\n");
        } else {
            dc.setWriter(new PrintWriter(System.out));
        }
        dc.print(dci);
        dc.g_pw.close();
    }
}

