/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.mrpe.MRpCommandList;
import org.lsmp.djep.mrpe.MRpEval;
import org.lsmp.djep.mrpe.MRpRes;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.Complex;

public class MRpTest
extends TestCase {
    MatrixJep mj;
    public static final boolean SHOW_BAD = false;
    String[][] matStrs = new String[10][10];
    String[] vecStrs = new String[10];
    boolean TESTALL = false;

    public MRpTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(MRpTest.class);
    }

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(MRpTest.class);
        suite.run(new TestResult());
    }

    protected void setUp() {
        int i;
        this.mj = new MatrixJep();
        this.mj.addStandardConstants();
        this.mj.addStandardFunctions();
        this.mj.addComplex();
        this.mj.setAllowAssignment(true);
        this.mj.setAllowUndeclared(true);
        this.mj.setImplicitMul(true);
        this.mj.addStandardDiffRules();
        for (i = 2; i <= 9; ++i) {
            for (int j = 2; j <= 9; ++j) {
                int num = 1;
                StringBuffer sb = new StringBuffer("[");
                for (int k = 0; k < i; ++k) {
                    if (k > 0) {
                        sb.append(",");
                    }
                    sb.append("[");
                    for (int l = 0; l < j; ++l) {
                        if (l > 0) {
                            sb.append(",");
                        }
                        sb.append(String.valueOf(num++));
                    }
                    sb.append("]");
                }
                sb.append("]");
                this.matStrs[i][j] = sb.toString();
            }
        }
        for (i = 2; i <= 9; ++i) {
            int num = 1;
            StringBuffer sb = new StringBuffer("[");
            for (int k = 0; k < i; ++k) {
                if (k > 0) {
                    sb.append(",");
                }
                sb.append(String.valueOf(num++));
            }
            sb.append("]");
            this.vecStrs[i] = sb.toString();
        }
    }

    public void testGood() {
        MRpTest.assertEquals((int)1, (int)1);
    }

    public void myAssertEquals(String msg, String actual, String expected) {
        if (!actual.equals(expected)) {
            System.out.println("Error \"" + msg + "\" is \n<" + actual + "> should be \n<" + expected + ">");
        }
        MRpTest.assertEquals((String)("<" + msg + ">"), (Object)expected, (Object)actual);
        System.out.println("Success: Value of <" + msg + "> is <" + actual + ">");
    }

    public void valueTest(String expr, double dub) throws ParseException {
        this.valueTest(expr, new Double(dub));
    }

    public void valueTest(String expr, Object expected) throws ParseException {
        Node node = this.mj.parse(expr);
        Node matEqn = this.mj.preprocess(node);
        Object res = this.mj.evaluate(matEqn);
        if (this.mj.hasError()) {
            MRpTest.fail((String)("Evaluation Failure: " + expr + this.mj.getErrorInfo()));
        }
        MRpTest.assertEquals((String)("<" + expr + ">"), (Object)expected, (Object)res);
        System.out.println("Sucess value of <" + expr + "> is " + res);
    }

    public void valueTest(String expr, String expected) throws ParseException {
        Node node = this.mj.parse(expr);
        Node matEqn = this.mj.preprocess(node);
        Object res = this.mj.evaluate(matEqn);
        if (this.mj.hasError()) {
            MRpTest.fail((String)("Evaluation Failure: " + expr + this.mj.getErrorInfo()));
        }
        MRpTest.assertEquals((String)("<" + expr + ">"), (Object)expected, (Object)res.toString());
        System.out.println("Sucess value of <" + expr + "> is " + res.toString());
    }

    public void complexValueTest(String expr, Complex expected, double tol) throws Exception {
        Node node = this.mj.preprocess(this.mj.parse(expr));
        Object res = this.mj.evaluate(node);
        MRpTest.assertTrue((String)("<" + expr + "> expected: <" + expected + "> but was <" + res + ">"), (boolean)expected.equals((Complex)res, tol));
        System.out.println("Sucess value of <" + expr + "> is " + res);
    }

    public Object calcValue(String expr) throws ParseException {
        Node node = this.mj.parse(expr);
        Node matEqn = this.mj.preprocess(node);
        Object res = this.mj.evaluate(matEqn);
        return res;
    }

    public void simplifyTest(String expr, String expected) throws ParseException {
        Node node = this.mj.parse(expr);
        Node matEqn = this.mj.preprocess(node);
        Node simp = this.mj.simplify(matEqn);
        String res = this.mj.toString(simp);
        Node node2 = this.mj.parse(expected);
        Node matEqn2 = this.mj.preprocess(node2);
        Node simp2 = this.mj.simplify(matEqn2);
        String res2 = this.mj.toString(simp2);
        if (!res2.equals(res)) {
            System.out.println("Error: Value of \"" + expr + "\" is \"" + res + "\" should be \"" + res2 + "\"");
        }
        MRpTest.assertEquals((String)("<" + expr + ">"), (Object)res2, (Object)res);
        System.out.println("Sucess: Value of \"" + expr + "\" is \"" + res + "\"");
    }

    public void simplifyTestString(String expr, String expected) throws ParseException {
        Node node = this.mj.parse(expr);
        Node matEqn = this.mj.preprocess(node);
        String res = this.mj.toString(matEqn);
        if (!expected.equals(res)) {
            System.out.println("Error: Value of \"" + expr + "\" is \"" + res + "\" should be \"" + expected + "\"");
        }
        MRpTest.assertEquals((String)("<" + expr + ">"), (Object)expected, (Object)res);
        System.out.println("Sucess: Value of \"" + expr + "\" is \"" + res + "\"");
    }

    void rpTest(String[] eqns, String eqn2) throws ParseException {
        for (int i = 0; i < eqns.length; ++i) {
            System.out.println("eqns " + eqns[i]);
            Node node = this.mj.simplify(this.mj.preprocess(this.mj.parse(eqns[i])));
            this.mj.evaluate(node);
        }
        Node node3 = this.mj.simplify(this.mj.preprocess(this.mj.parse(eqn2)));
        MRpEval rpe = new MRpEval(this.mj);
        MRpCommandList list = rpe.compile(node3);
        MRpRes rpRes = rpe.evaluate(list);
        MatrixValueI mat = rpRes.toVecMat();
        Object matRes = this.mj.evaluateRaw(node3);
        if (this.mj.hasError()) {
            MRpTest.fail((String)("Evaluation Failure: " + eqn2 + this.mj.getErrorInfo()));
        }
        this.myAssertEquals("<" + eqn2 + ">", rpRes.toString(), matRes.toString());
        if (!mat.equals(matRes)) {
            MRpTest.fail((String)("Expected <" + matRes + "> found <" + mat + ">"));
        }
        if (rpRes.getDims().is1D()) {
            double[] vecArray = (double[])rpRes.toArray();
            for (int i = 0; i < vecArray.length; ++i) {
                if (vecArray[i] == (Double)((MVector)matRes).getEle(i)) continue;
                MRpTest.fail((String)"Problem with toArray");
            }
        } else if (rpRes.getDims().is2D()) {
            double[][] matArray = (double[][])rpRes.toArray();
            for (int i = 0; i < matArray.length; ++i) {
                for (int j = 0; j < matArray[i].length; ++j) {
                    if (matArray[i][j] == (Double)((Matrix)matRes).getEle(i, j)) continue;
                    MRpTest.fail((String)"Problem with toArray");
                }
            }
        }
        rpe.cleanUp();
    }

    void rpTest2(String[] eqns) throws ParseException {
        int i;
        Node[] nodes = new Node[eqns.length];
        MatrixValueI[] rpMats = new MatrixValueI[eqns.length];
        MRpEval rpe = new MRpEval(this.mj);
        for (i = 0; i < eqns.length; ++i) {
            System.out.println("eqns " + eqns[i]);
            nodes[i] = this.mj.simplify(this.mj.preprocess(this.mj.parse(eqns[i])));
            MRpCommandList list = rpe.compile(nodes[i]);
            MRpRes rpRes = rpe.evaluate(list);
            rpMats[i] = rpRes.toVecMat();
            System.out.println("<" + eqns[i] + "> " + rpRes.toString());
        }
        for (i = 0; i < eqns.length; ++i) {
            Object matRes = this.mj.evaluateRaw(nodes[i]);
            if (rpMats[i].equals(matRes)) continue;
            MRpTest.fail((String)("Expected <" + matRes + "> found <" + rpMats[i] + ">"));
        }
        rpe.cleanUp();
    }

    public void testRp() throws ParseException {
        this.rpTest(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y*y");
        this.rpTest(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y+y");
        this.rpTest(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y-y");
        this.rpTest(new String[]{"y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y*y+y");
        this.rpTest(new String[]{"x=[1,2,3]", "y=[[1,2,3],[4,5,6],[7,8,9]]"}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3]", "y=[[1,2,3],[4,5,6],[7,8,9]]"}, "y*x");
        this.rpTest(new String[0], "[[1,2,3],[4,5,6],[7,8,9]]*[[1,2,3],[4,5,6],[7,8,9]]");
        this.rpTest(new String[]{"y=[1,2]"}, "y+y");
        this.rpTest(new String[]{"y=[1,2,3]"}, "y+y");
        this.rpTest(new String[]{"y=[1,2,3,4]"}, "y+y");
        this.rpTest(new String[]{"y=[1,2]"}, "-y");
        this.rpTest(new String[]{"y=[1,2,3]"}, "-y");
        this.rpTest(new String[]{"y=[1,2,3,4]"}, "-y");
        this.rpTest(new String[]{"y=[1,2]"}, "y-y");
        this.rpTest(new String[]{"y=[1,2,3]"}, "y-y");
        this.rpTest(new String[]{"y=[1,2,3,4]"}, "y-y");
        this.rpTest(new String[]{"y=[1,2]"}, "y*3");
        this.rpTest(new String[]{"y=[1,2,3]"}, "y*3");
        this.rpTest(new String[]{"y=[1,2,3,4]"}, "y*3");
        this.rpTest(new String[]{"y=[1,2]"}, "5*y");
        this.rpTest(new String[]{"y=[1,2,3]"}, "5*y");
        this.rpTest(new String[]{"y=[1,2,3,4]"}, "5*y");
        this.rpTest(new String[]{"y=[1,2,3]"}, "y . y");
        this.rpTest(new String[]{"y=[1,2,3]"}, "y^^y");
        this.rpTest(new String[]{"y=[[1,2],[3,4]]"}, "y*y");
        this.rpTest(new String[]{"y=[[1,2],[3,4]]"}, "y+y");
        this.rpTest(new String[]{"y=[[1,2],[3,4]]"}, "y-y");
        this.rpTest(new String[]{"y=[[1,2],[3,4]]"}, "y*y+y");
        this.rpTest(new String[]{"x=[1,2]", "y=[[1,2],[3,4]]"}, "x*y");
        this.rpTest(new String[]{"x=[1,2]", "y=[[1,2],[3,4]]"}, "y*x");
        this.rpTest(new String[0], "1*2*3+4*5*6+7*8*9");
        this.rpTest(new String[]{"x1=1", "x2=2", "x3=3", "x4=4", "x5=5", "x6=6", "x7=7", "x8=8", "x9=9"}, "x1*x2*x3+x4*x5*x6+x7*x8*x9");
    }

    public void testRpAllDim() throws ParseException {
        for (int i = 2; i <= 4; ++i) {
            for (int j = 2; j <= 4; ++j) {
                int num = 1;
                StringBuffer sb = new StringBuffer("x=[");
                for (int k = 0; k < i; ++k) {
                    if (k > 0) {
                        sb.append(",");
                    }
                    sb.append("[");
                    for (int l = 0; l < j; ++l) {
                        if (l > 0) {
                            sb.append(",");
                        }
                        sb.append(String.valueOf(num++));
                    }
                    sb.append("]");
                }
                sb.append("]");
                String varStr = sb.toString();
                this.rpTest(new String[]{varStr}, "x+x");
                this.rpTest(new String[]{varStr}, "x-x");
                this.rpTest(new String[]{varStr}, "3*x");
                this.rpTest(new String[]{varStr}, "x*5");
                this.rpTest(new String[]{varStr}, "-x");
            }
        }
    }

    public void testMul() throws ParseException {
        this.rpTest(new String[]{"x=[1,2]", "y=" + this.matStrs[2][2]}, "x*y");
        this.rpTest(new String[]{"x=[1,2]", "y=" + this.matStrs[2][3]}, "x*y");
        this.rpTest(new String[]{"x=[1,2]", "y=" + this.matStrs[2][4]}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3]", "y=" + this.matStrs[3][2]}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3]", "y=" + this.matStrs[3][3]}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3]", "y=" + this.matStrs[3][4]}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3,4]", "y=" + this.matStrs[4][2]}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3,4]", "y=" + this.matStrs[4][3]}, "x*y");
        this.rpTest(new String[]{"x=[1,2,3,4]", "y=" + this.matStrs[4][4]}, "x*y");
        this.rpTest(new String[]{"x=[1,2]", "y=" + this.matStrs[2][2]}, "y*x");
        this.rpTest(new String[]{"x=[1,2]", "y=" + this.matStrs[3][2]}, "y*x");
        this.rpTest(new String[]{"x=[1,2]", "y=" + this.matStrs[4][2]}, "y*x");
        this.rpTest(new String[]{"x=[1,2,3]", "y=" + this.matStrs[2][3]}, "y*x");
        this.rpTest(new String[]{"x=[1,2,3]", "y=" + this.matStrs[3][3]}, "y*x");
        this.rpTest(new String[]{"x=[1,2,3]", "y=" + this.matStrs[4][3]}, "y*x");
        this.rpTest(new String[]{"x=[1,2,3,4]", "y=" + this.matStrs[2][4]}, "y*x");
        this.rpTest(new String[]{"x=[1,2,3,4]", "y=" + this.matStrs[3][4]}, "y*x");
        this.rpTest(new String[]{"x=[1,2,3,4]", "y=" + this.matStrs[4][4]}, "y*x");
        this.rpTest(new String[]{"x=" + this.matStrs[2][2], "y=" + this.matStrs[2][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][2], "y=" + this.matStrs[2][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][2], "y=" + this.matStrs[2][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][3], "y=" + this.matStrs[3][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][3], "y=" + this.matStrs[3][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][3], "y=" + this.matStrs[3][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][4], "y=" + this.matStrs[4][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][4], "y=" + this.matStrs[4][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[2][4], "y=" + this.matStrs[4][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][2], "y=" + this.matStrs[2][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][2], "y=" + this.matStrs[2][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][2], "y=" + this.matStrs[2][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][3], "y=" + this.matStrs[3][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][3], "y=" + this.matStrs[3][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][3], "y=" + this.matStrs[3][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][4], "y=" + this.matStrs[4][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][4], "y=" + this.matStrs[4][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[3][4], "y=" + this.matStrs[4][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][2], "y=" + this.matStrs[2][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][2], "y=" + this.matStrs[2][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][2], "y=" + this.matStrs[2][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][3], "y=" + this.matStrs[3][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][3], "y=" + this.matStrs[3][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][3], "y=" + this.matStrs[3][4]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][4], "y=" + this.matStrs[4][2]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][4], "y=" + this.matStrs[4][3]}, "x*y");
        this.rpTest(new String[]{"x=" + this.matStrs[4][4], "y=" + this.matStrs[4][4]}, "x*y");
    }

    public void testAssign() throws ParseException {
        this.rpTest2(new String[]{"x=[[5,6],[7,8]]", "x+x"});
        this.rpTest2(new String[]{"x=[5,6]", "x+x"});
        this.rpTest2(new String[]{"x=[5,6,7]", "x+x"});
        this.rpTest2(new String[]{"x=[5,6,7,8]", "x+x"});
        this.rpTest2(new String[]{"x=5", "x+x"});
        for (int i = 2; i <= 4; ++i) {
            for (int j = 2; j <= 4; ++j) {
                this.rpTest2(new String[]{"x=" + this.matStrs[i][j], "x+x"});
            }
        }
    }

    public void testLogical() throws ParseException {
        this.rpTest2(new String[]{"1&&1", "1&&0", "0&&0", "0&&1", "3.14&&1"});
        this.rpTest2(new String[]{"1||1", "1||0", "0||0", "0||1", "3.14||0"});
        this.rpTest2(new String[]{"!0", "!1", "!3.14", "!-3.14"});
        this.rpTest2(new String[]{"1>1", "1>0", "0>0", "0>1", "3.14>1"});
        this.rpTest2(new String[]{"1<1", "1<0", "0<0", "0<1", "3.14<1"});
        this.rpTest2(new String[]{"1>=1", "1>=0", "0>=0", "0>=1", "3.14>=1"});
        this.rpTest2(new String[]{"1<=1", "1<=0", "0<=0", "0<=1", "3.14<=1"});
        this.rpTest2(new String[]{"1==1", "1==0", "0==0", "0==1", "3.14==1"});
        this.rpTest2(new String[]{"1!=1", "1!=0", "0!=0", "0!=1", "3.14!=1"});
        this.rpTest2(new String[]{"[1,2]==[1,2]"});
        this.rpTest2(new String[]{"[1,2]!=[1,2]"});
        this.rpTest2(new String[]{"[1,2]==[5,6]"});
        this.rpTest2(new String[]{"[1,2]!=[5,6]"});
        this.rpTest2(new String[]{"[1,2,3]==[1,2,3]"});
        this.rpTest2(new String[]{"[1,2,3]!=[1,2,3]"});
        this.rpTest2(new String[]{"[1,2,3]==[5,6,7]"});
        this.rpTest2(new String[]{"[1,2,3]!=[5,6,7]"});
        this.rpTest2(new String[]{"[1,2,3]==[1,2,4]"});
        this.rpTest2(new String[]{"[1,2,3]!=[1,2,4]"});
        this.rpTest2(new String[]{"[1,2,3,4]==[1,2,3,4]"});
        this.rpTest2(new String[]{"[1,2,3,4]!=[1,2,3,4]"});
        this.rpTest2(new String[]{"[1,2,3,4]==[5,6,7,8]"});
        this.rpTest2(new String[]{"[1,2,3,4]!=[5,6,7,8]"});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "==" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
        this.rpTest2(new String[]{this.matStrs[2][2] + "!=" + this.matStrs[2][2]});
    }

    public void testVn() throws ParseException {
        this.rpTest2(new String[]{"x=[5,6,7,8,9]", "x+x", "x-x", "2*x", "x*3", "x.x"});
        this.rpTest2(new String[]{"x=[[1,2,3,4,5],[5,6,7,8,9]]", "x+x", "x-x", "2*x", "x*3"});
        this.rpTest2(new String[]{"x=[[1,2],[3,4]]", "y=[[1,2,3,4,5],[5,6,7,8,9]]", "x*y"});
        this.rpTest2(new String[]{"x=[[1,2],[3,4]]", "y=[[1,2],[3,4],[5,6],[7,8],[9,10]]", "y*x"});
        this.rpTest2(new String[]{"x=[[1,2,3,4,5],[5,6,7,8,9]]", "y=[[1,2],[3,4],[5,6],[7,8],[9,10]]", "y*x"});
        if (this.TESTALL) {
            int j;
            int i;
            for (i = 2; i < 10; ++i) {
                for (j = 2; j < 10; ++j) {
                    for (int k = 2; k < 10; ++k) {
                        System.out.println("\n[" + i + "," + j + "]*[" + j + "," + k + "]");
                        this.rpTest2(new String[]{"x=" + this.matStrs[i][j], "y=" + this.matStrs[j][k], "x*y"});
                    }
                }
            }
            for (i = 2; i < 10; ++i) {
                for (j = 2; j < 10; ++j) {
                    System.out.println("\n[" + i + "," + j + "]*[" + j + "]");
                    this.rpTest2(new String[]{"x=" + this.matStrs[i][j], "y=" + this.vecStrs[j], "x*y"});
                }
            }
            for (int j2 = 2; j2 < 10; ++j2) {
                for (int k = 2; k < 10; ++k) {
                    System.out.println("\n[" + j2 + "]*[" + j2 + "," + k + "]");
                    this.rpTest2(new String[]{"x=" + this.vecStrs[j2], "y=" + this.matStrs[j2][k], "x*y"});
                }
            }
        }
    }

    public void testFun() throws ParseException {
        this.rpTest2(new String[]{"x=5", "y=4", "x/y", "x%y", "x^y"});
        this.rpTest2(new String[]{"x=0.5", "cos(x)", "sin(x)", "tan(x)", "asin(x)", "acos(x)", "atan(x)"});
        this.rpTest2(new String[]{"x=0.5", "cosh(x)", "sinh(x)", "tanh(x)", "asinh(x)", "acosh(x+1)", "atanh(x)"});
        this.rpTest2(new String[]{"x=0.5", "sqrt(x)", "ln(x)", "log(x)", "exp(x)", "abs(x)"});
        this.rpTest2(new String[]{"x=0.5", "sec(x)", "cosec(x)", "cot(x)"});
    }

    public void testUndecVar() throws ParseException {
        this.mj.setAllowUndeclared(true);
        MRpEval rpe = new MRpEval(this.mj);
        Node node1 = this.mj.parse("zap * gosh");
        Node node3 = this.mj.preprocess(node1);
        rpe.compile(node3);
    }

    public void testAssignDiff() throws ParseException {
    }
}

