/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import java.math.BigInteger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.groupJep.GroupJep;
import org.lsmp.djep.groupJep.PolynomialVisitor;
import org.lsmp.djep.groupJep.groups.AlgebraicExtension;
import org.lsmp.djep.groupJep.groups.ExtendedFreeGroup;
import org.lsmp.djep.groupJep.groups.FreeGroup;
import org.lsmp.djep.groupJep.groups.Integers;
import org.lsmp.djep.groupJep.groups.Quaternions;
import org.lsmp.djep.groupJep.groups.Rationals;
import org.lsmp.djep.groupJep.groups.Reals;
import org.lsmp.djep.groupJep.groups.Zn;
import org.lsmp.djep.groupJep.interfaces.RingI;
import org.lsmp.djep.groupJep.values.FreeGroupElement;
import org.lsmp.djep.groupJep.values.HasComplexValueI;
import org.lsmp.djep.groupJep.values.Polynomial;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.Complex;

public class GroupJepTest
extends TestCase {
    GroupJep j;
    public static final boolean SHOW_BAD = false;

    public GroupJepTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(GroupJepTest.class);
        suite.run(new TestResult());
    }

    protected void setUp() {
    }

    public static Test suite() {
        return new TestSuite(GroupJepTest.class);
    }

    public void myAssertEquals(String msg, String expected, String actual) {
        if (!actual.equals(expected)) {
            System.out.println("Error \"" + msg + "\" is \"" + actual + " should be " + expected + "\"");
        }
        GroupJepTest.assertEquals((String)("<" + msg + ">"), (Object)expected, (Object)actual);
        System.out.println("Success: Value of \"" + msg + "\" is \"" + actual + "\"");
    }

    public void myAssertEquals(String msg, String expected, String actual, String ending) {
        if (!actual.equals(expected)) {
            System.out.println("Error \"" + msg + "\" is \"" + actual + " should be " + expected + "\"");
        }
        GroupJepTest.assertEquals((String)("<" + msg + ">"), (Object)expected, (Object)actual);
        System.out.println("Success: Value of \"" + msg + "\" is \"" + actual + "\": " + ending);
    }

    public void testGood() {
        GroupJepTest.assertEquals((int)1, (int)1);
    }

    public void valueToStringTest(String expr, String expected) throws Exception {
        Node node = this.j.parse(expr);
        Object val = this.j.evaluate(node);
        String res = val.toString();
        String ending = "";
        if (val instanceof HasComplexValueI) {
            Complex cval = ((HasComplexValueI)val).getComplexValue();
            ending = cval.toString();
        }
        this.myAssertEquals(expr, expected, res, ending);
    }

    public void testZ() throws Exception {
        this.j = new GroupJep(new Integers());
        this.valueToStringTest("1*2*3*4*5*6*7*8*9*10*11*12*13*14*15*16*17*18*19*20", "2432902008176640000");
    }

    public void testQ() throws Exception {
        this.j = new GroupJep(new Rationals());
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("(1/2)-(1/3)", "1/6");
    }

    public void testQuartonians() throws Exception {
        this.j = new GroupJep(new Quaternions());
        this.j.addStandardConstants();
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("i*j", "-k");
    }

    public void testZn() throws Exception {
        this.j = new GroupJep(new Zn(BigInteger.valueOf(5L)));
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("2*3", "1");
        this.valueToStringTest("2*4", "3");
        this.valueToStringTest("3*3", "4");
        this.valueToStringTest("3*4", "2");
        this.valueToStringTest("4*4", "1");
        this.valueToStringTest("2/3", "4");
        this.valueToStringTest("2/4", "3");
        this.valueToStringTest("3/2", "4");
        this.valueToStringTest("3/4", "2");
        this.valueToStringTest("4/2", "2");
        this.valueToStringTest("4/3", "3");
    }

    public void testZroot2() throws Exception {
        Integers ring = new Integers();
        Number[] coeffs = new Number[]{BigInteger.valueOf(-2L), BigInteger.ZERO, BigInteger.ONE};
        Polynomial p1 = new Polynomial(ring, "rt2", coeffs);
        this.j = new GroupJep(new AlgebraicExtension((RingI)ring, p1));
        this.j.addStandardConstants();
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("rt2*rt2", "2");
        this.valueToStringTest("(rt2+1)*(rt2+1)", "2 rt2+3");
    }

    public void testZ5thRootUnity() throws Exception {
        Integers ring = new Integers();
        Number[] coeffs = new Number[]{BigInteger.valueOf(-1L), BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ONE};
        Polynomial p1 = new Polynomial(ring, "t", coeffs);
        this.j = new GroupJep(new AlgebraicExtension((RingI)ring, p1));
        this.j.addStandardConstants();
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("t*t", "t^2");
        this.valueToStringTest("t*t*t", "t^3");
        this.valueToStringTest("t*t*t*t", "t^4");
        this.valueToStringTest("t*t*t*t*t", "1");
    }

    public void testZRoot2Root5() throws Exception {
        Integers ring = new Integers();
        Number[] coeffs1 = new Number[]{BigInteger.valueOf(-2L), BigInteger.ZERO, BigInteger.ONE};
        Polynomial p1 = new Polynomial(ring, "t", coeffs1);
        AlgebraicExtension an1 = new AlgebraicExtension((RingI)ring, p1);
        Number[] coeffs2 = new Number[]{an1.valueOf("-5"), an1.valueOf("0"), an1.valueOf("1")};
        Polynomial p2 = new Polynomial(an1, "s", coeffs2);
        AlgebraicExtension an2 = new AlgebraicExtension((RingI)an1, p2);
        this.j = new GroupJep(an2);
        this.j.addStandardConstants();
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("t", "t");
        this.valueToStringTest("s", "s");
        this.valueToStringTest("t*t", "2");
        this.valueToStringTest("s*s", "5");
        this.valueToStringTest("s*t", "t s");
        this.valueToStringTest("s+t", "s+t");
        this.valueToStringTest("(t-1)*(s-1)", "(t-1) s-t+1");
    }

    public void testZtau() throws Exception {
        Integers ring = new Integers();
        Number[] coeffs = new Number[]{BigInteger.valueOf(-1L), BigInteger.valueOf(-1L), BigInteger.ONE};
        Polynomial p1 = new Polynomial(ring, "t", coeffs);
        AlgebraicExtension an = new AlgebraicExtension((RingI)ring, p1);
        this.j = new GroupJep(an);
        this.j.addStandardConstants();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        System.out.println(this.j.getGroup().toString());
        this.valueToStringTest("t*t", "t+1");
        this.valueToStringTest("t*t*t", "2 t+1");
        this.valueToStringTest("t*t*t*t", "3 t+2");
        this.valueToStringTest("t*t*t*t*t", "5 t+3");
        this.valueToStringTest("t*t*t*t*t*t", "8 t+5");
        this.valueToStringTest("x=2*t-1", "2 t-1");
        this.valueToStringTest("x*x", "5");
        this.valueToStringTest("-t", "-t");
        this.valueToStringTest("1-t", "-t+1");
        this.valueToStringTest("t*(1-t)", "-1");
    }

    public void testPolynomials() throws Exception {
        Reals ring = new Reals();
        ExtendedFreeGroup fg = new ExtendedFreeGroup(ring, "x");
        this.j = new GroupJep(fg);
        this.j.addStandardConstants();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        Node n = this.j.parse("(x+7.6)*(x+5.8832)*(x-55.12)");
        FreeGroupElement fge = (FreeGroupElement)this.j.evaluate(n);
        Number[] coeffs = fge.getCoeffs();
        for (int i = 0; i < coeffs.length; ++i) {
            System.out.println("Coeffs [" + i + "] " + coeffs[i]);
        }
        Complex val = fge.calculateComplexValue(new Complex(1.0));
        System.out.println("Value " + val);
        System.out.println(fge.toString());
        this.myAssertEquals("(x+7.6)*(x+5.8832)*(x-55.12): x=1.0", "(-3203.6615424, 0.0)", val.toString());
        System.out.println("rounding error 7.6+5.8832-55.12 = -41.636799999999994");
        ExtendedFreeGroup fg2 = new ExtendedFreeGroup(fg, "y");
        this.j = new GroupJep(fg2);
        this.j.addStandardConstants();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        Node n2 = this.j.parse("(x+1)*(y-2)");
        FreeGroupElement fge2 = (FreeGroupElement)this.j.evaluate(n2);
        Number[] co1 = fge2.getCoeffs();
        for (int i = 0; i < co1.length; ++i) {
            FreeGroupElement fge3 = (FreeGroupElement)co1[i];
            Number[] co2 = fge3.getCoeffs();
            for (int jj = 0; jj < co2.length; ++jj) {
                System.out.print(co2[jj] + "\t");
            }
            System.out.println();
        }
        fg.setRootVal(new Complex(5.0));
        fg2.setRootVal(new Complex(4.0));
        System.out.println(fge2.toString());
        this.myAssertEquals("(x+1)*(y-2): x=5,y=4", "(12.0, 0.0)", fge2.getComplexValue().toString());
        this.valueToStringTest("a=5", "5.0");
        this.valueToStringTest("z=x+y-1", "y+x-1.0");
        this.valueToStringTest("z^a", "y^5+(5.0 x-5.0) y^4+(10.0 x^2-20.0 x+10.0) y^3+(10.0 x^3-30.0 x^2+30.0 x-10.0) y^2+(5.0 x^4-20.0 x^3+30.0 x^2-20.0 x+5.0) y+x^5-5.0 x^4+10.0 x^3-10.0 x^2+5.0 x-1.0");
    }

    public void testPolynomials2() throws Exception {
        Reals ring = new Reals();
        ExtendedFreeGroup fg = new ExtendedFreeGroup(ring, "x");
        ExtendedFreeGroup fg2 = new ExtendedFreeGroup(fg, "y");
        this.j = new GroupJep(fg2);
        this.j.addStandardConstants();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
        String expr1 = "(3*2) x+34+23+3*2 y+4 x";
        Node node1 = this.j.parse(expr1);
        Object val1 = this.j.evaluate(node1);
        String res1 = val1.toString();
        System.out.println(expr1 + " -> " + res1);
        String expr2 = "6x+3y+4x+3(15x+7y)+40";
        Node node2 = this.j.parse(expr2);
        Object val2 = this.j.evaluate(node2);
        String res2 = val2.toString();
        System.out.println(expr2 + " -> " + res2);
    }

    public void testPolynomialCreator() throws Exception {
        Reals ring = new Reals();
        FreeGroup fg = new FreeGroup(ring, "x");
        JEP j2 = new JEP();
        j2.addStandardConstants();
        j2.addStandardFunctions();
        j2.setAllowUndeclared(true);
        Node n = j2.parse("(x+7.6)*(x+5.8832)*(x-55.12)");
        PolynomialVisitor pv = new PolynomialVisitor(j2);
        Polynomial poly = pv.calcPolynomial(n, fg);
        Number[] coeffs = poly.getCoeffs();
        for (int i = 0; i < coeffs.length; ++i) {
            System.out.println("Coeffs [" + i + "] " + coeffs[i]);
        }
    }

    public void testBad() throws ParseException {
    }
}

