/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential.nonparametrics;

import java.util.Vector;
import org.statcato.statistics.inferential.nonparametrics.WilcoxonSignedRankPValue;
import org.statcato.utils.DataValue;
import org.statcato.utils.HelperFunctions;
import org.statcato.utils.OrderingFunctions;

public class WilcoxonSignedRankTest {
    private int sampleSize;
    private double rankSum;
    private double posRankSum;
    private double negRankSum;
    private double testMedian;
    private int testType;
    public static int LESS = 0;
    public static int GREATER = 2;
    public static int NOTEQUAL = 1;
    public double significance;

    public WilcoxonSignedRankTest(Vector<Double> data, double testMedian, int testType, double significance) {
        this.testMedian = testMedian;
        this.testType = testType;
        this.significance = significance;
        this.sampleSize = 0;
        for (Double next : data) {
            double value;
            if (next == null || (value = next - testMedian) == 0.0) continue;
            ++this.sampleSize;
        }
        this.rankSum = this.getRankSum(data);
    }

    public double pValue() {
        double p = WilcoxonSignedRankPValue.getPValue((int)Math.round(this.rankSum), this.sampleSize);
        if (this.testType == LESS || this.testType == GREATER) {
            return p;
        }
        return 2.0 * p;
    }

    public String toString() {
        String s = "";
        s = s + "Wilcoxon Signed Rank Test: <br>";
        s = s + "<table border='1'>";
        s = s + "<tr>";
        s = s + "<th>Sample size<br>(excludes values =median)</th><th>Rank Sums (+, -)</th>";
        s = s + "<th>Test Statistics</th><th>Critical Value</th><th>p-Value</th>";
        s = s + "</tr>";
        s = s + "<td>" + this.sampleSize + "</td>";
        s = s + "<td>" + this.posRankSum + ", " + this.negRankSum + "</td>";
        s = s + "<td>" + this.rankSum + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(WilcoxonSignedRankPValue.getCriticalValue(this.testType == NOTEQUAL ? this.significance / 2.0 : this.significance, this.sampleSize), 2) + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(this.pValue(), 5) + "</td>";
        s = s + "</tr>";
        s = s + "</table>";
        return s;
    }

    public double getRankSum(Vector<Double> data) {
        Vector<DataValue> dataVector = new Vector<DataValue>();
        for (Double next : data) {
            double value;
            if (next == null || (value = next - this.testMedian) == 0.0) continue;
            dataVector.add(new DataValue(value));
        }
        double[] ranks = OrderingFunctions.rank(dataVector);
        this.posRankSum = 0.0;
        this.negRankSum = 0.0;
        for (int i = 0; i < dataVector.size(); ++i) {
            if (ranks[i] > 0.0) {
                this.posRankSum += ranks[i];
                continue;
            }
            this.negRankSum += ranks[i];
        }
        this.negRankSum = Math.abs(this.negRankSum);
        if (this.testType == LESS) {
            return this.posRankSum;
        }
        if (this.testType == GREATER) {
            return this.negRankSum;
        }
        return Math.min(this.posRankSum, this.negRankSum);
    }
}

