/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential.nonparametrics;

import java.util.Vector;
import org.statcato.statistics.inferential.CorrelationRegression;
import org.statcato.utils.HelperFunctions;
import org.statcato.utils.OrderingFunctions;

public class RankCorrelation {
    CorrelationRegression cr;
    double significance;

    public RankCorrelation(Vector<Double> x, Vector<Double> y, double sig) {
        double[] ranks1 = OrderingFunctions.rankDoubleVector(x);
        double[] ranks2 = OrderingFunctions.rankDoubleVector(y);
        Vector<Double> v1 = new Vector<Double>();
        Vector<Double> v2 = new Vector<Double>();
        for (int i = 0; i < ranks1.length; ++i) {
            v1.addElement(new Double(ranks1[i]));
            v2.addElement(new Double(ranks2[i]));
        }
        this.significance = sig;
        this.cr = new CorrelationRegression(new Vector<Double>(v1), new Vector<Double>(v2), sig);
    }

    public int N() {
        return this.cr.N();
    }

    public double RankCorrelationCoeff() {
        return this.cr.LinearCorrelationCoeff();
    }

    public double CriticalValue() {
        return this.cr.CriticalValue_r(this.significance);
    }

    public double PValue() {
        return this.cr.PValue();
    }

    public String toString() {
        String text = "";
        text = text + "H<sub>0</sub>: &rho;<sub>s</sub> = 0 (There is no correlation between the two variables.)<br>";
        text = text + "H<sub>1</sub>: &rho;<sub>s</sub> &ne; 0 (There is a correlation between the two variables.)<br><br>";
        text = text + "Sample size n = " + this.N() + "<br>";
        text = text + "Test statistic (rank correlation coefficient) = " + HelperFunctions.formatFloat(this.RankCorrelationCoeff(), 4) + "<br>";
        text = text + "Critical value = &plusmn;" + HelperFunctions.formatFloat(this.CriticalValue(), 4) + "<br>";
        text = text + "p-Value = " + HelperFunctions.formatFloat(this.PValue(), 4) + "<br><br>";
        return text;
    }
}

