/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

public class SpecialFunctions {
    static double gamser;
    static double gln;
    static double gammcf;
    static double ITMAX;
    static double EPS;
    static double FPMIN;
    static int ntop;
    static double[] fact;

    public static void nrerror(String s) {
        System.err.println(s);
    }

    public static double gammln(double xx) {
        double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double y = xx;
        double x = xx;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        for (int j = 0; j <= 5; ++j) {
            ser += cof[j] / (y += 1.0);
        }
        return -tmp + Math.log(2.5066282746310007 * ser / x);
    }

    public static double factrl(int n) {
        SpecialFunctions.fact[0] = 1.0;
        SpecialFunctions.fact[1] = 1.0;
        SpecialFunctions.fact[2] = 2.0;
        SpecialFunctions.fact[3] = 6.0;
        SpecialFunctions.fact[4] = 24.0;
        if (n < 0) {
            SpecialFunctions.nrerror("Negative factorial in routine factrl");
        }
        if (n > 32) {
            return Math.exp(SpecialFunctions.gammln((double)n + 1.0));
        }
        while (ntop < n) {
            int j;
            SpecialFunctions.fact[++SpecialFunctions.ntop] = fact[j] * (double)ntop;
        }
        return fact[n];
    }

    public static double factln(int n) {
        double[] a = new double[101];
        if (n < 0) {
            SpecialFunctions.nrerror("Negative factorial in routine factln");
        }
        if (n <= 1) {
            return 0.0;
        }
        if (n <= 100) {
            if (a[n] == 0.0) {
                a[n] = SpecialFunctions.gammln((double)n + 1.0);
            }
            return a[n];
        }
        return SpecialFunctions.gammln((double)n + 1.0);
    }

    public static double binomialCoefficient(int n, int k) {
        return Math.floor(0.5 + Math.exp(SpecialFunctions.factln(n) - SpecialFunctions.factln(k) - SpecialFunctions.factln(n - k)));
    }

    public static double beta(double z, double w) {
        return Math.exp(SpecialFunctions.gammln(z) + SpecialFunctions.gammln(w) - SpecialFunctions.gammln(z + w));
    }

    public static double gammp(double a, double x) {
        if (x < 0.0 && a <= 0.0) {
            SpecialFunctions.nrerror("Invalid arguments in routine gammp");
        }
        if (x < a + 1.0) {
            SpecialFunctions.gser(a, x);
            return gamser;
        }
        SpecialFunctions.gcf(a, x);
        return 1.0 - gammcf;
    }

    public static double gammq(double a, double x) {
        if (x < 0.0 && a <= 0.0) {
            SpecialFunctions.nrerror("Invalid arguments in routine gammq");
        }
        if (x < a + 1.0) {
            SpecialFunctions.gser(a, x);
            return 1.0 - gamser;
        }
        SpecialFunctions.gcf(a, x);
        return gammcf;
    }

    public static void gser(double a, double x) {
        double sum;
        gln = SpecialFunctions.gammln(a);
        if (x <= 0.0) {
            if (x < 0.0) {
                SpecialFunctions.nrerror("x less than 0 in routine gser");
            }
            gamser = 0.0;
            return;
        }
        double ap = a;
        double del = sum = 1.0 / a;
        int n = 1;
        while ((double)n <= ITMAX) {
            sum += (del *= x / (ap += 1.0));
            if (Math.abs(del) < Math.abs(sum) * EPS) {
                gamser = sum * Math.exp(-x + a * Math.log(x) - gln);
                return;
            }
            ++n;
        }
        SpecialFunctions.nrerror("a too large, ITMAX too small in routine gser");
    }

    public static void gcf(double a, double x) {
        double d;
        gln = SpecialFunctions.gammln(a);
        double b = x + 1.0 - a;
        double c = 1.0 / FPMIN;
        double h = d = 1.0 / b;
        int i = 1;
        while ((double)i <= ITMAX) {
            double an = (double)(-i) * ((double)i - a);
            if (Math.abs(d = an * d + (b += 2.0)) < FPMIN) {
                d = FPMIN;
            }
            if (Math.abs(c = b + an / c) < FPMIN) {
                c = FPMIN;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (Math.abs(del - 1.0) < EPS) break;
            ++i;
        }
        gammcf = Math.exp(-x + a * Math.log(x) - gln) * h;
    }

    public static double erff(double x) {
        return x < 0.0 ? -SpecialFunctions.gammp(0.5, x * x) : SpecialFunctions.gammp(0.5, x * x);
    }

    public static double erffc(double x) {
        return x < 0.0 ? 1.0 + SpecialFunctions.gammp(0.5, x * x) : SpecialFunctions.gammq(0.5, x * x);
    }

    public static double betai(double a, double b, double x) {
        if (x < 0.0 || x > 1.0) {
            SpecialFunctions.nrerror("Bad x in routine betai");
        }
        double bt = x == 0.0 || x == 1.0 ? 0.0 : Math.exp(SpecialFunctions.gammln(a + b) - SpecialFunctions.gammln(a) - SpecialFunctions.gammln(b) + a * Math.log(x) + b * Math.log(1.0 - x));
        if (x < (a + 1.0) / (a + b + 2.0)) {
            return bt * SpecialFunctions.betacf(a, b, x) / a;
        }
        return 1.0 - bt * SpecialFunctions.betacf(b, a, 1.0 - x) / b;
    }

    public static double betacf(double a, double b, double x) {
        double qab = a + b;
        double qap = a + 1.0;
        double qam = a - 1.0;
        double c = 1.0;
        double d = 1.0 - qab * x / qap;
        if (Math.abs(d) < FPMIN) {
            d = FPMIN;
        }
        double h = d = 1.0 / d;
        int m = 1;
        while ((double)m <= ITMAX) {
            int m2 = 2 * m;
            double aa = (double)m * (b - (double)m) * x / ((qam + (double)m2) * (a + (double)m2));
            if (Math.abs(d = 1.0 + aa * d) < FPMIN) {
                d = FPMIN;
            }
            if (Math.abs(c = 1.0 + aa / c) < FPMIN) {
                c = FPMIN;
            }
            d = 1.0 / d;
            h *= d * c;
            aa = -(a + (double)m) * (qab + (double)m) * x / ((a + (double)m2) * (qap + (double)m2));
            if (Math.abs(d = 1.0 + aa * d) < FPMIN) {
                d = FPMIN;
            }
            if (Math.abs(c = 1.0 + aa / c) < FPMIN) {
                c = FPMIN;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (Math.abs(del - 1.0) < EPS) break;
            ++m;
        }
        if ((double)m > ITMAX) {
            SpecialFunctions.nrerror("a or b too big, or ITMAX too small in betacf");
        }
        return h;
    }

    public static double cumT(double t, double v1) {
        if (t < 0.0) {
            return SpecialFunctions.betai(v1 / 2.0, 0.5, v1 / (v1 + t * t)) / 2.0;
        }
        return 1.0 - SpecialFunctions.betai(v1 / 2.0, 0.5, v1 / (v1 + t * t)) / 2.0;
    }

    public static double cumF(double F, double v1, double v2) {
        return 1.0 - SpecialFunctions.betai(v2 / 2.0, v1 / 2.0, v2 / (v2 + v1 * F));
    }

    public static double cumNorm(double z) {
        return (SpecialFunctions.erff(Math.sqrt(2.0) * z / 2.0) + 1.0) / 2.0;
    }

    public static double cumChiSquare(double chi2, double v1) {
        return SpecialFunctions.gammp(v1 / 2.0, chi2 / 2.0);
    }

    public static double cumBinomial(int n, int k, double p) {
        return 1.0 - SpecialFunctions.betai(k, n - k + 1, p);
    }

    public static double sign(double a, double b) {
        return b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }

    static {
        ITMAX = 100.0;
        EPS = 3.0E-7;
        FPMIN = 1.0E-30;
        ntop = 4;
        fact = new double[33];
    }
}

