/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import org.statcato.statistics.ProbabilityDistribution;
import org.statcato.statistics.SpecialFunctions;

public class NormalProbabilityDistribution
extends ProbabilityDistribution {
    double mu;
    double sigma;

    public NormalProbabilityDistribution(double mu, double sigma) {
        this.mu = mu;
        this.sigma = sigma;
    }

    @Override
    public double density(double x) {
        return Math.exp(-0.5 * Math.pow((x - this.mu) / this.sigma, 2.0)) / (this.sigma * Math.sqrt(Math.PI * 2));
    }

    @Override
    public double cumulativeProbability(double x) {
        double z = (x - this.mu) / this.sigma;
        return (SpecialFunctions.erff(Math.sqrt(2.0) * z / 2.0) + 1.0) / 2.0;
    }

    public double inverseCumulativeProbability(double area) {
        if (area < 0.5) {
            return super.inverseCumulativeProbability(this.mu - 100.0 * this.sigma, this.mu, 1.0E-4, area);
        }
        if (area == 0.5) {
            return this.mu;
        }
        return super.inverseCumulativeProbability(this.mu, this.mu + 100.0 * this.sigma, 1.0E-4, area);
    }
}

