/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.spreadsheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import org.statcato.spreadsheet.Spreadsheet;

public class RowHeaderTable
extends JTable {
    JTable table;

    public RowHeaderTable(JTable table) {
        super(0, 1);
        this.table = table;
        DefaultTableModel headerData = (DefaultTableModel)this.getModel();
        int numRows = table.getModel().getRowCount();
        headerData.addRow(new Object[]{"Var"});
        for (int i = 1; i < numRows; ++i) {
            headerData.addRow(new Object[]{i});
        }
        LookAndFeel.installColorsAndFont(this, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        this.setIntercellSpacing(new Dimension(0, 0));
        Dimension d = this.getPreferredScrollableViewportSize();
        d.width = this.getPreferredSize().width;
        this.setPreferredScrollableViewportSize(d);
        this.setRowHeight(table.getRowHeight());
        this.setDefaultRenderer(Object.class, new RowHeaderRenderer(table));
        this.setSelectionMode(1);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    RowHeaderTable.this.deleteSelectedCells();
                }
            }
        });
    }

    public void addHeaderRow() {
        DefaultTableModel headerData = (DefaultTableModel)this.getModel();
        int numRows = headerData.getRowCount();
        headerData.addRow(new Object[]{numRows});
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    private void deleteSelectedCells() {
        ((Spreadsheet)this.table).deleteSelectedCells();
    }

    public class RowHeaderRenderer
    extends DefaultTableCellRenderer {
        protected Border noFocusBorder;
        protected Border focusBorder;
        protected JTable table;
        protected Color Foreground;
        protected Color Background;

        public RowHeaderRenderer(JTable table) {
            this.table = table;
            this.setOpaque(true);
            Border cell = UIManager.getBorder("TableHeader.cellBorder");
            Border focus = UIManager.getBorder("Table.focusCellHighlightBorder");
            this.focusBorder = new BorderUIResource.CompoundBorderUIResource(cell, focus);
            Insets i = focus.getBorderInsets(this);
            this.noFocusBorder = new BorderUIResource.CompoundBorderUIResource(cell, BorderFactory.createEmptyBorder(i.top, i.left, i.bottom, i.right));
            JTableHeader header = table.getTableHeader();
            this.Foreground = header.getForeground();
            this.Background = header.getBackground();
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setForeground(this.Foreground);
            this.setBackground(this.Background);
            this.setFont(header.getFont());
            this.setBorder(this.noFocusBorder);
        }

        @Override
        public void updateUI() {
            super.updateUI();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ((Component)e.getSource()).setBackground(Color.white);
                    ((Component)e.getSource()).setForeground(Color.blue);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ((Component)e.getSource()).setBackground(RowHeaderRenderer.this.Background);
                    ((Component)e.getSource()).setForeground(RowHeaderRenderer.this.Foreground);
                }
            });
            this.setFont(UIManager.getFont("TableHeader.font"));
            this.setEnabled(true);
            if (focused) {
                this.setBorder(this.focusBorder);
            } else {
                this.setBorder(this.noFocusBorder);
            }
            this.setValue(value);
            return this;
        }
    }
}

