/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.statcato.Statcato;
import org.statcato.file.FileOperations;
import org.statcato.graph.GraphUtils;
import org.statcato.utils.HelperFunctions;

public class StatcatoMultipleChartFrame
extends JFrame
implements ActionListener,
Printable {
    private transient ImageSelection imgsel;
    public transient Statcato parent;
    protected transient ArrayList<JFreeChart> chartList;
    protected transient ArrayList<ChartPanel> chartPanelList;
    protected String title;

    public StatcatoMultipleChartFrame(String title, ArrayList<JFreeChart> charts, Statcato parent0) {
        super(title);
        this.title = title;
        this.chartList = charts;
        this.parent = parent0;
        this.chartPanelList = new ArrayList();
        this.setupFrame();
    }

    private void setupFrame() {
        JMenuBar menuBar = new JMenuBar();
        JMenu FileMenu = new JMenu("Graph");
        JMenuItem copy = new JMenuItem("Copy Graph to Clipboard");
        FileMenu.add(copy);
        copy.setActionCommand("copy");
        copy.addActionListener(this);
        JMenuItem save = new JMenuItem("Save...");
        FileMenu.add(save);
        save.setActionCommand("save");
        save.addActionListener(this);
        JMenuItem print = new JMenuItem("Print...");
        FileMenu.add(print);
        print.setActionCommand("print");
        print.addActionListener(this);
        menuBar.add(FileMenu);
        this.setJMenuBar(menuBar);
        this.imgsel = new ImageSelection();
        this.setDefaultCloseOperation(0);
        this.parent.addWindowFrame(this);
        if (this.chartList.size() == 1) {
            this.getContentPane().add(new ChartPanel(this.chartList.get(0)));
        } else {
            JPanel panel = new JPanel(new GridLayout(0, 2));
            panel.setBackground(Color.white);
            for (int i = 0; i < this.chartList.size(); ++i) {
                ChartPanel c = new ChartPanel(this.chartList.get(i));
                this.chartPanelList.add(c);
                panel.add(c);
            }
            this.getContentPane().add(panel);
        }
        this.addCloseListener();
        this.restore();
    }

    public void addCloseListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Object[] options = new Object[]{"Confirm", "Cancel"};
                int choice = JOptionPane.showOptionDialog(StatcatoMultipleChartFrame.this, "Are you sure you want to remove the graph from the project?", "Closing Chart...", 0, 3, null, options, options[0]);
                if (choice == 0) {
                    StatcatoMultipleChartFrame.this.parent.removeWindowFrame(StatcatoMultipleChartFrame.this);
                    StatcatoMultipleChartFrame.this.dispose();
                }
            }
        });
    }

    public String getChartTitle() {
        return this.title;
    }

    public ArrayList<JFreeChart> getCharts() {
        return this.chartList;
    }

    public void setParent(Statcato parent) {
        this.parent = parent;
    }

    public void restore() {
        this.setState(0);
        this.toFront();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("copy")) {
            this.setClipboard(GraphUtils.joinBufferedChartImages(this.chartList));
        } else if (ae.getActionCommand().equals("save")) {
            JFileChooser fileChooser = new JFileChooser(FileOperations.getRecentProject() == null ? null : FileOperations.getRecentProject().getParentFile());
            FileNameExtensionFilter filter = new FileNameExtensionFilter("PNG", "png");
            fileChooser.addChoosableFileFilter(filter);
            fileChooser.setFileFilter(filter);
            int option = fileChooser.showSaveDialog(this);
            if (option == 0) {
                String filename = fileChooser.getSelectedFile().getPath();
                if (!filename.endsWith(".png")) {
                    filename = filename + ".png";
                }
                BufferedImage image = GraphUtils.joinBufferedChartImages(this.chartList);
                File file = new File(filename);
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
                    GraphUtils.writeBufferedImageAsPNG(os, image, image.getWidth(), image.getHeight());
                }
                catch (IOException e) {
                    HelperFunctions.showErrorDialog(this, "Unexpected error while saving");
                }
            }
        } else if (ae.getActionCommand().equals("print")) {
            this.createChartPrintJob();
        } else {
            for (int i = 0; i < this.chartPanelList.size(); ++i) {
                this.chartPanelList.get(i).actionPerformed(ae);
            }
        }
    }

    public void createChartPrintJob() {
        PageFormat pf;
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf2 = job.pageDialog(pf = job.defaultPage());
        if (pf2 != pf) {
            job.setPrintable(this, pf2);
            if (job.printDialog()) {
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    JOptionPane.showMessageDialog(this, e);
                }
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        GraphUtils.drawCharts(g2, this.chartList, (int)pf.getImageableX(), (int)pf.getImageableY(), (int)pf.getImageableWidth(), (int)pf.getImageableHeight());
        return 0;
    }

    private void setClipboard(Image image) {
        this.imgsel.setImage(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(this.imgsel, null);
    }

    private class ImageSelection
    implements Transferable {
        private Image image;

        private ImageSelection() {
        }

        public void setImage(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

