/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.graph;

import Jama.Matrix;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.Regression;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.statcato.graph.ExtendedBoxAndWhiskerRenderer;
import org.statcato.graph.ExtendedBoxAndWhiskerToolTipGenerator;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.statistics.inferential.MultipleRegression;
import org.statcato.utils.HelperFunctions;

public class GraphFactory {
    public static final int REG_NONE = 0;
    public static final int REG_LIN = 1;
    public static final int REG_QUAD = 2;
    public static final int REG_CUBIC = 3;
    public static final int REG_POLY = 4;
    public static final int REG_LOG = 5;
    public static final int REG_POW = 6;
    public static final int REG_FIXEDPOW = 7;
    public static final int REG_EXP = 8;
    public static final Color[] COLORS = new Color[]{Color.BLUE, Color.CYAN, Color.MAGENTA, Color.GREEN, Color.ORANGE, Color.RED, Color.PINK, Color.YELLOW, Color.GRAY, Color.LIGHT_GRAY};
    private static final int NUM_SUBINT = 1000;
    private static final double SHIFT = 0.0;

    public static JFreeChart createNormalQuantilePlot(Vector<Double> YColumnVector, String title, String xLabel, String yLabel, boolean isDataOnXAxis, boolean showRegressionLine) {
        XYSeriesCollection data;
        Vector<Double> ZScores = new Vector<Double>();
        Collections.sort(YColumnVector);
        int n = YColumnVector.size();
        XYSeries series = new XYSeries((Comparable)((Object)"Points"));
        for (int i = 0; i < n; ++i) {
            double a = (2.0 * (double)i + 1.0) / (2.0 * (double)n);
            NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
            double z = dist.inverseCumulativeProbability(a);
            ZScores.addElement(new Double(z));
            if (isDataOnXAxis) {
                series.add((double)YColumnVector.elementAt(i), z);
                continue;
            }
            series.add(z, YColumnVector.elementAt(i));
        }
        XYSeriesCollection data1 = data = new XYSeriesCollection(series);
        XYDotRenderer renderer1 = new XYDotRenderer();
        JFreeChart plot = ChartFactory.createScatterPlot(title, xLabel, yLabel, data1, PlotOrientation.VERTICAL, false, true, false);
        if (showRegressionLine) {
            if (!isDataOnXAxis) {
                YColumnVector = ZScores;
            }
            XYPlot xYplot = plot.getXYPlot();
            double max = BasicStatistics.max(YColumnVector) + 0.5;
            double min = BasicStatistics.min(YColumnVector) - 0.5;
            double[] coeff = Regression.getOLSRegression(data1, 0);
            XYLineAnnotation regressionLine = new XYLineAnnotation(min, coeff[0] + coeff[1] * min, max, coeff[0] + coeff[1] * max, new BasicStroke(), Color.BLUE);
            xYplot.addAnnotation(regressionLine);
            ValueAxis rangeAxis = xYplot.getRangeAxis();
            ValueAxis domainAxis = xYplot.getDomainAxis();
            xYplot.setDomainAxis(domainAxis);
            xYplot.setRangeAxis(rangeAxis);
        }
        return plot;
    }

    public static JFreeChart createNormalQuantilePlot(ArrayList<Double> YColumnArray, String title, String xLabel, String yLabel, boolean isDataOnXAxis, boolean showRegressionLine) {
        return GraphFactory.createNormalQuantilePlot(new Vector<Double>(YColumnArray), title, xLabel, yLabel, isDataOnXAxis, showRegressionLine);
    }

    public static JFreeChart createBoxPlot(DefaultBoxAndWhiskerCategoryDataset dataset, String title, String xLabel, String yLabel, boolean showLegend, boolean horizontal) {
        CategoryAxis xAxis = new CategoryAxis(xLabel);
        NumberAxis yAxis = new NumberAxis(yLabel);
        yAxis.setAutoRangeIncludesZero(false);
        ExtendedBoxAndWhiskerRenderer renderer = new ExtendedBoxAndWhiskerRenderer();
        renderer.setFillBox(true);
        renderer.setBaseToolTipGenerator(new ExtendedBoxAndWhiskerToolTipGenerator());
        CategoryPlot plot = new CategoryPlot(dataset, xAxis, yAxis, renderer);
        if (horizontal) {
            plot.setOrientation(PlotOrientation.HORIZONTAL);
        } else {
            plot.setOrientation(PlotOrientation.VERTICAL);
        }
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setLowerMargin(0.15);
        domainAxis.setUpperMargin(0.15);
        domainAxis.setCategoryMargin(0.25);
        JFreeChart chart = new JFreeChart(title, new Font("SansSerif", 1, 14), plot, showLegend);
        return chart;
    }

    public static JFreeChart createScatterplot(XYSeriesCollection seriesCollection, String title, String xLabel, String yLabel, boolean showLegend, int regressionType, double regressionArg, double min, double max) {
        int i;
        JFreeChart chart = ChartFactory.createScatterPlot(title, xLabel, yLabel, seriesCollection, PlotOrientation.VERTICAL, showLegend, true, false);
        XYPlot plot = chart.getXYPlot();
        XYDotRenderer renderer = new XYDotRenderer();
        renderer.setDotWidth(4);
        renderer.setDotHeight(4);
        plot.setRenderer(renderer);
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        if (regressionType == 1) {
            for (i = 0; i < seriesCollection.getSeriesCount(); ++i) {
                double[] coeff = Regression.getOLSRegression(seriesCollection, i);
                XYLineAnnotation regressionLine = new XYLineAnnotation(min, coeff[0] + coeff[1] * min, max, coeff[0] + coeff[1] * max, new BasicStroke(), COLORS[i % COLORS.length]);
                plot.addAnnotation(regressionLine);
                LegendItemCollection c = plot.getLegendItems();
                c.add(new LegendItem("y = " + HelperFunctions.formatFloat2(coeff[0]) + " + " + HelperFunctions.formatFloat2(coeff[1]) + "x", "linear regression", "linear regression", null, (Shape)new Line2D.Double(0.0, 0.0, 12.0, 0.0), (Stroke)new BasicStroke(), (Paint)COLORS[i % COLORS.length]));
                plot.setFixedLegendItems(c);
            }
        } else if (regressionType != 0) {
            for (i = 0; i < seriesCollection.getSeriesCount(); ++i) {
                LegendItemCollection c;
                XYLineAnnotation line;
                double x2;
                double y1;
                double b;
                double a;
                String text;
                double y2;
                XYSeries series = seriesCollection.getSeries(i);
                Vector<Double> xVector = new Vector<Double>();
                Vector<Double> yVector = new Vector<Double>();
                for (int j = 0; j < series.getItemCount(); ++j) {
                    double x = series.getX(j).doubleValue();
                    double y = series.getY(j).doubleValue();
                    xVector.addElement(new Double(x));
                    yVector.addElement(new Double(y));
                }
                Vector<Double> coeff = GraphFactory.computeRegressionCoeff(xVector, yVector, regressionType, regressionArg);
                if (coeff == null || coeff.size() == 0) {
                    return null;
                }
                if (regressionType == 2 || regressionType == 3 || regressionType == 4) {
                    for (int k = 0; k < 1000; ++k) {
                        double x1 = min + (double)k * (max - min) / 1000.0;
                        double y12 = 0.0;
                        for (int n = 0; n < coeff.size(); ++n) {
                            y12 += coeff.elementAt(n) * Math.pow(x1, n);
                        }
                        double x22 = min + (double)(k + 1) * (max - min) / 1000.0;
                        y2 = 0.0;
                        for (int n = 0; n < coeff.size(); ++n) {
                            y2 += coeff.elementAt(n) * Math.pow(x22, n);
                        }
                        XYLineAnnotation line2 = new XYLineAnnotation(x1, y12, x22, y2, new BasicStroke(), COLORS[i % COLORS.length]);
                        plot.addAnnotation(line2);
                    }
                    LegendItemCollection c2 = plot.getLegendItems();
                    text = "y = ";
                    text = text + HelperFunctions.formatFloat2(coeff.elementAt(0));
                    text = text + " + " + HelperFunctions.formatFloat2(coeff.elementAt(1)) + "x";
                    for (int n = 2; n < coeff.size(); ++n) {
                        text = text + " + " + HelperFunctions.formatFloat2(coeff.elementAt(n));
                        text = text + "x^" + n;
                    }
                    c2.add(new LegendItem(text, "regression equation", "regression equation", null, (Shape)new Line2D.Double(0.0, 0.0, 12.0, 0.0), (Stroke)new BasicStroke(), (Paint)COLORS[i % COLORS.length]));
                    plot.setFixedLegendItems(c2);
                    continue;
                }
                if (regressionType == 5) {
                    for (int k = 0; k < 1000; ++k) {
                        double x1 = min + (double)k * (max - min) / 1000.0;
                        double y13 = coeff.elementAt(0) + coeff.elementAt(1) * Math.log(x1);
                        double x23 = min + (double)(k + 1) * (max - min) / 1000.0;
                        y2 = 0.0;
                        y2 = coeff.elementAt(0) + coeff.elementAt(1) * Math.log(x23);
                        XYLineAnnotation line3 = new XYLineAnnotation(x1, y13, x23, y2, new BasicStroke(), COLORS[i % COLORS.length]);
                        plot.addAnnotation(line3);
                    }
                    LegendItemCollection c3 = plot.getLegendItems();
                    text = "y = ";
                    text = text + HelperFunctions.formatFloat2(coeff.elementAt(0));
                    text = text + " + " + HelperFunctions.formatFloat2(coeff.elementAt(1)) + "ln(x)";
                    c3.add(new LegendItem(text, "regression equation", "regression equation", null, (Shape)new Line2D.Double(0.0, 0.0, 12.0, 0.0), (Stroke)new BasicStroke(), (Paint)COLORS[i % COLORS.length]));
                    plot.setFixedLegendItems(c3);
                    continue;
                }
                if (regressionType == 6) {
                    a = coeff.elementAt(0);
                    b = coeff.elementAt(1);
                    for (int k = 0; k < 1000; ++k) {
                        double x1 = min + (double)k * (max - min) / 1000.0 - 0.0;
                        y1 = a * Math.pow(x1, b);
                        x2 = min + (double)(k + 1) * (max - min) / 1000.0 - 0.0;
                        double y22 = a * Math.pow(x2, b);
                        line = new XYLineAnnotation(x1, y1, x2, y22, new BasicStroke(), COLORS[i % COLORS.length]);
                        plot.addAnnotation(line);
                    }
                    c = plot.getLegendItems();
                    String text2 = "y = ";
                    text2 = text2 + HelperFunctions.formatFloat2(coeff.elementAt(0));
                    text2 = text2 + " * x^" + HelperFunctions.formatFloat2(coeff.elementAt(1));
                    c.add(new LegendItem(text2, "regression equation", "regression equation", null, (Shape)new Line2D.Double(0.0, 0.0, 12.0, 0.0), (Stroke)new BasicStroke(), (Paint)COLORS[i % COLORS.length]));
                    plot.setFixedLegendItems(c);
                    continue;
                }
                if (regressionType == 7) {
                    a = coeff.elementAt(0);
                    for (int k = 0; k < 1000; ++k) {
                        double x1 = min + (double)k * (max - min) / 1000.0;
                        double y14 = a * Math.pow(x1, regressionArg);
                        double x24 = min + (double)(k + 1) * (max - min) / 1000.0;
                        double y23 = a * Math.pow(x24, regressionArg);
                        XYLineAnnotation line4 = new XYLineAnnotation(x1, y14, x24, y23, new BasicStroke(), COLORS[i % COLORS.length]);
                        plot.addAnnotation(line4);
                    }
                    LegendItemCollection c4 = plot.getLegendItems();
                    String text3 = "y = ";
                    text3 = text3 + HelperFunctions.formatFloat2(a);
                    text3 = text3 + " * x^" + HelperFunctions.formatFloat2(regressionArg);
                    c4.add(new LegendItem(text3, "regression equation", "regression equation", null, (Shape)new Line2D.Double(0.0, 0.0, 12.0, 0.0), (Stroke)new BasicStroke(), (Paint)COLORS[i % COLORS.length]));
                    plot.setFixedLegendItems(c4);
                    continue;
                }
                if (regressionType != 8) continue;
                a = coeff.elementAt(0);
                b = coeff.elementAt(1);
                for (int k = 0; k < 1000; ++k) {
                    double x1 = min + (double)k * (max - min) / 1000.0;
                    y1 = a * Math.pow(b, x1);
                    x2 = min + (double)(k + 1) * (max - min) / 1000.0;
                    double y24 = a * Math.pow(b, x2);
                    line = new XYLineAnnotation(x1, y1, x2, y24, new BasicStroke(), COLORS[i % COLORS.length]);
                    plot.addAnnotation(line);
                }
                c = plot.getLegendItems();
                String text4 = "y = ";
                text4 = text4 + HelperFunctions.formatFloat2(a);
                text4 = text4 + " * " + HelperFunctions.formatFloat2(b) + "^x";
                c.add(new LegendItem(text4, "regression equation", "regression equation", null, (Shape)new Line2D.Double(0.0, 0.0, 12.0, 0.0), (Stroke)new BasicStroke(), (Paint)COLORS[i % COLORS.length]));
                plot.setFixedLegendItems(c);
            }
        }
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        return chart;
    }

    public static Vector<Double> computeRegressionCoeff(Vector<Double> xVector, Vector<Double> yVector, int regressionType, double regressionArg) {
        Vector<Vector<Double>> vectors = new Vector<Vector<Double>>();
        Vector<Double> coeff = new Vector<Double>();
        double k = 0.0;
        boolean logTransform = false;
        if (regressionType == 2) {
            vectors.addElement(xVector);
            vectors.addElement(HelperFunctions.powerVector(xVector, 2));
            k = 3.0;
        } else if (regressionType == 3) {
            vectors.addElement(xVector);
            vectors.addElement(HelperFunctions.powerVector(xVector, 2));
            vectors.addElement(HelperFunctions.powerVector(xVector, 3));
            k = 4.0;
        } else if (regressionType == 4) {
            vectors.addElement(xVector);
            int i = 2;
            while ((double)i <= regressionArg) {
                vectors.addElement(HelperFunctions.powerVector(xVector, i));
                ++i;
            }
            k = regressionArg + 1.0;
        } else if (regressionType == 5) {
            vectors.addElement(HelperFunctions.logVector(xVector));
            k = 2.0;
        } else if (regressionType == 6) {
            vectors.addElement(HelperFunctions.logVector(HelperFunctions.addConstantVector(xVector, 0.0)));
            yVector = HelperFunctions.logVector(HelperFunctions.addConstantVector(yVector, 0.0));
            k = 2.0;
            logTransform = true;
        } else if (regressionType == 8) {
            vectors.addElement(xVector);
            yVector = HelperFunctions.logVector(HelperFunctions.addConstantVector(yVector, 0.0));
            k = 2.0;
            logTransform = true;
        } else if (regressionType == 7) {
            Vector<Double> xn = HelperFunctions.powerVector(xVector, regressionArg);
            vectors.addElement(xn);
            k = 1.0;
        }
        try {
            MultipleRegression mr = new MultipleRegression(vectors, yVector, regressionType != 7);
            Matrix RegCoeff = mr.RegressionEqCoefficients();
            if (regressionType == 7) {
                if (Double.isNaN(RegCoeff.get(0, 0)) || Double.isInfinite(RegCoeff.get(0, 0))) {
                    return null;
                }
                coeff.addElement(RegCoeff.get(0, 0));
            } else if (!logTransform) {
                int i = 0;
                while ((double)i < k) {
                    if (Double.isNaN(RegCoeff.get(i, 0)) || Double.isInfinite(RegCoeff.get(i, 0))) {
                        return null;
                    }
                    coeff.addElement(RegCoeff.get(i, 0));
                    ++i;
                }
            } else if (regressionType == 6) {
                if (Double.isNaN(RegCoeff.get(0, 0)) || Double.isInfinite(RegCoeff.get(0, 0))) {
                    return null;
                }
                if (Double.isNaN(RegCoeff.get(1, 0)) || Double.isInfinite(RegCoeff.get(1, 0))) {
                    return null;
                }
                coeff.addElement(Math.exp(RegCoeff.get(0, 0)));
                coeff.addElement(RegCoeff.get(1, 0));
            } else if (regressionType == 8) {
                if (Double.isNaN(RegCoeff.get(0, 0)) || Double.isInfinite(RegCoeff.get(0, 0))) {
                    return null;
                }
                if (Double.isNaN(RegCoeff.get(1, 0)) || Double.isInfinite(RegCoeff.get(1, 0))) {
                    return null;
                }
                coeff.addElement(Math.exp(RegCoeff.get(0, 0)));
                coeff.addElement(Math.exp(RegCoeff.get(1, 0)));
            }
        }
        catch (RuntimeException e) {
            System.out.println("exception in computing regression coefficients: " + e);
        }
        return coeff;
    }

    public static JFreeChart createScatterplot(XYSeriesCollection seriesCollection, String title, String xLabel, String yLabel, boolean showLegend, boolean showRegression, double min, double max) {
        if (showRegression) {
            return GraphFactory.createScatterplot(seriesCollection, title, xLabel, yLabel, showLegend, 1, 0.0, min, max);
        }
        return GraphFactory.createScatterplot(seriesCollection, title, xLabel, yLabel, showLegend, 0, 0.0, min, max);
    }

    public static JFreeChart createResidualPlot(XYSeriesCollection seriesCollection, String title, String xLabel, String yLabel, boolean showLegend, boolean showZeroHorizon, double min, double max) {
        JFreeChart chart = GraphFactory.createScatterplot(seriesCollection, title, xLabel, yLabel, showLegend, 0, 0.0, min, max);
        if (showZeroHorizon) {
            XYLineAnnotation line = new XYLineAnnotation(min, 0.0, max, 0.0, new BasicStroke(), Color.GRAY);
            chart.getXYPlot().addAnnotation(line);
        }
        return chart;
    }

    public static JFreeChart createBarChart(String title, String xTitle, String yTitle, DefaultCategoryDataset dataset, PlotOrientation orientation, boolean hasLegend) {
        JFreeChart chart = ChartFactory.createBarChart(title, xTitle, yTitle, dataset, orientation, hasLegend, true, false);
        CategoryPlot categoryplot = chart.getCategoryPlot();
        BarRenderer renderer = (BarRenderer)categoryplot.getRenderer();
        renderer.setItemMargin(0.0);
        return chart;
    }

    public static JFreeChart createPieChart(String title, DefaultPieDataset data, boolean hasLegend, boolean hasLabel) {
        JFreeChart chart = ChartFactory.createPieChart(title, (PieDataset)data, hasLegend, true, false);
        PiePlot plot = (PiePlot)chart.getPlot();
        if (hasLabel) {
            StandardPieSectionLabelGenerator gen = new StandardPieSectionLabelGenerator("{0} = {1} ({2})");
            plot.setLabelGenerator(gen);
        } else {
            plot.setLabelGenerator(null);
        }
        return chart;
    }

    public static JFreeChart createHistogram(String title, String xTitle, String yTitle, HistogramDataset dataset, boolean hasLegend, TickUnits units, double minBin, double minBinStart, boolean center, double yTicks) {
        JFreeChart chart = ChartFactory.createHistogram(title, xTitle, yTitle, dataset, PlotOrientation.VERTICAL, hasLegend, false, false);
        XYPlot xyplot = chart.getXYPlot();
        xyplot.setForegroundAlpha(0.75f);
        NumberAxis numberaxis = (NumberAxis)xyplot.getDomainAxis();
        numberaxis.setStandardTickUnits(units);
        numberaxis.setLowerBound(minBinStart);
        numberaxis.setLowerMargin(0.0);
        double firstTick = center ? minBinStart + minBin / 2.0 : minBinStart;
        final double xmin = firstTick;
        NumberAxis domainAxis_x = new NumberAxis("X Values"){

            @Override
            protected double calculateLowestVisibleTickValue() {
                return xmin;
            }
        };
        domainAxis_x.setStandardTickUnits(units);
        domainAxis_x.setRange(numberaxis.getRange());
        domainAxis_x.setAutoRangeIncludesZero(false);
        domainAxis_x.setLabel(xTitle);
        xyplot.setDomainAxis(domainAxis_x);
        if (yTicks > 0.0) {
            NumberAxis yaxis = (NumberAxis)xyplot.getRangeAxis();
            yaxis.setTickUnit(new NumberTickUnit(yTicks));
        }
        return chart;
    }
}

