/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.graph;

import java.text.NumberFormat;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;

public class ExtendedBoxAndWhiskerToolTipGenerator
extends BoxAndWhiskerToolTipGenerator {
    private static final long serialVersionUID = -7274642882075068152L;

    public ExtendedBoxAndWhiskerToolTipGenerator() {
    }

    public ExtendedBoxAndWhiskerToolTipGenerator(String format, NumberFormat formatter) {
        super(format, formatter);
    }

    @Override
    protected Object[] createItemArray(CategoryDataset dataset, int series, int item) {
        Object[] result = new Object[8];
        result[0] = dataset.getRowKey(series);
        Number y = dataset.getValue(series, item);
        NumberFormat formatter = this.getNumberFormat();
        result[1] = formatter.format(y);
        if (dataset instanceof BoxAndWhiskerCategoryDataset) {
            BoxAndWhiskerCategoryDataset d = (BoxAndWhiskerCategoryDataset)dataset;
            Number meanValue = d.getMeanValue(series, item);
            result[2] = meanValue != null ? formatter.format(meanValue) : "";
            Number medianValue = d.getMedianValue(series, item);
            result[3] = medianValue != null ? formatter.format(medianValue) : "";
            Number minValue = d.getMinRegularValue(series, item);
            result[4] = minValue != null ? formatter.format(minValue) : "";
            Number maxValue = d.getMaxRegularValue(series, item);
            result[5] = maxValue != null ? formatter.format(maxValue) : "";
            Number q1Value = d.getQ1Value(series, item);
            result[6] = q1Value != null ? formatter.format(q1Value) : "";
            Number q3Value = d.getQ3Value(series, item);
            result[7] = q3Value != null ? formatter.format(q3Value) : "";
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ExtendedBoxAndWhiskerToolTipGenerator) {
            return super.equals(obj);
        }
        return false;
    }
}

