/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.Outlier;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.statcato.graph.FaroutEntity;
import org.statcato.graph.OutlierEntity;

public class ExtendedBoxAndWhiskerRenderer
extends BoxAndWhiskerRenderer {
    private static final long serialVersionUID = -8932682032311494648L;
    private transient Paint outlierPaint = Color.red;
    private transient Paint faroutPaint = Color.gray;

    public Paint getOutlierPaint() {
        return this.outlierPaint;
    }

    public void setOutlierPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.outlierPaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Paint getFaroutPaint() {
        return this.faroutPaint;
    }

    public void setFaroutPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.faroutPaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    @Override
    public void drawVerticalItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column) {
        EntityCollection entities;
        if (!this.getItemVisible(row, column)) {
            return;
        }
        BoxAndWhiskerCategoryDataset bawDataset = (BoxAndWhiskerCategoryDataset)dataset;
        double categoryEnd = domainAxis.getCategoryEnd(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double categoryStart = domainAxis.getCategoryStart(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double categoryWidth = categoryEnd - categoryStart;
        double xx = categoryStart;
        int seriesCount = this.getRowCount();
        int categoryCount = this.getColumnCount();
        if (seriesCount > 1) {
            double seriesGap = dataArea.getWidth() * this.getItemMargin() / (double)(categoryCount * (seriesCount - 1));
            double usedWidth = state.getBarWidth() * (double)seriesCount + seriesGap * (double)(seriesCount - 1);
            double offset = (categoryWidth - usedWidth) / 2.0;
            xx = xx + offset + (double)row * (state.getBarWidth() + seriesGap);
        } else {
            double offset = (categoryWidth - state.getBarWidth()) / 2.0;
            xx += offset;
        }
        double xxmid = xx + state.getBarWidth() / 2.0;
        Paint p = this.getItemPaint(row, column);
        if (p != null) {
            g2.setPaint(p);
        }
        Stroke s = this.getItemStroke(row, column);
        g2.setStroke(s);
        RectangleEdge location = plot.getRangeAxisEdge();
        Rectangle2D.Double box = null;
        Number yQ1 = bawDataset.getQ1Value(row, column);
        Number yQ3 = bawDataset.getQ3Value(row, column);
        Number yMax = bawDataset.getMaxRegularValue(row, column);
        Number yMin = bawDataset.getMinRegularValue(row, column);
        if (yQ1 != null && yQ3 != null && yMax != null && yMin != null) {
            double yyQ1 = rangeAxis.valueToJava2D(yQ1.doubleValue(), dataArea, location);
            double yyQ3 = rangeAxis.valueToJava2D(yQ3.doubleValue(), dataArea, location);
            double yyMax = rangeAxis.valueToJava2D(yMax.doubleValue(), dataArea, location);
            double yyMin = rangeAxis.valueToJava2D(yMin.doubleValue(), dataArea, location);
            g2.draw(new Line2D.Double(xxmid, yyMax, xxmid, yyQ3));
            g2.draw(new Line2D.Double(xx, yyMax, xx + state.getBarWidth(), yyMax));
            g2.draw(new Line2D.Double(xxmid, yyMin, xxmid, yyQ1));
            g2.draw(new Line2D.Double(xx, yyMin, xx + state.getBarWidth(), yyMin));
            box = new Rectangle2D.Double(xx, Math.min(yyQ1, yyQ3), state.getBarWidth(), Math.abs(yyQ1 - yyQ3));
            if (this.getFillBox()) {
                g2.fill(box);
            }
            g2.draw(box);
        }
        g2.setPaint(this.getArtifactPaint());
        double yyAverage = 0.0;
        double aRadius = 2.0;
        Number yMean = bawDataset.getMeanValue(row, column);
        if (yMean != null) {
            yyAverage = rangeAxis.valueToJava2D(yMean.doubleValue(), dataArea, location);
            Ellipse2D.Double avgEllipse = new Ellipse2D.Double(xxmid - aRadius, yyAverage - aRadius, aRadius * 2.0, aRadius * 2.0);
            g2.fill(avgEllipse);
            g2.draw(avgEllipse);
        }
        double yyMedian = 0.0;
        Number yMedian = bawDataset.getMedianValue(row, column);
        if (yMedian != null) {
            yyMedian = rangeAxis.valueToJava2D(yMedian.doubleValue(), dataArea, location);
            g2.draw(new Line2D.Double(xx, yyMedian, xx + state.getBarWidth(), yyMedian));
        }
        if (box == null && yMedian != null) {
            box = new Rectangle2D.Double(xx, yyMedian, state.getBarWidth(), yyMedian);
        }
        double oRadius = 2.0;
        double foRadius = 4.0;
        ArrayList<Outlier> outliers = new ArrayList<Outlier>();
        ArrayList<Outlier> farOutValues = new ArrayList<Outlier>();
        List yOutliers = bawDataset.getOutliers(row, column);
        if (yOutliers != null) {
            for (int i = 0; i < yOutliers.size(); ++i) {
                double yyOutlier;
                Outlier outlierToAdd;
                Number outlierNum = (Number)yOutliers.get(i);
                double outlier = outlierNum.doubleValue();
                Number minOutlier = bawDataset.getMinOutlier(row, column);
                Number maxOutlier = bawDataset.getMaxOutlier(row, column);
                Number minRegular = bawDataset.getMinRegularValue(row, column);
                Number maxRegular = bawDataset.getMaxRegularValue(row, column);
                if (outlier > maxOutlier.doubleValue() || outlier < minOutlier.doubleValue()) {
                    double yyFarout = rangeAxis.valueToJava2D(outlier, dataArea, location);
                    Outlier faroutToAdd = new Outlier(xxmid, yyFarout, foRadius);
                    if (!dataArea.contains(faroutToAdd.getPoint())) continue;
                    farOutValues.add(faroutToAdd);
                    continue;
                }
                if (!(outlier > maxRegular.doubleValue()) && !(outlier < minRegular.doubleValue()) || !dataArea.contains((outlierToAdd = new Outlier(xxmid, yyOutlier = rangeAxis.valueToJava2D(outlier, dataArea, location), oRadius)).getPoint())) continue;
                outliers.add(outlierToAdd);
            }
            g2.setPaint(this.outlierPaint);
            for (Outlier outlier : outliers) {
                Point2D point = outlier.getPoint();
                Shape dot = this.createEllipse(point, oRadius);
                g2.draw(dot);
            }
            g2.setPaint(this.faroutPaint);
            for (Outlier outlier : farOutValues) {
                Point2D point = outlier.getPoint();
                Shape triangle = this.createTriangleVertical(point, foRadius);
                g2.draw(triangle);
            }
        }
        if (state.getInfo() != null && (entities = state.getEntityCollection()) != null) {
            Point2D point;
            int i;
            if (box != null) {
                this.addItemEntity(entities, dataset, row, column, box);
            }
            for (i = 0; i < outliers.size(); ++i) {
                Outlier outlier = (Outlier)outliers.get(i);
                point = outlier.getPoint();
                Shape dot = this.createEllipse(point, oRadius);
                String outlierTooltip = "Outlier : ";
                double outlierY = rangeAxis.java2DToValue(outlier.getY() + oRadius, dataArea, location);
                outlierTooltip = outlierTooltip.concat(Double.toString(outlierY));
                this.addOutlierEntity(outlierTooltip, entities, dataset, row, column, dot);
            }
            for (i = 0; i < farOutValues.size(); ++i) {
                Outlier farout = (Outlier)farOutValues.get(i);
                point = farout.getPoint();
                Shape triangle = this.createTriangleVertical(point, foRadius);
                String faroutTooltip = "Farout : ";
                double faroutY = rangeAxis.java2DToValue(farout.getY() + foRadius, dataArea, location);
                faroutTooltip = faroutTooltip.concat(Double.toString(faroutY));
                this.addFaroutEntity(faroutTooltip, entities, dataset, row, column, triangle);
            }
        }
    }

    @Override
    public void drawHorizontalItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column) {
        EntityCollection entities;
        if (!this.getItemVisible(row, column)) {
            return;
        }
        BoxAndWhiskerCategoryDataset bawDataset = (BoxAndWhiskerCategoryDataset)dataset;
        double categoryEnd = domainAxis.getCategoryEnd(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double categoryStart = domainAxis.getCategoryStart(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double categoryWidth = Math.abs(categoryEnd - categoryStart);
        double yy = categoryStart;
        int seriesCount = this.getRowCount();
        int categoryCount = this.getColumnCount();
        if (seriesCount > 1) {
            double seriesGap = dataArea.getWidth() * this.getItemMargin() / (double)(categoryCount * (seriesCount - 1));
            double usedWidth = state.getBarWidth() * (double)seriesCount + seriesGap * (double)(seriesCount - 1);
            double offset = (categoryWidth - usedWidth) / 2.0;
            yy = yy + offset + (double)row * (state.getBarWidth() + seriesGap);
        } else {
            double offset = (categoryWidth - state.getBarWidth()) / 2.0;
            yy += offset;
        }
        double yymid = yy + state.getBarWidth() / 2.0;
        Paint p = this.getItemPaint(row, column);
        if (p != null) {
            g2.setPaint(p);
        }
        Stroke s = this.getItemStroke(row, column);
        g2.setStroke(s);
        RectangleEdge location = plot.getRangeAxisEdge();
        Rectangle2D.Double box = null;
        Number xQ1 = bawDataset.getQ1Value(row, column);
        Number xQ3 = bawDataset.getQ3Value(row, column);
        Number xMax = bawDataset.getMaxRegularValue(row, column);
        Number xMin = bawDataset.getMinRegularValue(row, column);
        if (xQ1 != null && xQ3 != null && xMax != null && xMin != null) {
            double xxQ1 = rangeAxis.valueToJava2D(xQ1.doubleValue(), dataArea, location);
            double xxQ3 = rangeAxis.valueToJava2D(xQ3.doubleValue(), dataArea, location);
            double xxMax = rangeAxis.valueToJava2D(xMax.doubleValue(), dataArea, location);
            double xxMin = rangeAxis.valueToJava2D(xMin.doubleValue(), dataArea, location);
            g2.draw(new Line2D.Double(xxMax, yymid, xxQ3, yymid));
            g2.draw(new Line2D.Double(xxMax, yy, xxMax, yy + state.getBarWidth()));
            g2.draw(new Line2D.Double(xxMin, yymid, xxQ1, yymid));
            g2.draw(new Line2D.Double(xxMin, yy, xxMin, yy + state.getBarWidth()));
            box = new Rectangle2D.Double(Math.min(xxQ1, xxQ3), yy, Math.abs(xxQ1 - xxQ3), state.getBarWidth());
            if (this.getFillBox()) {
                g2.fill(box);
            }
            g2.draw(box);
        }
        g2.setPaint(this.getArtifactPaint());
        double aRadius = 2.0;
        double xxMean = 0.0;
        Number xMean = bawDataset.getMeanValue(row, column);
        if (xMean != null) {
            xxMean = rangeAxis.valueToJava2D(xMean.doubleValue(), dataArea, location);
            Ellipse2D.Double avgEllipse = new Ellipse2D.Double(xxMean - aRadius, yymid - aRadius, aRadius * 2.0, aRadius * 2.0);
            g2.fill(avgEllipse);
            g2.draw(avgEllipse);
        }
        Number xMedian = bawDataset.getMedianValue(row, column);
        double xxMedian = 0.0;
        if (xMedian != null) {
            xxMedian = rangeAxis.valueToJava2D(xMedian.doubleValue(), dataArea, location);
            g2.draw(new Line2D.Double(xxMedian, yy, xxMedian, yy + state.getBarWidth()));
        }
        if (box == null && xMedian != null) {
            box = new Rectangle2D.Double(xxMedian, yy, xxMedian, state.getBarWidth());
        }
        double oRadius = 2.0;
        double foRadius = 4.0;
        ArrayList<Outlier> outliers = new ArrayList<Outlier>();
        ArrayList<Outlier> farOutValues = new ArrayList<Outlier>();
        List xOutliers = bawDataset.getOutliers(row, column);
        if (xOutliers != null) {
            Point2D point;
            for (int i = 0; i < xOutliers.size(); ++i) {
                double xxOutlier;
                Outlier outlierToAdd;
                double outlier = ((Number)xOutliers.get(i)).doubleValue();
                Number minOutlier = bawDataset.getMinOutlier(row, column);
                Number maxOutlier = bawDataset.getMaxOutlier(row, column);
                Number minRegular = bawDataset.getMinRegularValue(row, column);
                Number maxRegular = bawDataset.getMaxRegularValue(row, column);
                if (outlier > maxOutlier.doubleValue() || outlier < minOutlier.doubleValue()) {
                    double xxFarout = rangeAxis.valueToJava2D(outlier, dataArea, location);
                    Outlier faroutToAdd = new Outlier(xxFarout + 2.0 * foRadius, yymid, foRadius);
                    if (!dataArea.contains(faroutToAdd.getPoint())) continue;
                    farOutValues.add(faroutToAdd);
                    continue;
                }
                if (!(outlier > maxRegular.doubleValue()) && !(outlier < minRegular.doubleValue()) || !dataArea.contains((outlierToAdd = new Outlier(xxOutlier = rangeAxis.valueToJava2D(outlier, dataArea, location), yymid, oRadius)).getPoint())) continue;
                outliers.add(outlierToAdd);
            }
            g2.setPaint(this.outlierPaint);
            for (Outlier outlier : outliers) {
                point = outlier.getPoint();
                Shape dot = this.createEllipse(point, oRadius);
                g2.draw(dot);
            }
            g2.setPaint(this.faroutPaint);
            for (Outlier outlier : farOutValues) {
                point = outlier.getPoint();
                Shape triangle = this.createTriangleHorizontal(point, foRadius);
                g2.draw(triangle);
            }
        }
        if (state.getInfo() != null && (entities = state.getEntityCollection()) != null) {
            Point2D point;
            int i;
            if (box != null) {
                this.addItemEntity(entities, dataset, row, column, box);
            }
            for (i = 0; i < outliers.size(); ++i) {
                Outlier outlier = (Outlier)outliers.get(i);
                point = outlier.getPoint();
                Shape dot = this.createEllipse(point, oRadius);
                String outlierTooltip = "Outlier : ";
                double outlierX = rangeAxis.java2DToValue(outlier.getX() + oRadius, dataArea, location);
                outlierTooltip = outlierTooltip.concat(Double.toString(outlierX));
                this.addOutlierEntity(outlierTooltip, entities, dataset, row, column, dot);
            }
            for (i = 0; i < farOutValues.size(); ++i) {
                Outlier farout = (Outlier)farOutValues.get(i);
                point = farout.getPoint();
                Shape triangle = this.createTriangleHorizontal(point, foRadius);
                String faroutTooltip = "Farout : ";
                double faroutX = rangeAxis.java2DToValue(farout.getX() - foRadius, dataArea, location);
                faroutTooltip = faroutTooltip.concat(Double.toString(faroutX));
                this.addFaroutEntity(faroutTooltip, entities, dataset, row, column, triangle);
            }
        }
    }

    private Shape createEllipse(Point2D point, double oRadius) {
        Ellipse2D.Double dot = new Ellipse2D.Double(point.getX(), point.getY(), oRadius * 2.0, oRadius * 2.0);
        return dot;
    }

    private Shape createTriangleVertical(Point2D point, double foRadius) {
        double side = foRadius * 2.0;
        double x = point.getX();
        double y = point.getY();
        int[] xpoints = new int[]{(int)x, (int)(x + side), (int)(x + side / 2.0)};
        int[] ypoints = new int[]{(int)y, (int)y, (int)(y + side)};
        return new Polygon(xpoints, ypoints, 3);
    }

    private Shape createTriangleHorizontal(Point2D point, double foRadius) {
        double side = foRadius * 2.0;
        double x = point.getX();
        double y = point.getY();
        int[] xpoints = new int[]{(int)x, (int)x, (int)(x - side)};
        int[] ypoints = new int[]{(int)y, (int)(y + side), (int)(y + side / 2.0)};
        return new Polygon(xpoints, ypoints, 3);
    }

    public void addOutlierEntity(String tooltip, EntityCollection entities, CategoryDataset dataset, int row, int column, Shape hotspot) {
        String url = null;
        if (this.getItemURLGenerator(row, column) != null) {
            url = this.getItemURLGenerator(row, column).generateURL(dataset, row, column);
        }
        OutlierEntity entity = new OutlierEntity(hotspot, tooltip, url);
        entities.add(entity);
    }

    public void addFaroutEntity(String tooltip, EntityCollection entities, CategoryDataset dataset, int row, int column, Shape hotspot) {
        String url = null;
        if (this.getItemURLGenerator(row, column) != null) {
            url = this.getItemURLGenerator(row, column).generateURL(dataset, row, column);
        }
        FaroutEntity entity = new FaroutEntity(hotspot, tooltip, url);
        entities.add(entity);
    }
}

