/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.file;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.statcato.DialogEdit;
import org.statcato.LogWindow;
import org.statcato.Statcato;
import org.statcato.file.ExtensionFileFilter;
import org.statcato.file.FileChooserUtils;
import org.statcato.file.Project;
import org.statcato.spreadsheet.Spreadsheet;
import org.statcato.utils.HelperFunctions;

public class FileOperations {
    private static File recentDatasheet = null;
    private static File recentProject = null;
    private static ExtensionFileFilter excelFilter = new ExtensionFileFilter("Excel (*.xls)", "xls");
    private static ExtensionFileFilter csvFilter = new ExtensionFileFilter("Comma-separated values(*.csv)", "csv");
    private static ExtensionFileFilter txtFilter = new ExtensionFileFilter("Tab-delimited values (*.txt)", "txt");
    private static ExtensionFileFilter stcFilter = new ExtensionFileFilter("Statcato Project File (.stc)", Project.extension);

    public static void openLogFile(Statcato app) {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new ExtensionFileFilter("HTML", "html"));
        fc.setAcceptAllFileFilterUsed(false);
        LogWindow LogTextPane = app.getLogTextPane();
        int returnValue = fc.showOpenDialog(app);
        if (returnValue == 0) {
            File file = fc.getSelectedFile();
            String contents = HelperFunctions.getFileContents(file);
            Object[] options = new Object[]{"Overwrite", "append"};
            int choice = JOptionPane.showOptionDialog(app, "Would you like to overwrite the current log window with the file you are opening, or append file contents to current log window", "Load Log Window", 0, 3, null, options, options[1]);
            if (choice == 0) {
                app.compoundEdit = new DialogEdit("overwrite log");
                LogTextPane.addHeading("Open saved log window (overwrite): " + file.getName());
                LogTextPane.overwrite(contents);
                app.compoundEdit.end();
                app.addCompoundEdit(app.compoundEdit);
            } else {
                contents = "<br><hr><br>" + contents;
                app.compoundEdit = new DialogEdit("append log");
                LogTextPane.addHeading("Open saved log window (append): " + file.getName());
                LogTextPane.addText(contents);
                app.compoundEdit.end();
                app.addCompoundEdit(app.compoundEdit);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void openDatasheet(Statcato app) {
        int returnValue;
        JFileChooser fc = new JFileChooser(recentDatasheet == null ? null : recentDatasheet.getParentFile());
        fc.addChoosableFileFilter(excelFilter);
        fc.addChoosableFileFilter(csvFilter);
        fc.addChoosableFileFilter(txtFilter);
        fc.setAcceptAllFileFilterUsed(false);
        if (recentDatasheet != null) {
            if (FileChooserUtils.getExtension(recentDatasheet).equals("xls")) {
                fc.setFileFilter(excelFilter);
            } else if (FileChooserUtils.getExtension(recentDatasheet).equals("csv")) {
                fc.setFileFilter(csvFilter);
            } else {
                fc.setFileFilter(txtFilter);
            }
        }
        if ((returnValue = fc.showOpenDialog(app)) != 0) return;
        File file = fc.getSelectedFile();
        if (file == null || !file.isFile()) {
            app.showErrorDialog("Error opening datasheet");
            return;
        }
        if (FileChooserUtils.getExtension(file).equals("xls")) {
            Vector<String> sheets = HelperFunctions.readExcelFile(file);
            if (sheets == null) {
                app.showErrorDialog("Error reading excel file.");
                return;
            }
            Enumeration<String> e = sheets.elements();
            while (e.hasMoreElements()) {
                String str = e.nextElement();
                if (str.trim().equals("")) continue;
                app.getDatasheetTabbedPane().addDatasheet(str, null);
            }
        } else {
            String contents = HelperFunctions.getFileContents(file);
            if (FileChooserUtils.getExtension(file).equals("csv")) {
                contents = HelperFunctions.parseCSV(contents);
            }
            app.getDatasheetTabbedPane().addDatasheet(contents, file);
        }
        recentDatasheet = file;
    }

    public static void openProjectFile(Statcato app) {
        JFileChooser fc = new JFileChooser(recentProject == null ? null : recentProject.getParentFile());
        fc.addChoosableFileFilter(stcFilter);
        fc.setAcceptAllFileFilterUsed(false);
        Project project = app.getProject();
        int returnValue = fc.showOpenDialog(app);
        if (returnValue == 0) {
            File file = fc.getSelectedFile();
            if (file == null || !file.isFile()) {
                app.showErrorDialog("Error opening project file");
            } else {
                if (!project.readFile(file.getPath())) {
                    app.showErrorDialog("Error opening project file");
                }
                recentProject = file;
            }
        }
    }

    public static void saveDatasheet(Statcato app, boolean isSaveAs) {
        Spreadsheet table = app.getSpreadsheet();
        File file = table.writeToFile(app, isSaveAs);
        if (file != null) {
            app.getDatasheetTabbedPane().setCurrentTabTitle(file.getName());
            app.setStatus("Datasheet saved to " + file.getName() + ".");
            app.setClearStatusTimer(3);
            recentDatasheet = file;
        }
    }

    public static void saveProject(Statcato app, boolean isSaveAs) {
        if (app.getProject().writeToFile(isSaveAs)) {
            app.setTitle("Statcato - " + app.getProject().getName());
            app.setStatus("Project saved to " + app.getProject().getName() + ".");
            app.setClearStatusTimer(3);
            recentProject = app.getProject().getFile();
        } else {
            app.showErrorDialog("Failed to save project file");
        }
    }

    public static File getRecentDatasheet() {
        return recentDatasheet;
    }

    public static File getRecentProject() {
        return recentProject;
    }
}

