/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.ci;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.inferential.CIOnePopMeanSigmaKnown;
import org.statcato.statistics.inferential.CIOnePopMeanSigmaUnknown;
import org.statcato.statistics.inferential.ConfidenceInterval;
import org.statcato.utils.HelperFunctions;

public class CI1PopMeanDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JTextField ConfidenceTextField;
    private JTextField InputTextField;
    private JRadioButton KnownRadioButton;
    private JButton OKButton;
    private JLabel SampleMeanLabel;
    private JTextField SampleMeanTextField;
    private JRadioButton SampleRadioButton;
    private JLabel SampleSizeLabel;
    private JTextField SampleSizeTextField;
    private JTextField SigmaTextField;
    private JRadioButton SummaryRadioButton;
    private JRadioButton UnknownRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel sLabel;
    private JTextField sTextField;

    public CI1PopMeanDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.initComponents();
        this.app = mTab;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.SampleRadioButton);
        group1.add(this.SummaryRadioButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.KnownRadioButton);
        group2.add(this.UnknownRadioButton);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-ci-1mean");
        this.name = "Confidence Interval: One Population Mean";
        this.description = "For computing the confidence intervals for a population mean in one population, whether the population standard deviation is known or unknown. ";
        this.helpStrings.add("If your sample data is available in one column, select the Samples in column: radio button, and select the column name in the given drop-down menu.");
        this.helpStrings.add("If individual sample data is not available, select the Summarized sample data radio button and provide the sample size, mean, and standard deviation (only if population standard deviation is unknown).");
        this.helpStrings.add("Enter the confidence level (between 0 and 1).");
    }

    @Override
    public void updateElements() {
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel2 = new JPanel();
        this.UnknownRadioButton = new JRadioButton();
        this.KnownRadioButton = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.SigmaTextField = new JTextField();
        this.jPanel1 = new JPanel();
        this.sTextField = new JTextField();
        this.SampleSizeTextField = new JTextField();
        this.sLabel = new JLabel();
        this.SampleRadioButton = new JRadioButton();
        this.SampleSizeLabel = new JLabel();
        this.SampleMeanTextField = new JTextField();
        this.SummaryRadioButton = new JRadioButton();
        this.SampleMeanLabel = new JLabel();
        this.InputTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel1 = new JLabel();
        this.ConfidenceTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Confidence Interval: One Population Mean");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CI1PopMeanDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CI1PopMeanDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Population Standard Deviation"));
        this.UnknownRadioButton.setSelected(true);
        this.UnknownRadioButton.setText("Unknown");
        this.UnknownRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI1PopMeanDialog.this.UnknownRadioButtonStateChanged(evt);
            }
        });
        this.KnownRadioButton.setText("Known:");
        this.KnownRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI1PopMeanDialog.this.KnownRadioButtonStateChanged(evt);
            }
        });
        this.jLabel4.setText("Population standard deviation:");
        this.SigmaTextField.setEnabled(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.UnknownRadioButton).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.KnownRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigmaTextField, -2, 73, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SigmaTextField, -2, -1, -2).addComponent(this.KnownRadioButton)).addGap(5, 5, 5).addComponent(this.UnknownRadioButton).addContainerGap()));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.sTextField.setEnabled(false);
        this.SampleSizeTextField.setEnabled(false);
        this.sLabel.setText("Standard deviation:");
        this.sLabel.setEnabled(false);
        this.SampleRadioButton.setSelected(true);
        this.SampleRadioButton.setText("Samples in column:");
        this.SampleRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI1PopMeanDialog.this.SampleRadioButtonStateChanged(evt);
            }
        });
        this.SampleSizeLabel.setText("Size:");
        this.SampleSizeLabel.setEnabled(false);
        this.SampleMeanTextField.setEnabled(false);
        this.SummaryRadioButton.setText("Summarized sample data:");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CI1PopMeanDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        this.SampleMeanLabel.setText("Mean:");
        this.SampleMeanLabel.setEnabled(false);
        this.jLabel8.setText("<html> Enter valid column names separated by space.<br> For a continuous range of columns, separate using dash (e.g. C1-C30).<br> </html> ");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SampleRadioButton).addComponent(this.InputTextField, -2, 147, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.SummaryRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addGap(13, 13, 13).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SampleMeanLabel).addComponent(this.SampleSizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.SampleSizeTextField, -1, 121, Short.MAX_VALUE).addComponent(this.SampleMeanTextField).addComponent(this.sTextField))).addComponent(this.sLabel)))).addContainerGap()).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8, -2, 209, -2).addContainerGap(298, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.SampleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.InputTextField, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.SummaryRadioButton).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SampleSizeLabel).addComponent(this.SampleSizeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.SampleMeanLabel).addComponent(this.SampleMeanTextField, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sTextField, -2, -1, -2).addContainerGap()).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(61, 61, 61).addComponent(this.jLabel8, -1, 179, Short.MAX_VALUE).addContainerGap())));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Confidence"));
        this.jLabel6.setText("Confidence level:");
        this.jLabel1.setText("0 - 1.00 (e.g. 0.95)");
        this.ConfidenceTextField.setText("0.95");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ConfidenceTextField, -2, 81, -2).addGap(10, 10, 10).addComponent(this.jLabel1).addContainerGap(183, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.ConfidenceTextField, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(96, 96, 96).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void SampleRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SampleRadioButton.isSelected()) {
            this.InputTextField.setEnabled(true);
        } else {
            this.InputTextField.setEnabled(false);
        }
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.SampleSizeLabel.setEnabled(true);
            this.SampleSizeTextField.setEnabled(true);
            this.SampleMeanLabel.setEnabled(true);
            this.SampleMeanTextField.setEnabled(true);
            if (this.UnknownRadioButton.isSelected()) {
                this.sLabel.setEnabled(true);
                this.sTextField.setEnabled(true);
            } else {
                this.sLabel.setEnabled(false);
                this.sTextField.setEnabled(false);
            }
        } else {
            this.SampleSizeLabel.setEnabled(false);
            this.SampleSizeTextField.setEnabled(false);
            this.SampleMeanLabel.setEnabled(false);
            this.SampleMeanTextField.setEnabled(false);
            this.sLabel.setEnabled(false);
            this.sTextField.setEnabled(false);
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        double confidenceLevel;
        this.app.compoundEdit = new DialogEdit("CI 1 mean");
        int n = 0;
        double s = 0.0;
        double mean = 0.0;
        Vector<ConfidenceInterval> vectorsCI = new Vector<ConfidenceInterval>();
        Vector<String> labels = new Vector<String>();
        double stdev = 0.0;
        String heading = "Confidence Interval - One population mean:";
        String text = "";
        try {
            confidenceLevel = Double.parseDouble(this.ConfidenceTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        heading = heading + "  confidence level = " + confidenceLevel;
        if (this.KnownRadioButton.isSelected()) {
            text = text + "<b>&sigma; known</b><br>";
            try {
                stdev = Double.parseDouble(this.SigmaTextField.getText());
                text = text + "Assumed population standard deviation &sigma; = " + stdev + "<br>";
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid population standard deviation.");
                return;
            }
        }
        if (this.SampleRadioButton.isSelected()) {
            if (this.InputTextField.getText().length() == 0) {
                this.app.showErrorDialog("No input column is provided.");
                return;
            }
            int[] inputColumnNumbers = this.ParentSpreadsheet.getColumnNumbersArrayFromString(this.InputTextField.getText());
            if (inputColumnNumbers.length == 0) {
                this.app.showErrorDialog("Invalid input column name(s).");
                return;
            }
            text = text + "Input: ";
            for (int i = 0; i < inputColumnNumbers.length; ++i) {
                Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(inputColumnNumbers[i]);
                String columnLabel = this.ParentSpreadsheet.getColumnFullLabel(inputColumnNumbers[i]);
                Vector<Double> ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
                if (ColumnVector == null) {
                    this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                    return;
                }
                if (HelperFunctions.isEmptyVector(ColumnVector)) {
                    this.app.showErrorDialog("Empty input column " + columnLabel + ".");
                    return;
                }
                text = text + columnLabel + " ";
                n = BasicStatistics.Nnonmissing(ColumnVector);
                mean = BasicStatistics.mean(ColumnVector);
                s = BasicStatistics.stdev(ColumnVector);
                if (this.KnownRadioButton.isSelected()) {
                    vectorsCI.addElement(new CIOnePopMeanSigmaKnown(confidenceLevel, n, mean, stdev));
                } else {
                    vectorsCI.addElement(new CIOnePopMeanSigmaUnknown(confidenceLevel, n, mean, s));
                }
                labels.addElement(columnLabel);
            }
            text = text + "<br>";
        } else {
            try {
                n = Integer.parseInt(this.SampleSizeTextField.getText());
                mean = Double.parseDouble(this.SampleMeanTextField.getText());
                if (this.UnknownRadioButton.isSelected()) {
                    stdev = Double.parseDouble(this.sTextField.getText());
                }
                if (this.KnownRadioButton.isSelected()) {
                    vectorsCI.addElement(new CIOnePopMeanSigmaKnown(confidenceLevel, n, mean, stdev));
                } else {
                    vectorsCI.addElement(new CIOnePopMeanSigmaUnknown(confidenceLevel, n, mean, stdev));
                }
                labels.addElement("summary");
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Invalid summary data.");
                return;
            }
            text = text + "Input: Summary data<br>";
        }
        if (this.KnownRadioButton.isSelected()) {
            text = text + "<br><table border='1'>";
            text = text + "<tr><td>Var</td><td>N</td><td>Mean</td><td>Margin of Error</td><td>";
            text = text + HelperFunctions.formatFloat(confidenceLevel * 100.0, 2) + "%CI</td></tr>";
            for (int i = 0; i < vectorsCI.size(); ++i) {
                CIOnePopMeanSigmaKnown CI = (CIOnePopMeanSigmaKnown)vectorsCI.elementAt(i);
                text = text + "<tr>";
                text = text + "<td>" + (String)labels.elementAt(i) + "</td><td>" + CI.getN() + "</td><td>" + HelperFunctions.formatFloat(CI.center(), 3) + "</td><td>" + HelperFunctions.formatFloat(CI.marginOfError(), 3) + "</td><td>" + CI.toString() + "</td></tr>";
            }
            text = text + "</table>";
        } else {
            text = text + "<b>&sigma; unknown</b><br>";
            text = text + "<br><table border='1'>";
            text = text + "<tr><td>Var</td><td>N</td><td>Mean</td><td>Stdev</td><td>Margin of Error</td><td>";
            text = text + HelperFunctions.formatFloat(confidenceLevel * 100.0, 2) + "%CI</td></tr>";
            for (int i = 0; i < vectorsCI.size(); ++i) {
                CIOnePopMeanSigmaUnknown CI2 = (CIOnePopMeanSigmaUnknown)vectorsCI.elementAt(i);
                text = text + "<tr>";
                text = text + "<td>" + (String)labels.elementAt(i) + "</td><td>" + CI2.getN() + "</td><td>" + HelperFunctions.formatFloat(CI2.center(), 3) + "</td><td>" + HelperFunctions.formatFloat(CI2.getStdev(), 3) + "</td><td>" + HelperFunctions.formatFloat(CI2.marginOfError(), 3) + "</td><td>" + CI2.toString() + "</td></tr>";
            }
            text = text + "</table>";
        }
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void KnownRadioButtonStateChanged(ChangeEvent evt) {
        if (this.KnownRadioButton.isSelected()) {
            this.SigmaTextField.setEnabled(true);
        } else {
            this.SigmaTextField.setEnabled(false);
        }
    }

    private void UnknownRadioButtonStateChanged(ChangeEvent evt) {
        if (this.UnknownRadioButton.isSelected()) {
            if (this.SummaryRadioButton.isSelected()) {
                this.sLabel.setEnabled(true);
                this.sTextField.setEnabled(true);
            } else {
                this.sLabel.setEnabled(false);
                this.sTextField.setEnabled(false);
            }
        } else {
            this.sLabel.setEnabled(false);
            this.sTextField.setEnabled(false);
        }
    }
}

