/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.graph;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.graph.GraphFactory;
import org.statcato.graph.StatcatoChartFrame;
import org.statcato.spreadsheet.Cell;
import org.statcato.utils.HelperFunctions;

public class ScatterplotDialog
extends StatcatoDialog {
    private JButton AddButton;
    private JButton CancelButton;
    private JRadioButton CubicRegRadioButton;
    private JRadioButton ExpRegRadioButton;
    private JRadioButton FixedPowRegRadioButton;
    private JCheckBox LegendCheckBox;
    private JRadioButton LinRegRadioButton;
    private JCheckBox LineCheckBox;
    private JRadioButton LogRegRadioButton;
    private JButton OKButton;
    private JRadioButton PolyRegRadioButton;
    private JTextField PolyTextField;
    private JTextField PolyTextField2;
    private JRadioButton PowRegRadioButton;
    private JRadioButton QuadRegRadioButton;
    private JPanel RegPanel;
    private JButton RemoveButton;
    private JList SeriesList;
    private JTextField TitleTextField;
    private JComboBox XComboBox;
    private JTextField XTextField;
    private JComboBox YComboBox;
    private JTextField YTextField;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public ScatterplotDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("graph-scatterplot");
        this.name = "Scatterplot";
        this.description = "For creating scatterplots showing a collection of points on an x-y plane in cartesian coordinates.";
        this.helpStrings.add("To add a series of (x, y) points to the plot, select the column variable containing the x coordinates and the column variable containing the y coordinates,then click the Add Series button. ");
        this.helpStrings.add("Enter a plot title and labels for the x and y axis in the corresponding text fields.");
        this.helpStrings.add("Select whether to show a legend and a regression line.");
        this.pack();
    }

    private void customInitComponents() {
        this.ParentSpreadsheet.populateComboBox(this.XComboBox);
        this.ParentSpreadsheet.populateComboBox(this.YComboBox);
        this.SeriesList.setSelectionMode(0);
        ButtonGroup group = new ButtonGroup();
        group.add(this.LinRegRadioButton);
        group.add(this.QuadRegRadioButton);
        group.add(this.CubicRegRadioButton);
        group.add(this.PolyRegRadioButton);
        group.add(this.LogRegRadioButton);
        group.add(this.PowRegRadioButton);
        group.add(this.FixedPowRegRadioButton);
        group.add(this.ExpRegRadioButton);
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.XComboBox);
        this.updateComboBox(this.YComboBox);
        this.clearMutableColumnsList(this.SeriesList);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.SeriesList = new JList(new DefaultListModel());
        this.jLabel4 = new JLabel();
        this.RemoveButton = new JButton();
        this.YComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.XComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.AddButton = new JButton();
        this.jLabel8 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.LegendCheckBox = new JCheckBox();
        this.YTextField = new JTextField();
        this.TitleTextField = new JTextField();
        this.XTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.LineCheckBox = new JCheckBox();
        this.RegPanel = new JPanel();
        this.LinRegRadioButton = new JRadioButton();
        this.QuadRegRadioButton = new JRadioButton();
        this.CubicRegRadioButton = new JRadioButton();
        this.PolyRegRadioButton = new JRadioButton();
        this.jLabel9 = new JLabel();
        this.PolyTextField = new JTextField();
        this.LogRegRadioButton = new JRadioButton();
        this.PowRegRadioButton = new JRadioButton();
        this.jLabel10 = new JLabel();
        this.PolyTextField2 = new JTextField();
        this.FixedPowRegRadioButton = new JRadioButton();
        this.ExpRegRadioButton = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Scatterplot");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScatterplotDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScatterplotDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Graph Variables"));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Graph X,Y Series");
        this.SeriesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ScatterplotDialog.this.SeriesListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.SeriesList);
        this.jLabel4.setText("y variable:");
        this.RemoveButton.setText("Remove Series");
        this.RemoveButton.setEnabled(false);
        this.RemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScatterplotDialog.this.RemoveButtonActionPerformed(evt);
            }
        });
        this.YComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ScatterplotDialog.this.YComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel2.setText("Select the X and Y variable of a new series:");
        this.XComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ScatterplotDialog.this.XComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel3.setText("X variable:");
        this.AddButton.setText("Add Series");
        this.AddButton.setEnabled(false);
        this.AddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScatterplotDialog.this.AddButtonActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Select the series to be removed:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 103, -2).addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.RemoveButton).addComponent(this.jLabel8).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.XComboBox, -2, 176, -2).addComponent(this.YComboBox, -2, 177, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.AddButton)).addComponent(this.jLabel2))).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.XComboBox, this.YComboBox);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.XComboBox, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.YComboBox, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.AddButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RemoveButton)).addComponent(this.jScrollPane1, -1, 133, Short.MAX_VALUE)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Graph Options"));
        this.jLabel6.setText("Plot Title:");
        this.jLabel7.setText("X-axis Label:");
        this.LegendCheckBox.setSelected(true);
        this.LegendCheckBox.setText("Show legend");
        this.TitleTextField.setText("Scatterplot");
        this.jLabel5.setText("Y-axis Label:");
        this.LineCheckBox.setSelected(true);
        this.LineCheckBox.setText("Show regression curve");
        this.LineCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ScatterplotDialog.this.LineCheckBoxStateChanged(evt);
            }
        });
        this.LinRegRadioButton.setSelected(true);
        this.LinRegRadioButton.setText("Linear: y = ax+b");
        this.QuadRegRadioButton.setText("<html>Quadratic: y = ax<sup>2</sup> + bx + c</html>");
        this.CubicRegRadioButton.setText("<html>Cubic: y=ax<sup>3</sup> + bx<sup>2</sup> + cx + d</html>");
        this.PolyRegRadioButton.setText("<html>Polynomial: y = ax<sup>n</sup> + bx<sup>n-1</sup>+ cx<sup>n-2</sup> + ...</html>");
        this.jLabel9.setText("n = ");
        this.PolyTextField.setText("4");
        this.PolyTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ScatterplotDialog.this.PolyTextFieldFocusGained(evt);
            }
        });
        this.LogRegRadioButton.setText("Logarithmic: y = a lnx + b");
        this.PowRegRadioButton.setText("<html>Power: y = a x<sup>b</sup></html>");
        this.jLabel10.setText("n = ");
        this.PolyTextField2.setText("-1");
        this.PolyTextField2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ScatterplotDialog.this.PolyTextField2FocusGained(evt);
            }
        });
        this.FixedPowRegRadioButton.setText("<html>Fixed Power: y = a x<sup>n</sup></html>");
        this.ExpRegRadioButton.setText("<html>Exponential: y = a b<sup>x</sup></html>");
        GroupLayout RegPanelLayout = new GroupLayout(this.RegPanel);
        this.RegPanel.setLayout(RegPanelLayout);
        RegPanelLayout.setHorizontalGroup(RegPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RegPanelLayout.createSequentialGroup().addGroup(RegPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(RegPanelLayout.createSequentialGroup().addGroup(RegPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.LinRegRadioButton).addComponent(this.QuadRegRadioButton, -2, -1, -2).addComponent(this.CubicRegRadioButton, -2, -1, -2).addComponent(this.PolyRegRadioButton, -2, -1, -2)).addGap(27, 27, 27).addGroup(RegPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.PowRegRadioButton, -2, -1, -2).addComponent(this.LogRegRadioButton).addComponent(this.ExpRegRadioButton, -2, -1, -2).addComponent(this.FixedPowRegRadioButton, -2, -1, -2))).addGroup(RegPanelLayout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.PolyTextField, -2, 58, -2).addGap(162, 162, 162).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PolyTextField2, -2, 61, -2).addGap(53, 53, 53))).addContainerGap(151, Short.MAX_VALUE)));
        RegPanelLayout.setVerticalGroup(RegPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RegPanelLayout.createSequentialGroup().addGroup(RegPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LinRegRadioButton).addComponent(this.LogRegRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RegPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.QuadRegRadioButton, -2, -1, -2).addComponent(this.PowRegRadioButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RegPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CubicRegRadioButton, -2, -1, -2).addComponent(this.ExpRegRadioButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RegPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PolyRegRadioButton, -2, -1, -2).addComponent(this.FixedPowRegRadioButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(RegPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.PolyTextField, -2, -1, -2).addComponent(this.PolyTextField2, -2, -1, -2).addComponent(this.jLabel10)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.XTextField, -2, 279, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.TitleTextField, GroupLayout.Alignment.LEADING, -2, 279, -2).addComponent(this.YTextField, -2, 279, -2)).addGap(325, 325, 325)))).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.LegendCheckBox)).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.LineCheckBox))).addContainerGap()).addGroup(jPanel2Layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.RegPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.TitleTextField, this.XTextField, this.YTextField);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.XTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.YTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.TitleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LegendCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LineCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RegPanel, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(176, 176, 176).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.CancelButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE).addGap(4, 4, 4).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.OKButton)).addGap(8, 8, 8)));
        this.pack();
    }

    private void XComboBoxItemStateChanged(ItemEvent evt) {
        if (this.XComboBox.getSelectedIndex() == 0 || this.YComboBox.getSelectedIndex() == 0) {
            this.AddButton.setEnabled(false);
        } else {
            this.AddButton.setEnabled(true);
        }
    }

    private void YComboBoxItemStateChanged(ItemEvent evt) {
        if (this.XComboBox.getSelectedIndex() == 0 || this.YComboBox.getSelectedIndex() == 0) {
            this.AddButton.setEnabled(false);
        } else {
            this.AddButton.setEnabled(true);
        }
    }

    private void AddButtonActionPerformed(ActionEvent evt) {
        if (this.XComboBox.getSelectedIndex() == 0) {
            this.app.showErrorDialog("Select x variable of the new series.");
            return;
        }
        if (this.YComboBox.getSelectedIndex() == 0) {
            this.app.showErrorDialog("Select y variable of the new series.");
            return;
        }
        String x = this.XComboBox.getSelectedItem().toString();
        String y = this.YComboBox.getSelectedItem().toString();
        ((DefaultListModel)this.SeriesList.getModel()).addElement(x.trim() + "," + y.trim());
    }

    private void SeriesListValueChanged(ListSelectionEvent evt) {
        if (this.SeriesList.getSelectedIndex() != -1) {
            this.RemoveButton.setEnabled(true);
        } else {
            this.RemoveButton.setEnabled(false);
        }
    }

    private void RemoveButtonActionPerformed(ActionEvent evt) {
        if (this.SeriesList.getSelectedValue() != null) {
            ((DefaultListModel)this.SeriesList.getModel()).removeElementAt(this.SeriesList.getSelectedIndex());
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        JFreeChart chart;
        this.app.compoundEdit = new DialogEdit("scatterplot");
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        double min = 0.0;
        double max = 0.0;
        if (this.SeriesList.getModel().getSize() == 0) {
            this.app.showErrorDialog("Add at least one series.");
            return;
        }
        String text = "";
        for (int i = 0; i < this.SeriesList.getModel().getSize(); ++i) {
            String xy = (String)this.SeriesList.getModel().getElementAt(i);
            text = text + "Series: " + xy + "<br>";
            String[] items = xy.split(",");
            int selectedXColumn = this.ParentSpreadsheet.parseColumnNumber(items[0]);
            int selectedYColumn = this.ParentSpreadsheet.parseColumnNumber(items[1]);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(selectedXColumn);
            Vector<Double> XColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (XColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + items[0] + ": all data must be numbers.");
                return;
            }
            XColumnVector = HelperFunctions.removeNullValues(XColumnVector);
            StrColumnVector = this.ParentSpreadsheet.getColumn(selectedYColumn);
            Vector<Double> YColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (YColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + items[1] + ": all data must be numbers.");
                return;
            }
            YColumnVector = HelperFunctions.removeNullValues(YColumnVector);
            if (XColumnVector.size() != YColumnVector.size()) {
                this.app.showErrorDialog("The number of x values must be the same as the number of y values.");
                return;
            }
            XYSeries series = new XYSeries((Comparable)((Object)xy));
            for (int j = 0; j < XColumnVector.size(); ++j) {
                double x = XColumnVector.elementAt(j);
                if (x < min) {
                    min = x;
                }
                if (x > max) {
                    max = x;
                }
                series.add(x, YColumnVector.elementAt(j));
            }
            seriesCollection.addSeries(series);
        }
        int regressionType = 0;
        double regressionArg = 0.0;
        if (this.LineCheckBox.isSelected()) {
            if (this.LinRegRadioButton.isSelected()) {
                regressionType = 1;
            } else if (this.QuadRegRadioButton.isSelected()) {
                regressionType = 2;
            } else if (this.CubicRegRadioButton.isSelected()) {
                regressionType = 3;
            } else {
                if (this.PolyRegRadioButton.isSelected()) {
                    regressionType = 4;
                    try {
                        int n = Integer.parseInt(this.PolyTextField.getText());
                        if (n <= 0) {
                            throw new NumberFormatException();
                        }
                        regressionArg = n;
                    }
                    catch (NumberFormatException e) {
                        this.app.showErrorDialog("Enter a positive integer for the degree of the polynomial model");
                        return;
                    }
                }
                if (this.LogRegRadioButton.isSelected()) {
                    regressionType = 5;
                } else if (this.PowRegRadioButton.isSelected()) {
                    regressionType = 6;
                } else {
                    if (this.FixedPowRegRadioButton.isSelected()) {
                        regressionType = 7;
                        try {
                            double n;
                            regressionArg = n = Double.parseDouble(this.PolyTextField2.getText());
                        }
                        catch (NumberFormatException e) {
                            this.app.showErrorDialog("Enter a real number for the degree of the fixed power model");
                            return;
                        }
                    }
                    if (this.ExpRegRadioButton.isSelected()) {
                        regressionType = 8;
                        try {
                            double n;
                            regressionArg = n = Double.parseDouble(this.PolyTextField2.getText());
                        }
                        catch (NumberFormatException e) {
                            this.app.showErrorDialog("Enter a real number for the degree of the fixed power model");
                            return;
                        }
                    }
                }
            }
        }
        if ((chart = GraphFactory.createScatterplot(seriesCollection, this.TitleTextField.getText(), this.XTextField.getText(), this.YTextField.getText(), this.LegendCheckBox.isSelected(), regressionType, regressionArg, min, max)) == null) {
            this.app.showErrorDialog("Error creating scatterplot. Check input data.");
            return;
        }
        this.app.addLogParagraph("Scatterplot", text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        StatcatoChartFrame frame = new StatcatoChartFrame(this.TitleTextField.getText(), chart, this.app);
        frame.pack();
        frame.setVisible(true);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void LineCheckBoxStateChanged(ChangeEvent evt) {
        if (this.LineCheckBox.isSelected()) {
            this.RegPanel.setVisible(true);
        } else {
            this.RegPanel.setVisible(false);
        }
        this.pack();
    }

    private void PolyTextFieldFocusGained(FocusEvent evt) {
        this.PolyRegRadioButton.setSelected(true);
    }

    private void PolyTextField2FocusGained(FocusEvent evt) {
        this.FixedPowRegRadioButton.setSelected(true);
    }
}

