/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.data;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;

public class TransposeDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JRadioButton ColRowRadioButton;
    private JTextField ColTextField;
    private JButton OKButton;
    private JRadioButton RowColRadioButton;
    private JTextField RowTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public TransposeDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.initComponents();
        ButtonGroup group = new ButtonGroup();
        group.add(this.RowColRadioButton);
        group.add(this.ColRowRadioButton);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("data-transpose");
        this.name = "Transpose Row/Column Data";
        this.description = "For converting a column of data to a row of data, and vice versa.";
        this.helpStrings.add("Enter the row or column name of data to be transposed.");
    }

    @Override
    public void updateElements() {
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.ColRowRadioButton = new JRadioButton();
        this.RowColRadioButton = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.RowTextField = new JTextField();
        this.ColTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Transpose");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransposeDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransposeDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Type"));
        this.ColRowRadioButton.setSelected(true);
        this.ColRowRadioButton.setText("Column to Row");
        this.RowColRadioButton.setText("Row to Column");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ColRowRadioButton).addComponent(this.RowColRadioButton)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ColRowRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addGap(38, 38, 38).addComponent(this.RowColRadioButton))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.jLabel2.setText("Row:");
        this.jLabel1.setText("Column:");
        this.jLabel1.setToolTipText("");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ColTextField, -2, 94, -2).addComponent(this.RowTextField)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.ColTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.RowTextField, -2, -1, -2)).addContainerGap(31, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap(20, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(93, Short.MAX_VALUE).addComponent(this.OKButton).addGap(18, 18, 18).addComponent(this.CancelButton).addGap(85, 85, 85)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGap(36, 36, 36).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addGap(35, 35, 35)));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("tranpose");
        String column = this.ColTextField.getText();
        int columnNum = this.ParentSpreadsheet.getColumnNumber(column);
        if (columnNum == -1) {
            this.app.showErrorDialog("Enter a valid column name (e.g. C1) or a valid variable name to store the results.");
            return;
        }
        String row = this.RowTextField.getText();
        int rowNum = this.ParentSpreadsheet.getRowNumber(row);
        if (rowNum == -1) {
            this.app.showErrorDialog("Enter a valid row number.");
            return;
        }
        if (this.ColRowRadioButton.isSelected()) {
            Vector<Cell> CellColumnVector = this.ParentSpreadsheet.getColumn(columnNum);
            this.ParentSpreadsheet.setCellRow(rowNum, CellColumnVector);
            this.app.addLogParagraph("Transpose " + column + " -> row " + rowNum, "");
        } else {
            Vector<Cell> CellRowVector = this.ParentSpreadsheet.getRow(rowNum);
            this.ParentSpreadsheet.setCellColumn(columnNum, CellRowVector);
            this.app.addLogParagraph("Transpose row " + rowNum + " -> " + column, "");
        }
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

